/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.read;

import java.io.Serializable;
import java.util.Objects;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.types.StructType;

@Evolving
public final class VariantAccessInfo
implements Serializable {
    private final String columnName;
    private final StructType extractedSchema;

    public VariantAccessInfo(String columnName, StructType extractedSchema) {
        this.columnName = Objects.requireNonNull(columnName, "columnName cannot be null");
        this.extractedSchema = Objects.requireNonNull(extractedSchema, "extractedSchema cannot be null");
    }

    public String columnName() {
        return this.columnName;
    }

    public StructType extractedSchema() {
        return this.extractedSchema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariantAccessInfo that = (VariantAccessInfo)o;
        return this.columnName.equals(that.columnName) && this.extractedSchema.equals((Object)that.extractedSchema);
    }

    public int hashCode() {
        return Objects.hash(this.columnName, this.extractedSchema);
    }

    public String toString() {
        return "VariantAccessInfo{columnName='" + this.columnName + "', extractedSchema=" + String.valueOf(this.extractedSchema) + "}";
    }
}

