/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.HllSketchAgg$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.CollationFactory;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr, lgConfigK) - Returns the HllSketch's updatable binary representation.\n      `lgConfigK` (optional) the log-base-2 of K, with K is the number of buckets or\n      slots for the HllSketch. ", examples="\n    Examples:\n      > SELECT hll_sketch_estimate(_FUNC_(col, 12)) FROM VALUES (1), (1), (2), (2), (3) tab(col);\n       3\n  ", group="agg_funcs", since="3.5.0")
@ScalaSignature(bytes="\u0006\u0005\tmf\u0001\u0002\u001d:\u0001\"C\u0001\u0002\u001e\u0001\u0003\u0016\u0004%\t!\u001e\u0005\tm\u0002\u0011\t\u0012)A\u00057\"Aq\u000f\u0001BK\u0002\u0013\u0005Q\u000f\u0003\u0005y\u0001\tE\t\u0015!\u0003\\\u0011!I\bA!f\u0001\n\u0003Q\b\u0002\u0003@\u0001\u0005#\u0005\u000b\u0011B>\t\u0011}\u0004!Q3A\u0005\u0002iD\u0011\"!\u0001\u0001\u0005#\u0005\u000b\u0011B>\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006!I\u0011\u0011\u0003\u0001\t\u0006\u0004%\tA\u001f\u0005\n\u0003'\u0001!\u0019!C\u0005\u0003+A\u0001\"!\b\u0001A\u0003%\u0011q\u0003\u0005\b\u0003\u0007\u0001A\u0011AA\u0010\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003KAq!a\u0001\u0001\t\u0003\tY\u0003C\u0004\u00022\u0001!\t%a\r\t\u000f\u0005e\u0002\u0001\"\u0011\u0002<!9\u0011\u0011\t\u0001\u0005R\u0005\r\u0003bBA'\u0001\u0011\u0005\u0013q\n\u0005\b\u0003C\u0002A\u0011IA2\u0011\u001d\t9\b\u0001C!\u0003sBq!!!\u0001\t\u0003\n\u0019\tC\u0004\u0002\f\u0002!\t%!$\t\u000f\u0005=\u0005\u0001\"\u0011\u0002\u0012\"9\u00111\u0015\u0001\u0005B\u0005\u0015\u0006bBAV\u0001\u0011\u0005\u0013Q\u0016\u0005\b\u0003o\u0003A\u0011IA]\u0011\u001d\tI\r\u0001C!\u0003\u0017D\u0011\"!5\u0001\u0003\u0003%\t!a5\t\u0013\u0005u\u0007!%A\u0005\u0002\u0005}\u0007\"CA{\u0001E\u0005I\u0011AAp\u0011%\t9\u0010AI\u0001\n\u0003\tI\u0010C\u0005\u0002~\u0002\t\n\u0011\"\u0001\u0002z\"I\u0011q \u0001\u0002\u0002\u0013\u0005#\u0011\u0001\u0005\t\u0005#\u0001\u0011\u0011!C\u0001u\"I!1\u0003\u0001\u0002\u0002\u0013\u0005!Q\u0003\u0005\n\u00057\u0001\u0011\u0011!C!\u0005;A\u0011Ba\u000b\u0001\u0003\u0003%\tA!\f\t\u0013\tE\u0002!!A\u0005B\tM\u0002\"\u0003B\u001c\u0001\u0005\u0005I\u0011\tB\u001d\u000f\u001d\u0011i&\u000fE\u0001\u0005?2a\u0001O\u001d\t\u0002\t\u0005\u0004bBA\u0002U\u0011\u0005!1\u000f\u0005\t\u0005kR#\u0019!C\u0005u\"9!q\u000f\u0016!\u0002\u0013Y\b\u0002\u0003B=U\t\u0007I\u0011\u0002>\t\u000f\tm$\u0006)A\u0005w\"9!Q\u0010\u0016\u0005\u0002\t}\u0004\"\u0003BEU\u0005\u0005I\u0011\u0011BF\u0011%\u0011)JKI\u0001\n\u0003\tI\u0010C\u0005\u0003\u0018*\n\n\u0011\"\u0001\u0002z\"I!\u0011\u0014\u0016\u0002\u0002\u0013\u0005%1\u0014\u0005\n\u0005[S\u0013\u0013!C\u0001\u0003sD\u0011Ba,+#\u0003%\t!!?\t\u0013\tE&&!A\u0005\n\tM&\u0001\u0004%mYN[W\r^2i\u0003\u001e<'B\u0001\u001e<\u0003%\twm\u001a:fO\u0006$XM\u0003\u0002={\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tqt(\u0001\u0005dCR\fG._:u\u0015\t\u0001\u0015)A\u0002tc2T!AQ\"\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0011+\u0015AB1qC\u000eDWMC\u0001G\u0003\ry'oZ\u0002\u0001'\u0019\u0001\u0011*V0cQB\u0019!jS'\u000e\u0003eJ!\u0001T\u001d\u00031QK\b/\u001a3J[B,'/\u0019;jm\u0016\fum\u001a:fO\u0006$X\r\u0005\u0002O'6\tqJ\u0003\u0002Q#\u0006\u0019\u0001\u000e\u001c7\u000b\u0005I\u001b\u0015\u0001\u00043bi\u0006\u001c8.\u001a;dQ\u0016\u001c\u0018B\u0001+P\u0005%AE\u000e\\*lKR\u001c\u0007\u000eE\u0002W3nk\u0011a\u0016\u0006\u00031v\nQ\u0001\u001e:fKNL!AW,\u0003\u0015\tKg.\u0019:z\u0019&\\W\r\u0005\u0002];6\t1(\u0003\u0002_w\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005q\u0003\u0017BA1<\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0002K\u0006)1oY1mC&\u0011q\r\u001a\u0002\b!J|G-^2u!\tI\u0017O\u0004\u0002k_:\u00111N\\\u0007\u0002Y*\u0011QnR\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015L!\u0001\u001d3\u0002\u000fA\f7m[1hK&\u0011!o\u001d\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003a\u0012\fA\u0001\\3giV\t1,A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\u0017[V$\u0018M\u00197f\u0003\u001e<')\u001e4gKJ|eMZ:fiV\t1\u0010\u0005\u0002dy&\u0011Q\u0010\u001a\u0002\u0004\u0013:$\u0018aF7vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;!\u0003QIg\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0006)\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0006\u0002\b\u0005%\u00111BA\u0007\u0003\u001f\u0001\"A\u0013\u0001\t\u000bQL\u0001\u0019A.\t\u000b]L\u0001\u0019A.\t\u000feL\u0001\u0013!a\u0001w\"9q0\u0003I\u0001\u0002\u0004Y\u0018!\u00037h\u0007>tg-[4L\u0003)!\u0018M]4fiRK\b/Z\u000b\u0003\u0003/\u00012ATA\r\u0013\r\tYb\u0014\u0002\u000b)\u001e$\b\n\u001c7UsB,\u0017a\u0003;be\u001e,G\u000fV=qK\u0002\"B!a\u0002\u0002\"!1\u00111E\u0007A\u0002m\u000bQa\u00195jY\u0012$b!a\u0002\u0002(\u0005%\u0002BBA\u0012\u001d\u0001\u00071\f\u0003\u0004\u0002\u00129\u0001\ra\u0017\u000b\u0007\u0003\u000f\ti#a\f\t\r\u0005\rr\u00021\u0001\\\u0011\u0019\t\tb\u0004a\u0001w\u0006ir/\u001b;i\u001d\u0016<X*\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000f\u0006\u0003\u0002\b\u0005U\u0002BBA\u001c!\u0001\u000710A\roK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\u0018aG<ji\"tUm^%oaV$\u0018iZ4Ck\u001a4WM](gMN,G\u000f\u0006\u0003\u0002\b\u0005u\u0002BBA #\u0001\u000710A\foK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0007\u0003\u000f\t)%!\u0013\t\r\u0005\u001d#\u00031\u0001\\\u0003\u001dqWm\u001e'fMRDa!a\u0013\u0013\u0001\u0004Y\u0016\u0001\u00038foJKw\r\u001b;\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002RA!\u00111KA.\u001d\u0011\t)&a\u0016\u0011\u0005-$\u0017bAA-I\u00061\u0001K]3eK\u001aLA!!\u0018\u0002`\t11\u000b\u001e:j]\u001eT1!!\u0017e\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003K\u0002R![A4\u0003WJ1!!\u001bt\u0005\r\u0019V-\u001d\t\u0005\u0003[\n\u0019(\u0004\u0002\u0002p)\u0019\u0011\u0011O \u0002\u000bQL\b/Z:\n\t\u0005U\u0014q\u000e\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003w\u0002B!!\u001c\u0002~%!\u0011qPA8\u0005!!\u0015\r^1UsB,\u0017\u0001\u00038vY2\f'\r\\3\u0016\u0005\u0005\u0015\u0005cA2\u0002\b&\u0019\u0011\u0011\u00123\u0003\u000f\t{w\u000e\\3b]\u000692M]3bi\u0016\fum\u001a:fO\u0006$\u0018n\u001c8Ck\u001a4WM\u001d\u000b\u0002\u001b\u00061Q\u000f\u001d3bi\u0016$R!TAJ\u0003/Ca!!&\u0019\u0001\u0004i\u0015AB:lKR\u001c\u0007\u000eC\u0004\u0002\u001ab\u0001\r!a'\u0002\u000b%t\u0007/\u001e;\u0011\t\u0005u\u0015qT\u0007\u0002{%\u0019\u0011\u0011U\u001f\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0006\u001b\u0006\u001d\u0016\u0011\u0016\u0005\u0007\u0003+K\u0002\u0019A'\t\r\u0005e\u0015\u00041\u0001N\u0003\u0011)g/\u00197\u0015\t\u0005=\u0016Q\u0017\t\u0004G\u0006E\u0016bAAZI\n\u0019\u0011I\\=\t\r\u0005U%\u00041\u0001N\u0003%\u0019XM]5bY&TX\r\u0006\u0003\u0002<\u0006\u001d\u0007#B2\u0002>\u0006\u0005\u0017bAA`I\n)\u0011I\u001d:bsB\u00191-a1\n\u0007\u0005\u0015GM\u0001\u0003CsR,\u0007BBAK7\u0001\u0007Q*A\u0006eKN,'/[1mSj,GcA'\u0002N\"9\u0011q\u001a\u000fA\u0002\u0005m\u0016A\u00022vM\u001a,'/\u0001\u0003d_BLHCCA\u0004\u0003+\f9.!7\u0002\\\"9A/\bI\u0001\u0002\u0004Y\u0006bB<\u001e!\u0003\u0005\ra\u0017\u0005\bsv\u0001\n\u00111\u0001|\u0011\u001dyX\u0004%AA\u0002m\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002b*\u001a1,a9,\u0005\u0005\u0015\b\u0003BAt\u0003cl!!!;\u000b\t\u0005-\u0018Q^\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a<e\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003g\fIOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005m(fA>\u0002d\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\u0004A!!Q\u0001B\b\u001b\t\u00119A\u0003\u0003\u0003\n\t-\u0011\u0001\u00027b]\u001eT!A!\u0004\u0002\t)\fg/Y\u0005\u0005\u0003;\u00129!\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005=&q\u0003\u0005\t\u00053!\u0013\u0011!a\u0001w\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\b\u0011\r\t\u0005\"qEAX\u001b\t\u0011\u0019CC\u0002\u0003&\u0011\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011ICa\t\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u000b\u0013y\u0003C\u0005\u0003\u001a\u0019\n\t\u00111\u0001\u00020\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0011\u0019A!\u000e\t\u0011\teq%!AA\u0002m\fa!Z9vC2\u001cH\u0003BAC\u0005wA\u0011B!\u0007)\u0003\u0003\u0005\r!a,)'\u0001\u0011yD!\u0012\u0003H\t-#Q\nB)\u0005'\u00129F!\u0017\u0011\u0007q\u0013\t%C\u0002\u0003Dm\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003J\u0005\tIJ\u0003\u0011!A\u0001zf)\u0016(D?\"*\u0007\u0010\u001d:-A1<7i\u001c8gS\u001e\\\u0015\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t%mYN[W\r^2iOM\u0004S\u000f\u001d3bi\u0006\u0014G.\u001a\u0011cS:\f'/\u001f\u0011sKB\u0014Xm]3oi\u0006$\u0018n\u001c8/\u0015\u0001\u0002\u0003\u0005\t\u0011!A2<7i\u001c8gS\u001e\\\u0005\r\t\u0015paRLwN\\1mS\u0001\"\b.\u001a\u0011m_\u001el#-Y:f[I\u0002sN\u001a\u0011LY\u0001:\u0018\u000e\u001e5!\u0017\u0002J7\u000f\t;iK\u0002rW/\u001c2fe\u0002zg\r\t2vG.,Go\u001d\u0011pe*\u0001\u0003\u0005\t\u0011!AMdw\u000e^:!M>\u0014\b\u0005\u001e5fA!cGnU6fi\u000eDg\u0006I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!qJ\u0001}\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002BG\u000e\\0tW\u0016$8\r[0fgRLW.\u0019;fQ}3UKT\"`Q\r|G\u000e\f\u00112e%J\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002B\u0013'\u000b\u0017!QEJC\u0006\t\u00153S1\u0002\u0003FM\u0015-A!\u001a\u0014\u0006\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AMR\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005+\n\u0011\"Y4h?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\tm\u0013!B\u001a/k9\u0002\u0014\u0001\u0004%mYN[W\r^2i\u0003\u001e<\u0007C\u0001&+'\u0015Q#1\rB5!\r\u0019'QM\u0005\u0004\u0005O\"'AB!osJ+g\r\u0005\u0003\u0003l\tETB\u0001B7\u0015\u0011\u0011yGa\u0003\u0002\u0005%|\u0017b\u0001:\u0003nQ\u0011!qL\u0001\r[&tGjZ\"p]\u001aLwmS\u0001\u000e[&tGjZ\"p]\u001aLwm\u0013\u0011\u0002\u00195\f\u0007\u0010T4D_:4\u0017nZ&\u0002\u001b5\f\u0007\u0010T4D_:4\u0017nZ&!\u0003!\u0019\u0007.Z2l\u0019\u001e\\E\u0003\u0002BA\u0005\u000f\u00032a\u0019BB\u0013\r\u0011)\t\u001a\u0002\u0005+:LG\u000f\u0003\u0004\u0002\u0012A\u0002\ra_\u0001\u0006CB\u0004H.\u001f\u000b\u000b\u0003\u000f\u0011iIa$\u0003\u0012\nM\u0005\"\u0002;2\u0001\u0004Y\u0006\"B<2\u0001\u0004Y\u0006bB=2!\u0003\u0005\ra\u001f\u0005\b\u007fF\u0002\n\u00111\u0001|\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u000fUt\u0017\r\u001d9msR!!Q\u0014BU!\u0015\u0019'q\u0014BR\u0013\r\u0011\t\u000b\u001a\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000f\r\u0014)kW.|w&\u0019!q\u00153\u0003\rQ+\b\u000f\\35\u0011%\u0011Y\u000bNA\u0001\u0002\u0004\t9!A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u00036B!!Q\u0001B\\\u0013\u0011\u0011ILa\u0002\u0003\r=\u0013'.Z2u\u0001")
public class HllSketchAgg
extends TypedImperativeAggregate<HllSketch>
implements BinaryLike<Expression>,
ExpectsInputTypes,
Serializable {
    private int lgConfigK;
    private final Expression left;
    private final Expression right;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private final TgtHllType targetType;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$4() {
        return HllSketchAgg$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return HllSketchAgg$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Expression, Expression, Object, Object>> unapply(HllSketchAgg x$0) {
        return HllSketchAgg$.MODULE$.unapply(x$0);
    }

    public static int apply$default$4() {
        return HllSketchAgg$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return HllSketchAgg$.MODULE$.apply$default$3();
    }

    public static void checkLgK(int lgConfigK) {
        HllSketchAgg$.MODULE$.checkLgK(lgConfigK);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        HllSketchAgg hllSketchAgg = this;
        synchronized (hllSketchAgg) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    /*
     * WARNING - void declaration
     */
    private int lgConfigK$lzycompute() {
        HllSketchAgg hllSketchAgg = this;
        synchronized (hllSketchAgg) {
            if (!this.bitmap$0) {
                void var2_2;
                int lgConfigK = BoxesRunTime.unboxToInt((Object)this.right().eval(this.right().eval$default$1()));
                HllSketchAgg$.MODULE$.checkLgK(lgConfigK);
                this.lgConfigK = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.lgConfigK;
    }

    public int lgConfigK() {
        if (!this.bitmap$0) {
            return this.lgConfigK$lzycompute();
        }
        return this.lgConfigK;
    }

    private TgtHllType targetType() {
        return this.targetType;
    }

    @Override
    public HllSketchAgg withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    @Override
    public HllSketchAgg withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, x$1);
    }

    @Override
    public HllSketchAgg withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public String prettyName() {
        return "hll_sketch_agg";
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegerType$.MODULE$, LongType$.MODULE$, StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), BinaryType$.MODULE$})), (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public HllSketch createAggregationBuffer() {
        return new HllSketch(this.lgConfigK(), this.targetType());
    }

    @Override
    public HllSketch update(HllSketch sketch, InternalRow input) {
        Object v = this.left().eval(input);
        if (v != null) {
            DataType dataType = this.left().dataType();
            if (IntegerType$.MODULE$.equals(dataType)) {
                sketch.update((long)BoxesRunTime.unboxToInt((Object)v));
            } else if (LongType$.MODULE$.equals(dataType)) {
                sketch.update(BoxesRunTime.unboxToLong((Object)v));
            } else if (dataType instanceof StringType) {
                StringType stringType = (StringType)dataType;
                CollationFactory.Collation collation = CollationFactory.fetchCollation((int)stringType.collationId());
                UTF8String str = (UTF8String)v;
                if (!Predef$.MODULE$.Boolean2boolean((Boolean)collation.equalsFunction.apply(str, UTF8String.EMPTY_UTF8))) {
                    sketch.update((byte[])collation.sortKeyFunction.apply(str));
                }
            } else if (BinaryType$.MODULE$.equals(dataType)) {
                sketch.update((byte[])v);
            } else {
                throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3121", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType.toString())})));
            }
        }
        return sketch;
    }

    @Override
    public HllSketch merge(HllSketch sketch, HllSketch input) {
        Union union = new Union(sketch.getLgConfigK());
        union.update(sketch);
        union.update(input);
        return union.getResult(this.targetType());
    }

    @Override
    public Object eval(HllSketch sketch) {
        return sketch.toUpdatableByteArray();
    }

    @Override
    public byte[] serialize(HllSketch sketch) {
        return sketch.toUpdatableByteArray();
    }

    @Override
    public HllSketch deserialize(byte[] buffer) {
        return HllSketch.heapify((byte[])buffer);
    }

    public HllSketchAgg copy(Expression left, Expression right, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new HllSketchAgg(left, right, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "HllSketchAgg";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HllSketchAgg;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
            case 2: {
                return "mutableAggBufferOffset";
            }
            case 3: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HllSketchAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        HllSketchAgg hllSketchAgg = (HllSketchAgg)x$1;
        if (this.mutableAggBufferOffset() != hllSketchAgg.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != hllSketchAgg.inputAggBufferOffset()) return false;
        Expression expression = this.left();
        Expression expression2 = hllSketchAgg.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = hllSketchAgg.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!hllSketchAgg.canEqual(this)) return false;
        return true;
    }

    public HllSketchAgg(Expression left, Expression right, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.left = left;
        this.right = right;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        BinaryLike.$init$(this);
        ExpectsInputTypes.$init$(this);
        this.targetType = TgtHllType.HLL_8;
    }

    public HllSketchAgg(Expression child) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)12)), 0, 0);
    }

    public HllSketchAgg(Expression child, Expression lgConfigK) {
        this(child, lgConfigK, 0, 0);
    }

    public HllSketchAgg(Expression child, int lgConfigK) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)lgConfigK)), 0, 0);
    }
}

