/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.repoinit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sling.repoinit.parser.operations.AclLine;
import org.apache.sling.repoinit.parser.operations.SetAclPrincipalBased;
import org.jetbrains.annotations.NotNull;

class ConversionMap {
    private final Map<Key, List<AclLine>> map = new LinkedHashMap<Key, List<AclLine>>();

    ConversionMap() {
    }

    void put(@NotNull String principalName, @NotNull List<String> options, @NotNull AclLine line) {
        List lineList = this.map.computeIfAbsent(new Key(principalName, options), k -> new ArrayList());
        lineList.add(line);
    }

    void putAll(@NotNull String principalName, @NotNull List<String> options, @NotNull Collection<AclLine> lines) {
        List lineList = this.map.computeIfAbsent(new Key(principalName, options), k -> new ArrayList());
        lineList.addAll(lines);
    }

    void generateRepoInit(@NotNull Formatter formatter) {
        for (Map.Entry<Key, List<AclLine>> entry : this.map.entrySet()) {
            String principalName = entry.getKey().principalName;
            SetAclPrincipalBased operation = new SetAclPrincipalBased(Collections.singletonList(principalName), entry.getValue(), entry.getKey().options);
            formatter.format("%s", operation.asRepoInitString());
        }
        this.map.clear();
    }

    private static final class Key {
        private final String principalName;
        private final List<String> options;

        private Key(@NotNull String principalName, @NotNull List<String> options) {
            this.principalName = principalName;
            this.options = options;
        }

        public int hashCode() {
            return Objects.hash(this.principalName, this.options);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return this.principalName.equals(other.principalName) && this.options.equals(other.options);
            }
            return false;
        }
    }
}

