/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.google.common.collect.ImmutableSet;
import io.wcm.handler.media.MediaArgs;
import io.wcm.handler.media.MediaFileType;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.format.Ratio;
import io.wcm.handler.media.format.impl.MediaFormatSupport;
import io.wcm.handler.media.format.impl.MediaFormatVisitor;
import io.wcm.handler.mediasource.dam.AssetRendition;
import io.wcm.handler.mediasource.dam.impl.DamContext;
import io.wcm.handler.mediasource.dam.impl.RenditionHandler;
import io.wcm.handler.mediasource.dam.impl.RenditionMetadata;
import io.wcm.handler.mediasource.dam.impl.VirtualRenditionMetadata;
import io.wcm.handler.mediasource.dam.impl.VirtualTransformedRenditionMetadata;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DefaultRenditionHandler
implements RenditionHandler {
    private Set<RenditionMetadata> renditions;
    private final RenditionMetadata originalRendition;
    private final DamContext damContext;

    DefaultRenditionHandler(DamContext damContext) {
        this.damContext = damContext;
        Rendition damOriginalRendition = damContext.getAsset().getOriginal();
        this.originalRendition = damOriginalRendition != null ? new RenditionMetadata(damOriginalRendition) : null;
    }

    protected RenditionMetadata getOriginalRendition() {
        return this.originalRendition;
    }

    Set<RenditionMetadata> getAvailableRenditions(MediaArgs mediaArgs) {
        if (this.renditions == null) {
            Set<RenditionMetadata> candidates = new TreeSet<RenditionMetadata>();
            for (Rendition rendition : this.damContext.getAsset().getRenditions()) {
                this.addRendition(candidates, rendition, mediaArgs);
            }
            candidates = this.postProcessCandidates(candidates);
            this.renditions = ImmutableSet.copyOf(candidates);
        }
        return this.renditions;
    }

    protected Set<RenditionMetadata> postProcessCandidates(Set<RenditionMetadata> candidates) {
        return candidates;
    }

    private void addRendition(Set<RenditionMetadata> candidates, Rendition rendition, MediaArgs mediaArgs) {
        boolean isIncludeAssetWebRenditions;
        if (!mediaArgs.isIncludeAssetThumbnails() && AssetRendition.isThumbnailRendition(rendition)) {
            return;
        }
        boolean bl = isIncludeAssetWebRenditions = mediaArgs.isIncludeAssetWebRenditions() != null ? mediaArgs.isIncludeAssetWebRenditions() : true;
        if (!isIncludeAssetWebRenditions && AssetRendition.isWebRendition(rendition)) {
            return;
        }
        RenditionMetadata renditionMetadata = this.createRenditionMetadata(rendition);
        candidates.add(renditionMetadata);
    }

    protected RenditionMetadata createRenditionMetadata(Rendition rendition) {
        return new RenditionMetadata(rendition);
    }

    private Set<RenditionMetadata> getRendtionsMatchingFileExtensions(String[] fileExtensions, MediaArgs mediaArgs) {
        Set<RenditionMetadata> allRenditions = this.getAvailableRenditions(mediaArgs);
        if (fileExtensions == null || fileExtensions.length == 0) {
            return allRenditions;
        }
        TreeSet<RenditionMetadata> matchingRenditions = new TreeSet<RenditionMetadata>();
        block0: for (RenditionMetadata rendition : allRenditions) {
            for (String fileExtension : fileExtensions) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)fileExtension, (CharSequence)rendition.getFileExtension())) continue;
                matchingRenditions.add(rendition);
                continue block0;
            }
        }
        return matchingRenditions;
    }

    @Override
    public RenditionMetadata getRendition(MediaArgs mediaArgs) {
        String[] requestedFileExtensions = MediaFormatSupport.getRequestedFileExtensions(mediaArgs);
        if (requestedFileExtensions == null) {
            return null;
        }
        boolean isSizeMatchingRequest = this.isSizeMatchingRequest(mediaArgs, requestedFileExtensions);
        Set<RenditionMetadata> candidates = this.getRendtionsMatchingFileExtensions(requestedFileExtensions, mediaArgs);
        if (!isSizeMatchingRequest) {
            return this.getOriginalOrFirstRendition(candidates);
        }
        RenditionMetadata exactMatchRendition = this.getExactMatchRendition(candidates, mediaArgs);
        if (exactMatchRendition != null) {
            return exactMatchRendition;
        }
        RenditionMetadata virtualRendition = this.getVirtualRendition(candidates, mediaArgs);
        if (virtualRendition != null) {
            return virtualRendition;
        }
        return null;
    }

    private boolean isSizeMatchingRequest(MediaArgs mediaArgs, String[] requestedFileExtensions) {
        boolean anyImageFileExtension = false;
        for (String fileExtension : requestedFileExtensions) {
            if (!MediaFileType.isImage(fileExtension)) continue;
            anyImageFileExtension = true;
        }
        if (!anyImageFileExtension && mediaArgs.getFixedWidth() == 0L && mediaArgs.getFixedHeight() == 0L) {
            return false;
        }
        if (mediaArgs.getFixedWidth() > 0L || mediaArgs.getFixedHeight() > 0L) {
            return true;
        }
        Boolean isSizeMatchingMediaFormat = MediaFormatSupport.visitMediaFormats(mediaArgs, new MediaFormatVisitor<Boolean>(){

            @Override
            @Nullable
            public Boolean visit(@NotNull MediaFormat mediaFormat) {
                if (mediaFormat.getEffectiveMinWidth() > 0L || mediaFormat.getEffectiveMaxWidth() > 0L || mediaFormat.getEffectiveMinHeight() > 0L || mediaFormat.getEffectiveMaxHeight() > 0L || mediaFormat.getRatio() > 0.0) {
                    return true;
                }
                return null;
            }
        });
        return isSizeMatchingMediaFormat != null && isSizeMatchingMediaFormat != false;
    }

    private RenditionMetadata getExactMatchRendition(final Set<RenditionMetadata> candidates, MediaArgs mediaArgs) {
        if (mediaArgs.getFixedWidth() > 0L || mediaArgs.getFixedHeight() > 0L) {
            for (RenditionMetadata candidate : candidates) {
                if (!candidate.matches(mediaArgs.getFixedWidth(), mediaArgs.getFixedHeight())) continue;
                return candidate;
            }
        } else {
            if (mediaArgs.getMediaFormats() != null && mediaArgs.getMediaFormats().length > 0) {
                return MediaFormatSupport.visitMediaFormats(mediaArgs, new MediaFormatVisitor<RenditionMetadata>(){

                    @Override
                    @Nullable
                    public RenditionMetadata visit(@NotNull MediaFormat mediaFormat) {
                        for (RenditionMetadata candidate : candidates) {
                            if (!candidate.matches((int)mediaFormat.getEffectiveMinWidth(), (int)mediaFormat.getEffectiveMinHeight(), (int)mediaFormat.getEffectiveMaxWidth(), (int)mediaFormat.getEffectiveMaxHeight(), mediaFormat.getRatio())) continue;
                            candidate.setMediaFormat(mediaFormat);
                            return candidate;
                        }
                        return null;
                    }
                });
            }
            return this.getOriginalOrFirstRendition(candidates);
        }
        return null;
    }

    private RenditionMetadata getOriginalOrFirstRendition(Set<RenditionMetadata> candidates) {
        if (this.originalRendition != null && candidates.contains(this.originalRendition)) {
            return this.originalRendition;
        }
        if (!candidates.isEmpty()) {
            return candidates.iterator().next();
        }
        return null;
    }

    private RenditionMetadata getVirtualRendition(final Set<RenditionMetadata> candidates, MediaArgs mediaArgs) {
        if (mediaArgs.getFixedWidth() > 0L || mediaArgs.getFixedHeight() > 0L) {
            long destWidth = mediaArgs.getFixedWidth();
            long destHeight = mediaArgs.getFixedHeight();
            double destRatio = 0.0;
            if (destWidth > 0L && destHeight > 0L) {
                destRatio = Ratio.get(destWidth, destHeight);
            }
            return this.getVirtualRendition(candidates, destWidth, destHeight, destRatio);
        }
        return MediaFormatSupport.visitMediaFormats(mediaArgs, new MediaFormatVisitor<RenditionMetadata>(){

            @Override
            @Nullable
            public RenditionMetadata visit(@NotNull MediaFormat mediaFormat) {
                double destRatio;
                int destHeight;
                int destWidth = (int)mediaFormat.getEffectiveMinWidth();
                RenditionMetadata rendition = DefaultRenditionHandler.this.getVirtualRendition(candidates, destWidth, destHeight = (int)mediaFormat.getEffectiveMinHeight(), destRatio = mediaFormat.getRatio());
                if (rendition != null) {
                    rendition.setMediaFormat(mediaFormat);
                }
                return rendition;
            }
        });
    }

    private RenditionMetadata getVirtualRendition(Set<RenditionMetadata> candidates, long destWidth, long destHeight, double destRatio) {
        if (destRatio > 0.0) {
            for (RenditionMetadata candidate : candidates) {
                if (!candidate.matches(destWidth, destHeight, 0L, 0L, destRatio)) continue;
                return this.getVirtualRendition(candidate, destWidth, destHeight, destRatio);
            }
        } else {
            for (RenditionMetadata candidate : candidates) {
                if (!candidate.matches(destWidth, destHeight, 0L, 0L, 0.0)) continue;
                return this.getVirtualRendition(candidate, destWidth, destHeight, 0.0);
            }
        }
        return null;
    }

    private RenditionMetadata getVirtualRendition(RenditionMetadata rendition, long widthValue, long heightValue, double ratioValue) {
        long width = widthValue;
        long height = heightValue;
        double ratio = ratioValue;
        if (ratio < 0.05) {
            ratio = Ratio.get(rendition.getWidth(), rendition.getHeight());
        }
        if (height == 0L && width > 0L) {
            height = (int)Math.round((double)width / ratio);
        }
        if (width == 0L && height > 0L) {
            width = (int)Math.round((double)height * ratio);
        }
        if (width > 0L && height > 0L) {
            if (rendition instanceof VirtualTransformedRenditionMetadata) {
                VirtualTransformedRenditionMetadata cropRendition = (VirtualTransformedRenditionMetadata)rendition;
                return new VirtualTransformedRenditionMetadata(cropRendition.getRendition(), width, height, cropRendition.getCropDimension(), cropRendition.getRotation());
            }
            return new VirtualRenditionMetadata(rendition.getRendition(), width, height);
        }
        return null;
    }

    protected Asset getAsset() {
        return this.damContext.getAsset();
    }
}

