/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.util.List;
import java.util.Optional;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.storage.AbstractResource;
import org.apache.sis.storage.DataSet;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.aggregate.MergeStrategy;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.internal.shared.Strings;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.GenericName;

abstract class AggregatedResource
extends AbstractResource {
    GenericName identifier;
    private String name;
    private ImmutableEnvelope envelope;
    private boolean envelopeIsEvaluated;

    AggregatedResource(String name, StoreListeners listeners, boolean hidden) {
        super(listeners, hidden);
        this.name = name;
    }

    AggregatedResource(Resource parent, String name) {
        super(parent);
        this.name = name;
    }

    AggregatedResource(AggregatedResource source) {
        super(source.listeners, true);
        this.name = source.name;
        this.envelope = source.envelope;
        this.envelopeIsEvaluated = source.envelopeIsEvaluated;
    }

    Resource apply(MergeStrategy strategy) {
        return this;
    }

    final Resource configureReplacement(Resource single) {
        if (single instanceof AggregatedResource) {
            ((AggregatedResource)single).name = this.name;
        }
        return single;
    }

    @Override
    public final Optional<GenericName> getIdentifier() {
        return Optional.ofNullable(this.identifier);
    }

    @Override
    protected final Metadata createMetadata() throws DataStoreException {
        MetadataBuilder builder = new MetadataBuilder();
        builder.addTitle(this.name);
        this.createMetadata(builder);
        return builder.build();
    }

    abstract void createMetadata(MetadataBuilder var1) throws DataStoreException;

    abstract List<Resource> components();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Optional<Envelope> getEnvelope() throws DataStoreException {
        Object object = this.getSynchronizationLock();
        synchronized (object) {
            if (!this.envelopeIsEvaluated) {
                List<Resource> components = this.components();
                Envelope[] envelopes = new Envelope[components.size()];
                for (int i = 0; i < envelopes.length; ++i) {
                    Optional<Envelope> re;
                    Resource r = components.get(i);
                    if (r instanceof DataSet) {
                        re = ((DataSet)r).getEnvelope();
                    } else {
                        if (!(r instanceof AbstractResource)) continue;
                        re = ((AbstractResource)r).getEnvelope();
                    }
                    envelopes[i] = re.orElse(null);
                }
                try {
                    this.envelope = ImmutableEnvelope.castOrCopy((Envelope)Envelopes.union((Envelope[])envelopes));
                }
                catch (TransformException e) {
                    this.listeners.warning((Exception)((Object)e));
                }
                this.envelopeIsEvaluated = true;
            }
            return Optional.ofNullable(this.envelope);
        }
    }

    public String toString() {
        return Strings.toString(this.getClass(), (Object[])new Object[]{"name", this.name, "size", this.components().size()});
    }
}

