/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal.shared;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.referencing.internal.ImmutableAffineTransform;
import org.apache.sis.referencing.internal.LinearTransform2D;
import org.apache.sis.referencing.internal.shared.AffineMatrix;
import org.apache.sis.referencing.internal.shared.ExtendedPrecisionMatrix;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.provider.Affine;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;

public class AffineTransform2D
extends ImmutableAffineTransform
implements LinearTransform2D,
LenientComparable,
Parameterized {
    private static final long serialVersionUID = -5299837898367149069L;
    static final int DIMENSION = 2;
    private AffineMatrix matrix;
    private volatile transient AffineTransform2D inverse;

    public AffineTransform2D(AffineTransform transform) {
        super(transform);
        this.freeze();
    }

    public AffineTransform2D(double[] elements) {
        super(elements);
        this.freeze();
    }

    private AffineTransform2D(Number[] elements) {
        super(AffineTransform2D.doubleValue(elements[0]), AffineTransform2D.doubleValue(elements[3]), AffineTransform2D.doubleValue(elements[1]), AffineTransform2D.doubleValue(elements[4]), AffineTransform2D.doubleValue(elements[2]), AffineTransform2D.doubleValue(elements[5]));
        this.matrix = new AffineMatrix.ExtendedPrecision(this, elements);
    }

    private static double doubleValue(Number value) {
        return value != null ? AffineTransform2D.pz(value.doubleValue()) : 0.0;
    }

    public AffineTransform2D(double m00, double m10, double m01, double m11, double m02, double m12) {
        super(AffineTransform2D.pz(m00), AffineTransform2D.pz(m10), AffineTransform2D.pz(m01), AffineTransform2D.pz(m11), AffineTransform2D.pz(m02), AffineTransform2D.pz(m12));
        this.matrix = new AffineMatrix(this);
    }

    public AffineTransform2D(double m00, double m10, double m01, double m11, double m02, double m12, boolean modifiable) {
        super(m00, m10, m01, m11, m02, m12);
        if (!modifiable) {
            this.freeze();
        }
    }

    private static double pz(double value) {
        return value != 0.0 ? value : 0.0;
    }

    public static AffineTransform2D create(Matrix matrix) {
        if (matrix instanceof ExtendedPrecisionMatrix) {
            return new AffineTransform2D(((ExtendedPrecisionMatrix)matrix).getElementAsNumbers(false));
        }
        return new AffineTransform2D(matrix.getElement(0, 0), matrix.getElement(1, 0), matrix.getElement(0, 1), matrix.getElement(1, 1), matrix.getElement(0, 2), matrix.getElement(1, 2));
    }

    public final void freeze() {
        super.setTransform(AffineTransform2D.pz(super.getScaleX()), AffineTransform2D.pz(super.getShearY()), AffineTransform2D.pz(super.getShearX()), AffineTransform2D.pz(super.getScaleY()), AffineTransform2D.pz(super.getTranslateX()), AffineTransform2D.pz(super.getTranslateY()));
        this.matrix = new AffineMatrix(this);
    }

    @Override
    protected final void checkPermission() throws UnsupportedOperationException {
        if (this.matrix != null) {
            super.checkPermission();
        }
    }

    @Override
    public final boolean isAffine() {
        return true;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Affine.provider().getParameters();
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return Affine.parameters(this.matrix);
    }

    public final int getSourceDimensions() {
        return 2;
    }

    public final int getTargetDimensions() {
        return 2;
    }

    public final DirectPosition transform(DirectPosition ptSrc, DirectPosition ptDst) {
        ArgumentChecks.ensureDimensionMatches((String)"ptSrc", (int)2, (DirectPosition)ptSrc);
        if (ptDst == ptSrc) {
            if (ptSrc instanceof Point2D) {
                Point2D point = (Point2D)ptSrc;
                super.transform(point, point);
                return ptSrc;
            }
        } else {
            if (ptDst == null) {
                DirectPosition2D point = new DirectPosition2D(ptSrc.getOrdinate(0), ptSrc.getOrdinate(1));
                super.transform(point, point);
                return point;
            }
            ArgumentChecks.ensureDimensionMatches((String)"ptDst", (int)2, (DirectPosition)ptDst);
            if (ptDst instanceof Point2D) {
                Point2D point = (Point2D)ptDst;
                point.setLocation(ptSrc.getOrdinate(0), ptSrc.getOrdinate(1));
                super.transform(point, point);
                return ptDst;
            }
        }
        Point2D.Double point = new Point2D.Double(ptSrc.getOrdinate(0), ptSrc.getOrdinate(1));
        super.transform(point, point);
        ptDst.setOrdinate(0, point.x);
        ptDst.setOrdinate(1, point.y);
        return ptDst;
    }

    @Override
    public final Shape createTransformedShape(Shape shape) {
        return AffineTransforms2D.transform((AffineTransform)this, shape, false);
    }

    @Override
    public final Matrix getMatrix() {
        return this.matrix;
    }

    public final Matrix derivative(Point2D point) {
        return new Matrix2(this.getScaleX(), this.getShearX(), this.getShearY(), this.getScaleY());
    }

    public final Matrix derivative(DirectPosition point) {
        return this.derivative((Point2D)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AffineTransform2D inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            if (super.isIdentity()) {
                this.inverse = this;
            } else {
                AffineTransform2D affineTransform2D = this;
                synchronized (affineTransform2D) {
                    if (this.inverse == null) {
                        AffineTransform2D work = AffineTransform2D.create(Matrices.inverse(this.matrix));
                        work.inverse = this;
                        this.inverse = work;
                    }
                }
            }
        }
        return this.inverse;
    }

    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (mode == ComparisonMode.STRICT) {
            return this.equals(object);
        }
        if (object instanceof LinearTransform) {
            Matrix m2 = ((LinearTransform)object).getMatrix();
            return AffineTransforms2D.toMatrix(this).equals((Object)m2, mode);
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object != this) {
            if (!super.equals(object)) {
                return false;
            }
            if (object instanceof AffineTransform2D) {
                return object.getClass() == this.getClass();
            }
        }
        return true;
    }

    @Override
    public AffineTransform clone() {
        return new AffineTransform(this);
    }

    public String toWKT() {
        Formatter formatter = new Formatter();
        formatter.append(this);
        return formatter.toWKT();
    }

    @Override
    public String toString() {
        return Matrices.toString(this.getMatrix());
    }
}

