/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.utils;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.shenyu.common.exception.ShenyuException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AesUtils.class);

    public static String cbcEncrypt(String secretKeyStr, String ivStr, String data) {
        String encryptStr;
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] secretKeyBytes = secretKeyStr.getBytes(StandardCharsets.UTF_8);
        byte[] ivBytes = ivStr.getBytes(StandardCharsets.UTF_8);
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secretKeyBytes, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/Pkcs7Padding");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ivBytes);
            cipher.init(1, (Key)secretKey, ivParameterSpec);
            byte[] encryptedBytes = cipher.doFinal(data.getBytes());
            encryptStr = Base64.getEncoder().encodeToString(encryptedBytes);
        }
        catch (Exception e) {
            LOG.error("aes encrypt fail. cause:{}", (Object)e.getMessage());
            throw new ShenyuException(e);
        }
        return encryptStr;
    }

    public static String cbcDecrypt(String secretKeyStr, String ivStr, String data) {
        String decryptStr;
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] secretKeyBytes = secretKeyStr.getBytes(StandardCharsets.UTF_8);
        byte[] ivBytes = ivStr.getBytes(StandardCharsets.UTF_8);
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secretKeyBytes, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/Pkcs7Padding");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ivBytes);
            cipher.init(2, (Key)secretKey, ivParameterSpec);
            byte[] decryptedBytes = cipher.doFinal(Base64.getDecoder().decode(data));
            decryptStr = new String(decryptedBytes);
        }
        catch (Exception e) {
            LOG.error("aes decrypt fail. cause:{}", (Object)e.getMessage());
            throw new ShenyuException(e);
        }
        return decryptStr;
    }
}

