/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc;

import java.util.concurrent.CompletableFuture;
import org.apache.dubbo.common.threadlocal.InternalThreadLocal;
import org.apache.dubbo.rpc.protocol.dubbo.FutureAdapter;

public class FutureContext {
    private static final InternalThreadLocal<FutureContext> futureTL = new InternalThreadLocal<FutureContext>(){

        @Override
        protected FutureContext initialValue() {
            return new FutureContext();
        }
    };
    private CompletableFuture<?> future;
    private CompletableFuture<?> compatibleFuture;
    private static final boolean clearFutureAfterGet = Boolean.parseBoolean(System.getProperty("future.clear.once", "false"));

    public static FutureContext getContext() {
        return futureTL.get();
    }

    public <T> CompletableFuture<T> getCompletableFuture() {
        try {
            CompletableFuture<?> completableFuture = this.future;
            return completableFuture;
        }
        finally {
            if (clearFutureAfterGet) {
                this.future = null;
            }
        }
    }

    public void setFuture(CompletableFuture<?> future) {
        this.future = future;
    }

    @Deprecated
    public <T> CompletableFuture<T> getCompatibleCompletableFuture() {
        try {
            CompletableFuture<?> completableFuture = this.compatibleFuture;
            return completableFuture;
        }
        finally {
            if (clearFutureAfterGet) {
                this.compatibleFuture = null;
            }
        }
    }

    @Deprecated
    public void setCompatibleFuture(CompletableFuture<?> compatibleFuture) {
        this.compatibleFuture = compatibleFuture;
        if (compatibleFuture != null) {
            this.setFuture(new FutureAdapter(compatibleFuture));
        }
    }
}

