/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.messaging;

import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractDescribedListTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.ProtonStreamUtils;
import org.apache.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.Properties;

public final class PropertiesTypeDecoder
extends AbstractDescribedListTypeDecoder<Properties> {
    private static final int MIN_PROPERTIES_LIST_ENTRIES = 0;
    private static final int MAX_PROPERTIES_LIST_ENTRIES = 13;

    @Override
    public UnsignedLong getDescriptorCode() {
        return Properties.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Properties.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Class<Properties> getTypeClass() {
        return Properties.class;
    }

    @Override
    public Properties readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readProperties(buffer, state, (ListTypeDecoder)PropertiesTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Properties[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        ListTypeDecoder listDecoder = (ListTypeDecoder)PropertiesTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder);
        Properties[] result = new Properties[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readProperties(buffer, state, listDecoder);
        }
        return result;
    }

    private Properties readProperties(ProtonBuffer buffer, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Properties properties = new Properties();
        int size = listDecoder.readSize(buffer, state);
        int count = listDecoder.readCount(buffer, state);
        if (count < 0) {
            throw new DecodeException("Not enough entries in Properties list encoding: " + count);
        }
        if (count > 13) {
            throw new DecodeException("To many entries in Properties list encoding: " + count);
        }
        block15: for (int index = 0; index < count; ++index) {
            boolean nullValue;
            boolean bl = nullValue = buffer.getByte(buffer.getReadOffset()) == 64;
            if (nullValue) {
                buffer.readByte();
                continue;
            }
            switch (index) {
                case 0: {
                    properties.setMessageId(state.getDecoder().readObject(buffer, state));
                    continue block15;
                }
                case 1: {
                    properties.setUserId(state.getDecoder().readBinary(buffer, state));
                    continue block15;
                }
                case 2: {
                    properties.setTo(state.getDecoder().readString(buffer, state));
                    continue block15;
                }
                case 3: {
                    properties.setSubject(state.getDecoder().readString(buffer, state));
                    continue block15;
                }
                case 4: {
                    properties.setReplyTo(state.getDecoder().readString(buffer, state));
                    continue block15;
                }
                case 5: {
                    properties.setCorrelationId(state.getDecoder().readObject(buffer, state));
                    continue block15;
                }
                case 6: {
                    properties.setContentType(state.getDecoder().readSymbol(buffer, state, null));
                    continue block15;
                }
                case 7: {
                    properties.setContentEncoding(state.getDecoder().readSymbol(buffer, state, null));
                    continue block15;
                }
                case 8: {
                    properties.setAbsoluteExpiryTime(state.getDecoder().readTimestamp(buffer, state, 0L));
                    continue block15;
                }
                case 9: {
                    properties.setCreationTime(state.getDecoder().readTimestamp(buffer, state, 0L));
                    continue block15;
                }
                case 10: {
                    properties.setGroupId(state.getDecoder().readString(buffer, state));
                    continue block15;
                }
                case 11: {
                    properties.setGroupSequence(state.getDecoder().readUnsignedInteger(buffer, state, 0L));
                    continue block15;
                }
                case 12: {
                    properties.setReplyToGroupId(state.getDecoder().readString(buffer, state));
                }
            }
        }
        return properties;
    }

    @Override
    public Properties readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readProperties(stream, state, (ListTypeDecoder)PropertiesTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Properties[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        ListTypeDecoder listDecoder = (ListTypeDecoder)PropertiesTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder);
        Properties[] result = new Properties[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readProperties(stream, state, listDecoder);
        }
        return result;
    }

    private Properties readProperties(InputStream stream, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Properties properties = new Properties();
        int size = listDecoder.readSize(stream, state);
        int count = listDecoder.readCount(stream, state);
        if (count < 0) {
            throw new DecodeException("Not enough entries in Properties list encoding: " + count);
        }
        if (count > 13) {
            throw new DecodeException("To many entries in Properties list encoding: " + count);
        }
        block15: for (int index = 0; index < count; ++index) {
            if (stream.markSupported()) {
                stream.mark(1);
                if (ProtonStreamUtils.readByte(stream) == 64) continue;
                ProtonStreamUtils.reset(stream);
            }
            switch (index) {
                case 0: {
                    properties.setMessageId(state.getDecoder().readObject(stream, state));
                    continue block15;
                }
                case 1: {
                    properties.setUserId(state.getDecoder().readBinary(stream, state));
                    continue block15;
                }
                case 2: {
                    properties.setTo(state.getDecoder().readString(stream, state));
                    continue block15;
                }
                case 3: {
                    properties.setSubject(state.getDecoder().readString(stream, state));
                    continue block15;
                }
                case 4: {
                    properties.setReplyTo(state.getDecoder().readString(stream, state));
                    continue block15;
                }
                case 5: {
                    properties.setCorrelationId(state.getDecoder().readObject(stream, state));
                    continue block15;
                }
                case 6: {
                    properties.setContentType(state.getDecoder().readSymbol(stream, state, null));
                    continue block15;
                }
                case 7: {
                    properties.setContentEncoding(state.getDecoder().readSymbol(stream, state, null));
                    continue block15;
                }
                case 8: {
                    properties.setAbsoluteExpiryTime(state.getDecoder().readTimestamp(stream, state, 0L));
                    continue block15;
                }
                case 9: {
                    properties.setCreationTime(state.getDecoder().readTimestamp(stream, state, 0L));
                    continue block15;
                }
                case 10: {
                    properties.setGroupId(state.getDecoder().readString(stream, state));
                    continue block15;
                }
                case 11: {
                    properties.setGroupSequence(state.getDecoder().readUnsignedInteger(stream, state, 0L));
                    continue block15;
                }
                case 12: {
                    properties.setReplyToGroupId(state.getDecoder().readString(stream, state));
                }
            }
        }
        return properties;
    }
}

