﻿/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using Apache.Qpid.Proton.Client;

namespace Apache.Qpid.Proton.Examples.HelloWorld
{
   class Program
   {
      static void Main(string[] args)
      {
         string serverHost = Environment.GetEnvironmentVariable("HOST") ?? "localhost";
         int serverPort = Convert.ToInt32(Environment.GetEnvironmentVariable("PORT") ?? "5672");
         string address = Environment.GetEnvironmentVariable("ADDRESS") ?? "request-respond-example";

         IClient client = IClient.Create();

         ConnectionOptions options = new ConnectionOptions();
         options.User = Environment.GetEnvironmentVariable("USER");
         options.Password = Environment.GetEnvironmentVariable("PASSWORD");

         ReceiverOptions receiverOptions = new ReceiverOptions();
         receiverOptions.SourceOptions.Capabilities = new string[] { "queue" };

         using IConnection connection = client.Connect(serverHost, serverPort, options);
         using IReceiver receiver = connection.OpenReceiver(address, receiverOptions);

         IDelivery request = receiver.Receive(TimeSpan.FromSeconds(60));
         if (request != null)
         {
            IMessage<object> received = request.Message();
            Console.WriteLine("Received message with body: " + received.Body);

            String replyAddress = received.ReplyTo;
            if (replyAddress != null)
            {
               ISender sender = connection.OpenSender(replyAddress);
               sender.Send(IMessage<string>.Create("Response"));
            }
         }
         else
         {
            Console.WriteLine("Failed to read a message during the defined wait interval.");
         }
      }
   }
}
