/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.nonpersistent;

import com.google.common.annotations.VisibleForTesting;
import io.netty.util.concurrent.FastThreadLocal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.ConsistentHashingStickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.EntryBatchSizes;
import org.apache.pulsar.broker.service.HashRangeAutoSplitStickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.HashRangeExclusiveStickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.SendMessageInfo;
import org.apache.pulsar.broker.service.StickyKeyConsumerSelector;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.nonpersistent.NonPersistentDispatcherMultipleConsumers;
import org.apache.pulsar.broker.service.nonpersistent.NonPersistentTopic;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.api.proto.KeySharedMeta;
import org.apache.pulsar.common.api.proto.KeySharedMode;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonPersistentStickyKeyDispatcherMultipleConsumers
extends NonPersistentDispatcherMultipleConsumers {
    private final StickyKeyConsumerSelector selector;
    private final KeySharedMode keySharedMode;
    private static final FastThreadLocal<Map<Consumer, List<Entry>>> localGroupedEntries = new FastThreadLocal<Map<Consumer, List<Entry>>>(){

        protected Map<Consumer, List<Entry>> initialValue() throws Exception {
            return new HashMap<Consumer, List<Entry>>();
        }
    };
    private static final FastThreadLocal<Map<Consumer, List<Integer>>> localGroupedStickyKeyHashes = new FastThreadLocal<Map<Consumer, List<Integer>>>(){

        protected Map<Consumer, List<Integer>> initialValue() throws Exception {
            return new HashMap<Consumer, List<Integer>>();
        }
    };
    private static final Logger log = LoggerFactory.getLogger(NonPersistentStickyKeyDispatcherMultipleConsumers.class);

    public NonPersistentStickyKeyDispatcherMultipleConsumers(NonPersistentTopic topic, Subscription subscription, KeySharedMeta ksm) {
        super(topic, subscription);
        this.keySharedMode = ksm.getKeySharedMode();
        switch (this.keySharedMode) {
            case STICKY: {
                this.selector = new HashRangeExclusiveStickyKeyConsumerSelector();
                break;
            }
            default: {
                ServiceConfiguration conf = topic.getBrokerService().getPulsar().getConfiguration();
                this.selector = conf.isSubscriptionKeySharedUseConsistentHashing() ? new ConsistentHashingStickyKeyConsumerSelector(conf.getSubscriptionKeySharedConsistentHashingReplicaPoints()) : new HashRangeAutoSplitStickyKeyConsumerSelector();
            }
        }
    }

    @VisibleForTesting
    NonPersistentStickyKeyDispatcherMultipleConsumers(NonPersistentTopic topic, Subscription subscription, StickyKeyConsumerSelector selector) {
        super(topic, subscription);
        this.keySharedMode = selector instanceof HashRangeExclusiveStickyKeyConsumerSelector ? KeySharedMode.STICKY : (selector instanceof ConsistentHashingStickyKeyConsumerSelector || selector instanceof HashRangeAutoSplitStickyKeyConsumerSelector ? KeySharedMode.AUTO_SPLIT : null);
        this.selector = selector;
    }

    @Override
    public synchronized CompletableFuture<Void> addConsumer(Consumer consumer) {
        if (IS_CLOSED_UPDATER.get(this) == 1) {
            log.warn("[{}] Dispatcher is already closed. Closing consumer {}", (Object)this.name, (Object)consumer);
            consumer.disconnect();
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)super.addConsumer(consumer).thenCompose(__ -> this.selector.addConsumer(consumer).handle((value, ex) -> {
            if (ex != null) {
                NonPersistentStickyKeyDispatcherMultipleConsumers nonPersistentStickyKeyDispatcherMultipleConsumers = this;
                synchronized (nonPersistentStickyKeyDispatcherMultipleConsumers) {
                    this.consumerSet.removeAll((Object)consumer);
                    this.consumerList.remove(consumer);
                }
                throw FutureUtil.wrapToCompletionException((Throwable)ex);
            }
            return value;
        }))).thenAccept(__ -> {});
    }

    @Override
    public synchronized void removeConsumer(Consumer consumer) throws BrokerServiceException {
        super.removeConsumer(consumer);
        this.selector.removeConsumer(consumer);
    }

    @Override
    public CommandSubscribe.SubType getType() {
        return CommandSubscribe.SubType.Key_Shared;
    }

    @Override
    public synchronized void sendMessages(List<Entry> entries) {
        if (entries.isEmpty()) {
            return;
        }
        if (this.consumerSet.isEmpty()) {
            entries.forEach(Entry::release);
            return;
        }
        Map groupedEntries = (Map)localGroupedEntries.get();
        groupedEntries.clear();
        Map consumerStickyKeyHashesMap = (Map)localGroupedStickyKeyHashes.get();
        consumerStickyKeyHashesMap.clear();
        for (Entry entry : entries) {
            byte[] stickyKey = this.peekStickyKey(entry);
            int stickyKeyHash = this.selector.makeStickyKeyHash(stickyKey);
            Consumer consumer = this.selector.select(stickyKeyHash);
            if (consumer != null) {
                int startingSize = Math.max(10, entries.size() / (2 * this.consumerSet.size()));
                groupedEntries.computeIfAbsent(consumer, k -> new ArrayList(startingSize)).add(entry);
                consumerStickyKeyHashesMap.computeIfAbsent(consumer, k -> new ArrayList(startingSize)).add(stickyKeyHash);
                continue;
            }
            entry.release();
        }
        for (Map.Entry entry : groupedEntries.entrySet()) {
            Consumer consumer = (Consumer)entry.getKey();
            List entriesForConsumer = (List)entry.getValue();
            List stickyKeysForConsumer = (List)consumerStickyKeyHashesMap.get(consumer);
            SendMessageInfo sendMessageInfo = SendMessageInfo.getThreadLocal();
            EntryBatchSizes batchSizes = EntryBatchSizes.get(entriesForConsumer.size());
            this.filterEntriesForConsumer(entriesForConsumer, batchSizes, sendMessageInfo, null, null, false, consumer);
            if (consumer.getAvailablePermits() > 0 && consumer.isWritable()) {
                consumer.sendMessages(entriesForConsumer, stickyKeysForConsumer, batchSizes, null, sendMessageInfo.getTotalMessages(), sendMessageInfo.getTotalBytes(), sendMessageInfo.getTotalChunkedMessages(), this.getRedeliveryTracker(), -1L);
                TOTAL_AVAILABLE_PERMITS_UPDATER.addAndGet(this, -sendMessageInfo.getTotalMessages());
                continue;
            }
            entriesForConsumer.forEach(e -> {
                int totalMsgs = this.getNumberOfMessagesInBatch((Entry)e);
                if (totalMsgs > 0) {
                    this.msgDrop.recordEvent((long)totalMsgs);
                }
                e.release();
            });
        }
    }

    public KeySharedMode getKeySharedMode() {
        return this.keySharedMode;
    }

    public boolean hasSameKeySharedPolicy(KeySharedMeta ksm) {
        return ksm.getKeySharedMode() == this.keySharedMode;
    }
}

