/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.tools;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;
import org.apache.pulsar.broker.loadbalance.BrokerHostUsage;
import org.apache.pulsar.broker.loadbalance.impl.GenericBrokerHostUsageImpl;
import org.apache.pulsar.broker.loadbalance.impl.LinuxBrokerHostUsageImpl;
import org.apache.pulsar.client.util.ExecutorProvider;
import org.apache.pulsar.policies.data.loadbalancer.ResourceUsage;
import org.apache.pulsar.policies.data.loadbalancer.SystemResourceUsage;
import picocli.CommandLine;

@CommandLine.Command(name="load-report", description={"Collect the load report of a specific broker"})
public class LoadReportCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"-i", "--interval-ms"}, description={"Interval to collect load report, in milliseconds"})
    public int intervalMilliseconds = 100;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws Exception {
        boolean isLinux = SystemUtils.IS_OS_LINUX;
        this.spec.commandLine().getOut().println("OS ARCH: " + SystemUtils.OS_ARCH);
        this.spec.commandLine().getOut().println("OS NAME: " + SystemUtils.OS_NAME);
        this.spec.commandLine().getOut().println("OS VERSION: " + SystemUtils.OS_VERSION);
        this.spec.commandLine().getOut().println("Linux: " + isLinux);
        this.spec.commandLine().getOut().println("--------------------------------------");
        this.spec.commandLine().getOut().println();
        this.spec.commandLine().getOut().println("Load Report Interval : " + this.intervalMilliseconds + " ms");
        this.spec.commandLine().getOut().println();
        this.spec.commandLine().getOut().println("--------------------------------------");
        this.spec.commandLine().getOut().println();
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ExecutorProvider.ExtendedThreadFactory("load-report"));
        try {
            BrokerHostUsage hostUsage = isLinux ? new LinuxBrokerHostUsageImpl(Integer.MAX_VALUE, Optional.empty(), scheduler) : new GenericBrokerHostUsageImpl(Integer.MAX_VALUE, scheduler);
            hostUsage.calculateBrokerHostUsage();
            try {
                TimeUnit.MILLISECONDS.sleep(this.intervalMilliseconds);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            hostUsage.calculateBrokerHostUsage();
            SystemResourceUsage usage = hostUsage.getBrokerHostUsage();
            this.printResourceUsage("CPU", usage.cpu);
            this.printResourceUsage("Memory", usage.memory);
            this.printResourceUsage("Direct Memory", usage.directMemory);
            this.printResourceUsage("Bandwidth In", usage.bandwidthIn);
            this.printResourceUsage("Bandwidth Out", usage.bandwidthOut);
            Integer n = 0;
            return n;
        }
        finally {
            scheduler.shutdown();
        }
    }

    private void printResourceUsage(String name, ResourceUsage usage) {
        this.spec.commandLine().getOut().println(name + " : usage = " + usage.usage + ", limit = " + usage.limit);
    }
}

