/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.net;

import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.buffer.Buffer;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.JsonArray;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.JsonObject;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.impl.JsonUtil;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.net.PemKeyCertOptions;

public class PemKeyCertOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, PemKeyCertOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "certPath": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setCertPath((String)member.getValue());
                    break;
                }
                case "certPaths": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setCertPaths(list);
                    break;
                }
                case "certValue": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setCertValue(Buffer.buffer(BASE64_DECODER.decode((String)member.getValue())));
                    break;
                }
                case "certValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)((Object)Buffer.buffer(BASE64_DECODER.decode((String)item))));
                        }
                    });
                    obj.setCertValues(list);
                    break;
                }
                case "keyPath": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setKeyPath((String)member.getValue());
                    break;
                }
                case "keyPaths": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setKeyPaths(list);
                    break;
                }
                case "keyValue": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setKeyValue(Buffer.buffer(BASE64_DECODER.decode((String)member.getValue())));
                    break;
                }
                case "keyValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)((Object)Buffer.buffer(BASE64_DECODER.decode((String)item))));
                        }
                    });
                    obj.setKeyValues(list);
                }
            }
        }
    }

    static void toJson(PemKeyCertOptions obj, JsonObject json) {
        PemKeyCertOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(PemKeyCertOptions obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getCertPaths() != null) {
            array = new JsonArray();
            obj.getCertPaths().forEach(item -> array.add(item));
            json.put("certPaths", array);
        }
        if (obj.getCertValues() != null) {
            array = new JsonArray();
            obj.getCertValues().forEach(item -> array.add(BASE64_ENCODER.encodeToString(item.getBytes())));
            json.put("certValues", array);
        }
        if (obj.getKeyPaths() != null) {
            array = new JsonArray();
            obj.getKeyPaths().forEach(item -> array.add(item));
            json.put("keyPaths", array);
        }
        if (obj.getKeyValues() != null) {
            array = new JsonArray();
            obj.getKeyValues().forEach(item -> array.add(BASE64_ENCODER.encodeToString(item.getBytes())));
            json.put("keyValues", array);
        }
    }
}

