/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.LoadData;
import org.apache.pulsar.broker.loadbalance.LoadSheddingStrategy;
import org.apache.pulsar.policies.data.loadbalancer.BrokerData;

public abstract class DeviationShedder
implements LoadSheddingStrategy {
    protected TreeSet<Pair<Double, String>> metricTreeSetCache;
    protected TreeSet<Pair<Double, String>> bundleTreeSetCache = new TreeSet();

    public DeviationShedder() {
        this.metricTreeSetCache = new TreeSet();
    }

    protected abstract double bundleValue(String var1, BrokerData var2, ServiceConfiguration var3);

    protected abstract double brokerValue(BrokerData var1, ServiceConfiguration var2);

    protected abstract double getDeviationThreshold(ServiceConfiguration var1);

    @Override
    public Multimap<String, String> findBundlesForUnloading(LoadData loadData, ServiceConfiguration conf) {
        ArrayListMultimap result = ArrayListMultimap.create();
        this.bundleTreeSetCache.clear();
        this.metricTreeSetCache.clear();
        double sum = 0.0;
        double squareSum = 0.0;
        Map<String, BrokerData> brokerDataMap = loadData.getBrokerData();
        for (Map.Entry<String, BrokerData> entry : brokerDataMap.entrySet()) {
            double value = this.brokerValue(entry.getValue(), conf);
            sum += value;
            squareSum += value * value;
            this.metricTreeSetCache.add((Pair<Double, String>)new ImmutablePair((Object)value, (Object)entry.getKey()));
        }
        double mean = sum / (double)brokerDataMap.size();
        double standardDeviation = Math.sqrt(squareSum / (double)brokerDataMap.size() - mean * mean);
        double deviationThreshold = this.getDeviationThreshold(conf);
        String lastMostOverloaded = null;
        while (((Double)this.metricTreeSetCache.last().getKey() - mean) / standardDeviation > deviationThreshold) {
            Pair<Double, String> mostLoadedPair = this.metricTreeSetCache.last();
            double highestValue = (Double)mostLoadedPair.getKey();
            String mostLoaded = (String)mostLoadedPair.getValue();
            Pair<Double, String> leastLoadedPair = this.metricTreeSetCache.first();
            double leastValue = (Double)leastLoadedPair.getKey();
            String leastLoaded = (String)this.metricTreeSetCache.first().getValue();
            if (!mostLoaded.equals(lastMostOverloaded)) {
                this.bundleTreeSetCache.clear();
                for (String bundle : brokerDataMap.get(mostLoaded).getLocalData().getBundles()) {
                    if (result.containsKey((Object)bundle)) continue;
                    this.bundleTreeSetCache.add((Pair<Double, String>)new ImmutablePair((Object)this.bundleValue(bundle, brokerDataMap.get(mostLoaded), conf), (Object)bundle));
                }
                lastMostOverloaded = mostLoaded;
            }
            boolean selected = false;
            while (!this.bundleTreeSetCache.isEmpty() && !selected) {
                Pair<Double, String> mostExpensivePair = this.bundleTreeSetCache.pollLast();
                double loadIncurred = (Double)mostExpensivePair.getKey();
                if (!(loadIncurred + leastValue < highestValue)) continue;
                String bundleToMove = (String)mostExpensivePair.getValue();
                result.put((Object)bundleToMove, (Object)mostLoaded);
                this.metricTreeSetCache.remove(mostLoadedPair);
                this.metricTreeSetCache.remove(leastLoadedPair);
                double newHighLoad = highestValue - loadIncurred;
                double newLowLoad = leastValue - loadIncurred;
                squareSum -= highestValue * highestValue + leastValue * leastValue;
                standardDeviation = Math.sqrt((squareSum += newHighLoad * newHighLoad + newLowLoad * newLowLoad) / (double)brokerDataMap.size() - mean * mean);
                this.metricTreeSetCache.add((Pair<Double, String>)new ImmutablePair((Object)newLowLoad, (Object)leastLoaded));
                this.metricTreeSetCache.add((Pair<Double, String>)new ImmutablePair((Object)newHighLoad, (Object)mostLoaded));
                selected = true;
            }
            if (selected) continue;
            this.metricTreeSetCache.pollLast();
        }
        return result;
    }
}

