/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl.pem;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import org.springframework.boot.ssl.pem.PemContent;
import org.springframework.boot.ssl.pem.PemSslStore;
import org.springframework.boot.ssl.pem.PemSslStoreDetails;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

final class LoadedPemSslStore
implements PemSslStore {
    private final PemSslStoreDetails details;
    private final List<X509Certificate> certificates;
    private final PrivateKey privateKey;

    LoadedPemSslStore(PemSslStoreDetails details) throws IOException {
        Assert.notNull((Object)details, (String)"Details must not be null");
        this.details = details;
        this.certificates = LoadedPemSslStore.loadCertificates(details);
        this.privateKey = LoadedPemSslStore.loadPrivateKey(details);
    }

    private static List<X509Certificate> loadCertificates(PemSslStoreDetails details) throws IOException {
        PemContent pemContent = PemContent.load(details.certificates());
        if (pemContent == null) {
            return null;
        }
        List<X509Certificate> certificates = pemContent.getCertificates();
        Assert.state((!CollectionUtils.isEmpty(certificates) ? 1 : 0) != 0, (String)"Loaded certificates are empty");
        return certificates;
    }

    private static PrivateKey loadPrivateKey(PemSslStoreDetails details) throws IOException {
        PemContent pemContent = PemContent.load(details.privateKey());
        return pemContent != null ? pemContent.getPrivateKey(details.privateKeyPassword()) : null;
    }

    @Override
    public String type() {
        return this.details.type();
    }

    @Override
    public String alias() {
        return this.details.alias();
    }

    @Override
    public String password() {
        return this.details.password();
    }

    @Override
    public List<X509Certificate> certificates() {
        return this.certificates;
    }

    @Override
    public PrivateKey privateKey() {
        return this.privateKey;
    }
}

