/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow.cdi;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.faces.context.FacesContext;
import jakarta.faces.flow.Flow;
import jakarta.faces.flow.builder.FlowDefinition;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.flow.FlowUtils;
import org.apache.myfaces.flow.cdi.FlowScopeContextualStorageHolder;
import org.apache.myfaces.flow.cdi.FlowScopeMap;
import org.apache.myfaces.spi.FacesFlowProvider;

public class DefaultCDIFacesFlowProvider
extends FacesFlowProvider {
    private static final String CURRENT_FLOW_SCOPE_MAP = "oam.flow.SCOPE_MAP";
    private static final char SEPARATOR_CHAR = '.';
    private List<Flow> flows;

    @Override
    public Iterator<Flow> getAnnotatedFlows(FacesContext facesContext) {
        if (this.flows == null) {
            this.flows = new ArrayList<Flow>();
            BeanManager beanManager = CDIUtils.getBeanManager(facesContext);
            if (beanManager == null) {
                Logger.getLogger(DefaultCDIFacesFlowProvider.class.getName()).log(Level.INFO, "CDI BeanManager not found");
                return null;
            }
            Set<Bean<?>> beans = beanManager.getBeans((Type)((Object)Flow.class), new AnnotationLiteral<FlowDefinition>(){});
            for (Bean<?> bean : beans) {
                CreationalContext<?> cc = beanManager.createCreationalContext(bean);
                this.flows.add((Flow)beanManager.getReference(bean, (Type)((Object)Flow.class), cc));
            }
        }
        return this.flows.iterator();
    }

    @Override
    public void doAfterEnterFlow(FacesContext context, Flow flow) {
        FlowScopeContextualStorageHolder storageHolder = FlowScopeContextualStorageHolder.getInstance(context, true);
        storageHolder.createCurrentFlowScope(context);
        String mapKey = this.getFlowKey(flow);
        context.getAttributes().remove(mapKey);
    }

    @Override
    public void doBeforeExitFlow(FacesContext context, Flow flow) {
        FlowScopeContextualStorageHolder storageHolder = FlowScopeContextualStorageHolder.getInstance(context, true);
        storageHolder.destroyCurrentFlowScope(context);
        String mapKey = this.getFlowKey(flow);
        context.getAttributes().remove(mapKey);
    }

    @Override
    public Map<Object, Object> getCurrentFlowScope(FacesContext facesContext) {
        Flow flow = facesContext.getApplication().getFlowHandler().getCurrentFlow(facesContext);
        if (flow != null) {
            String mapKey = this.getFlowKey(flow);
            return (Map)facesContext.getAttributes().computeIfAbsent(mapKey, k -> new FlowScopeMap(CDIUtils.getBeanManager(facesContext), FlowUtils.getFlowMapKey(facesContext, flow)));
        }
        return null;
    }

    @Override
    public void refreshClientWindow(FacesContext facesContext) {
        Flow flow;
        if (!facesContext.getApplication().getStateManager().isSavingStateInClient(facesContext) && (flow = facesContext.getApplication().getFlowHandler().getCurrentFlow(facesContext)) != null) {
            FlowScopeContextualStorageHolder storageHolder = FlowScopeContextualStorageHolder.getInstance(facesContext, true);
            storageHolder.refreshClientWindow(facesContext);
        }
    }

    protected String getFlowKey(Flow flow) {
        return "oam.flow.SCOPE_MAP." + flow.getDefiningDocumentId() + "." + flow.getId();
    }
}

