/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import javax.xml.bind.JAXBContext;

enum Implementation {
    INTERNAL("com.sun.xml.internal.bind.indentString"),
    ENDORSED("com.sun.xml.bind.indentString"),
    OTHER(null);

    private static final String ENDORSED_PREFIX = "com.sun.xml.bind.";
    private static final String INTERNAL_PREFIX = "com.sun.xml.internal.bind.";
    final String indentKey;

    private Implementation(String string2) {
        this.indentKey = string2;
    }

    public static Implementation detect(JAXBContext jAXBContext) {
        if (jAXBContext != null) {
            String string = jAXBContext.getClass().getName();
            if (string.startsWith(INTERNAL_PREFIX)) {
                return INTERNAL;
            }
            if (string.startsWith(ENDORSED_PREFIX)) {
                return ENDORSED;
            }
        }
        return OTHER;
    }

    boolean filterProperty(String string) {
        return this.indentKey != null || !string.startsWith(ENDORSED_PREFIX);
    }

    static String toInternal(String string) {
        if (string.startsWith(ENDORSED_PREFIX)) {
            StringBuilder stringBuilder = new StringBuilder(string.length() + 10);
            string = stringBuilder.append(INTERNAL_PREFIX).append(string, ENDORSED_PREFIX.length(), string.length()).toString();
        }
        return string;
    }
}

