/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.Declaration;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.KeywordExpression;
import com.github.sommeri.less4j.core.ast.ListExpression;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionManipulator;
import com.github.sommeri.less4j.core.compiler.stages.TreeDeclarationsVisitor;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;
import java.util.ListIterator;

public class UselessImportantRemover
extends TreeDeclarationsVisitor {
    private ExpressionManipulator expressionManipulator = new ExpressionManipulator();

    @Override
    protected void applyToDeclaration(Declaration declaration) {
        Expression expression = declaration.getExpression();
        if (!this.expressionManipulator.isImportant(expression)) {
            return;
        }
        this.expressionManipulator.squashLists(expression);
        ListExpression list = this.expressionManipulator.findRightmostSpaceSeparatedList(expression);
        if (list == null) {
            return;
        }
        List<Expression> expressions = list.getExpressions();
        if (!this.isImportant(ArraysUtils.last(expressions))) {
            return;
        }
        ListIterator<Expression> iterator = expressions.listIterator(expressions.size());
        int countImportant = 0;
        while (iterator.hasPrevious()) {
            if (!this.isImportant(iterator.previous())) continue;
            ++countImportant;
        }
        if (countImportant <= 1) {
            return;
        }
        int removalIndex = expressions.size() - countImportant;
        for (int i = countImportant - 1; i > 0; --i) {
            list.removeExpression(removalIndex);
        }
    }

    private boolean isImportant(Expression last) {
        if (last == null || !(last instanceof KeywordExpression)) {
            return false;
        }
        return ((KeywordExpression)last).isImportant();
    }

    @Override
    protected void enteringBody(Body node) {
    }

    @Override
    protected void leavingBody(Body node) {
    }
}

