/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.SourceEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.eval.VectorFunction;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class FieldValueEvaluator
extends SourceEvaluator {
    private static final long serialVersionUID = 1L;
    private String fieldName;

    public FieldValueEvaluator(String fieldName) {
        if (fieldName.startsWith("'") && fieldName.endsWith("'") && fieldName.length() > 1) {
            fieldName = fieldName.substring(1, fieldName.length() - 1);
        }
        this.fieldName = fieldName;
    }

    @Override
    public Object evaluate(Tuple tuple) throws IOException {
        StreamContext sc;
        Object value = tuple.get(this.fieldName);
        if (null == value && null != this.getStreamContext() && (value = this.getStreamContext().getLets().get(this.fieldName)) instanceof StreamEvaluator) {
            value = ((StreamEvaluator)value).evaluate(tuple);
        }
        if (null != value) {
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                ArrayList<Object> list = new ArrayList<Object>(array.length);
                for (Object obj : array) {
                    list.add(obj);
                }
                return list;
            }
            if (value instanceof Matrix) {
                return value;
            }
            if (value instanceof VectorFunction) {
                return value;
            }
            if (value instanceof Iterable && !(value instanceof List)) {
                Iterable iter = (Iterable)value;
                ArrayList list = new ArrayList();
                for (Object obj : iter) {
                    list.add(obj);
                }
                return list;
            }
        }
        if ((sc = this.getStreamContext()) != null) {
            sc.getTupleContext().remove("null");
        }
        if (value == null) {
            if (sc != null) {
                sc.getTupleContext().put("null", this.fieldName);
            }
            if (this.fieldName.startsWith("\"") && this.fieldName.endsWith("\"")) {
                return this.fieldName.substring(1, this.fieldName.length() - 1);
            }
            return null;
        }
        return value;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        return new StreamExpressionValue(this.fieldName);
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.nodeId.toString()).withExpressionType("evaluator").withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }
}

