/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.core.internal.layout;

import java.lang.management.ManagementFactory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.karaf.log.core.internal.layout.AbsoluteTimeDateFormat;
import org.apache.karaf.log.core.internal.layout.DateTimeDateFormat;
import org.apache.karaf.log.core.internal.layout.FormattingInfo;
import org.apache.karaf.log.core.internal.layout.ISO8601DateFormat;
import org.apache.karaf.log.core.internal.layout.PatternConverter;
import org.ops4j.pax.logging.spi.PaxLocationInfo;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;
import org.osgi.service.log.LogLevel;

public class PatternParser {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final char ESCAPE_CHAR = '%';
    private static final int LITERAL_STATE = 0;
    private static final int CONVERTER_STATE = 1;
    private static final int MINUS_STATE = 2;
    private static final int DOT_STATE = 3;
    private static final int MIN_STATE = 4;
    private static final int MAX_STATE = 5;
    static final int FULL_LOCATION_CONVERTER = 1000;
    static final int METHOD_LOCATION_CONVERTER = 1001;
    static final int CLASS_LOCATION_CONVERTER = 1002;
    static final int LINE_LOCATION_CONVERTER = 1003;
    static final int FILE_LOCATION_CONVERTER = 1004;
    static final int RELATIVE_TIME_CONVERTER = 2000;
    static final int THREAD_CONVERTER = 2001;
    static final int LEVEL_CONVERTER = 2002;
    static final int NDC_CONVERTER = 2003;
    static final int MESSAGE_CONVERTER = 2004;
    int state;
    protected StringBuffer currentLiteral = new StringBuffer(32);
    protected int patternLength;
    protected int i;
    PatternConverter head;
    PatternConverter tail;
    protected FormattingInfo formattingInfo = new FormattingInfo();
    protected String pattern;
    private static long startTime = 0L;

    public PatternParser(String pattern) {
        this.pattern = pattern;
        this.patternLength = pattern.length();
        this.state = 0;
    }

    private void addToList(PatternConverter pc) {
        if (this.head == null) {
            this.head = this.tail = pc;
        } else {
            this.tail.next = pc;
            this.tail = pc;
        }
    }

    protected String extractOption() {
        if (this.i < this.patternLength && this.pattern.charAt(this.i) == '{') {
            int end = this.i;
            int nb = 1;
            while (++end < this.patternLength) {
                switch (this.pattern.charAt(end)) {
                    case '{': {
                        ++nb;
                        break;
                    }
                    case '}': {
                        if (--nb != 0) break;
                        String r = this.pattern.substring(this.i + 1, end);
                        this.i = end + 1;
                        return r;
                    }
                }
            }
        }
        return null;
    }

    protected int extractPrecisionOption() {
        String opt = this.extractOption();
        int r = 0;
        if (opt != null) {
            try {
                r = Integer.parseInt(opt);
                if (r <= 0) {
                    r = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return r;
    }

    public PatternConverter parse() {
        this.i = 0;
        while (this.i < this.patternLength) {
            char c = this.pattern.charAt(this.i++);
            block0 : switch (this.state) {
                case 0: {
                    if (this.i == this.patternLength) {
                        this.currentLiteral.append(c);
                        break;
                    }
                    if (c == '%') {
                        switch (this.pattern.charAt(this.i)) {
                            case '%': {
                                this.currentLiteral.append(c);
                                ++this.i;
                                break block0;
                            }
                            case 'n': {
                                this.currentLiteral.append(LINE_SEP);
                                ++this.i;
                                break block0;
                            }
                        }
                        if (this.currentLiteral.length() != 0) {
                            this.addToList(new LiteralPatternConverter(this.currentLiteral.toString()));
                        }
                        this.currentLiteral.setLength(0);
                        this.currentLiteral.append(c);
                        this.state = 1;
                        this.formattingInfo.reset();
                        break;
                    }
                    this.currentLiteral.append(c);
                    break;
                }
                case 1: {
                    this.currentLiteral.append(c);
                    switch (c) {
                        case '-': {
                            this.formattingInfo.leftAlign = true;
                            break block0;
                        }
                        case '.': {
                            this.state = 3;
                            break block0;
                        }
                    }
                    if (c >= '0' && c <= '9') {
                        this.formattingInfo.min = c - 48;
                        this.state = 4;
                        break;
                    }
                    this.finalizeConverter(c);
                    break;
                }
                case 4: {
                    this.currentLiteral.append(c);
                    if (c >= '0' && c <= '9') {
                        this.formattingInfo.min = this.formattingInfo.min * 10 + (c - 48);
                        break;
                    }
                    if (c == '.') {
                        this.state = 3;
                        break;
                    }
                    this.finalizeConverter(c);
                    break;
                }
                case 3: {
                    this.currentLiteral.append(c);
                    if (c >= '0' && c <= '9') {
                        this.formattingInfo.max = c - 48;
                        this.state = 5;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                case 5: {
                    this.currentLiteral.append(c);
                    if (c >= '0' && c <= '9') {
                        this.formattingInfo.max = this.formattingInfo.max * 10 + (c - 48);
                        break;
                    }
                    this.finalizeConverter(c);
                    this.state = 0;
                }
            }
        }
        if (this.currentLiteral.length() != 0) {
            this.addToList(new LiteralPatternConverter(this.currentLiteral.toString()));
        }
        return this.head;
    }

    protected void finalizeConverter(char c) {
        PatternConverter pc = null;
        switch (c) {
            case 'c': {
                pc = new CategoryPatternConverter(this.formattingInfo, this.extractPrecisionOption());
                this.currentLiteral.setLength(0);
                break;
            }
            case 'C': {
                pc = new ClassNamePatternConverter(this.formattingInfo, this.extractPrecisionOption());
                this.currentLiteral.setLength(0);
                break;
            }
            case 'd': {
                DateFormat df;
                String dateFormatStr = "ISO8601";
                String dOpt = this.extractOption();
                if (dOpt != null) {
                    dateFormatStr = dOpt;
                }
                if (dateFormatStr.equalsIgnoreCase("ISO8601")) {
                    df = new ISO8601DateFormat();
                } else if (dateFormatStr.equalsIgnoreCase("ABSOLUTE")) {
                    df = new AbsoluteTimeDateFormat();
                } else if (dateFormatStr.equalsIgnoreCase("DATE")) {
                    df = new DateTimeDateFormat();
                } else {
                    try {
                        df = new SimpleDateFormat(dateFormatStr);
                    }
                    catch (IllegalArgumentException e) {
                        df = new ISO8601DateFormat();
                    }
                }
                pc = new DatePatternConverter(this.formattingInfo, df);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'F': {
                pc = new LocationPatternConverter(this.formattingInfo, 1004);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'h': {
                String pat = this.extractOption();
                String style = this.extractOption();
                pc = new HighlightPatternConverter(this.formattingInfo, pat, style);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'L': {
                pc = new LocationPatternConverter(this.formattingInfo, 1003);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'm': {
                pc = new BasicPatternConverter(this.formattingInfo, 2004);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'M': {
                pc = new LocationPatternConverter(this.formattingInfo, 1001);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'p': {
                pc = new BasicPatternConverter(this.formattingInfo, 2002);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'r': {
                pc = new BasicPatternConverter(this.formattingInfo, 2000);
                this.currentLiteral.setLength(0);
                break;
            }
            case 't': {
                pc = new BasicPatternConverter(this.formattingInfo, 2001);
                this.currentLiteral.setLength(0);
                break;
            }
            case 'X': {
                String xOpt = this.extractOption();
                pc = new MDCPatternConverter(this.formattingInfo, xOpt);
                this.currentLiteral.setLength(0);
                break;
            }
            default: {
                pc = new LiteralPatternConverter(this.currentLiteral.toString());
                this.currentLiteral.setLength(0);
            }
        }
        this.addConverter(pc);
    }

    protected void addConverter(PatternConverter pc) {
        this.currentLiteral.setLength(0);
        this.addToList(pc);
        this.state = 0;
        this.formattingInfo.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long getStartTime() {
        if (startTime != 0L) return startTime;
        Class<PatternParser> clazz = PatternParser.class;
        synchronized (PatternParser.class) {
            try {
                startTime = ManagementFactory.getRuntimeMXBean().getStartTime();
            }
            catch (Throwable t) {
                startTime = System.currentTimeMillis();
            }
            return startTime;
        }
    }

    private class MDCPatternConverter
    extends PatternConverter {
        String key;

        MDCPatternConverter(FormattingInfo formattingInfo, String key) {
            super(formattingInfo);
            this.key = key;
        }

        @Override
        public String convert(PaxLoggingEvent event) {
            Map properties = event.getProperties();
            if (properties == null) {
                return null;
            }
            if (this.key == null) {
                StringBuilder buf = new StringBuilder("{");
                if (properties.size() > 0) {
                    Object[] keys = properties.keySet().toArray();
                    Arrays.sort(keys);
                    for (Object key : keys) {
                        buf.append('{');
                        buf.append(key);
                        buf.append(',');
                        buf.append(properties.get(key));
                        buf.append('}');
                    }
                }
                buf.append('}');
                return buf.toString();
            }
            Object val = properties.get(this.key);
            if (val == null) {
                return null;
            }
            return val.toString();
        }
    }

    private class CategoryPatternConverter
    extends NamedPatternConverter {
        CategoryPatternConverter(FormattingInfo formattingInfo, int precision) {
            super(formattingInfo, precision);
        }

        @Override
        String getFullyQualifiedName(PaxLoggingEvent event) {
            return event.getLoggerName();
        }
    }

    private class ClassNamePatternConverter
    extends NamedPatternConverter {
        ClassNamePatternConverter(FormattingInfo formattingInfo, int precision) {
            super(formattingInfo, precision);
        }

        @Override
        String getFullyQualifiedName(PaxLoggingEvent event) {
            if (!event.locationInformationExists()) {
                return "?";
            }
            return event.getLocationInformation().getClassName();
        }
    }

    private static abstract class NamedPatternConverter
    extends PatternConverter {
        int precision;

        NamedPatternConverter(FormattingInfo formattingInfo, int precision) {
            super(formattingInfo);
            this.precision = precision;
        }

        abstract String getFullyQualifiedName(PaxLoggingEvent var1);

        @Override
        public String convert(PaxLoggingEvent event) {
            String n = this.getFullyQualifiedName(event);
            if (n == null) {
                return null;
            }
            if (this.precision <= 0) {
                return n;
            }
            int len = n.length();
            int end = len - 1;
            for (int i = this.precision; i > 0; --i) {
                if ((end = n.lastIndexOf(46, end - 1)) != -1) continue;
                return n;
            }
            return n.substring(end + 1, len);
        }
    }

    private class LocationPatternConverter
    extends PatternConverter {
        int type;

        LocationPatternConverter(FormattingInfo formattingInfo, int type) {
            super(formattingInfo);
            this.type = type;
        }

        @Override
        public String convert(PaxLoggingEvent event) {
            if (!event.locationInformationExists()) {
                return "?";
            }
            PaxLocationInfo locationInfo = event.getLocationInformation();
            switch (this.type) {
                case 1001: {
                    return locationInfo.getMethodName();
                }
                case 1003: {
                    return locationInfo.getLineNumber();
                }
                case 1004: {
                    return locationInfo.getFileName();
                }
            }
            return null;
        }
    }

    private static class HighlightPatternConverter
    extends PatternConverter {
        static Map<String, String> SEQUENCES = new HashMap<String, String>();
        private PatternConverter pattern;
        private Map<String, String> style;

        HighlightPatternConverter(FormattingInfo formattingInfo, String pattern, String style) {
            super(formattingInfo);
            this.pattern = new PatternParser(pattern).parse();
            HashMap<String, String> unparsed = new HashMap<String, String>();
            unparsed.put("trace", "cyan");
            unparsed.put("debug", "cyan");
            unparsed.put("info", "bright green");
            unparsed.put("warn", "bright yellow");
            unparsed.put("error", "bright red");
            unparsed.put("fatal", "bright red");
            if (style != null) {
                if ((style = style.toLowerCase(Locale.ENGLISH)).indexOf(44) < 0 && style.indexOf(61) < 0) {
                    unparsed.put("trace", style.trim());
                    unparsed.put("debug", style.trim());
                    unparsed.put("info", style.trim());
                    unparsed.put("warn", style.trim());
                    unparsed.put("error", style.trim());
                    unparsed.put("fatal", style.trim());
                } else {
                    String[] keys;
                    for (String key : keys = style.split("\\s*,\\s*")) {
                        String[] val = key.split("\\s*=\\s*");
                        if (val.length <= 1) continue;
                        unparsed.put(val[0].trim(), val[1].trim());
                    }
                }
            }
            this.style = new HashMap<String, String>();
            for (Map.Entry e : unparsed.entrySet()) {
                this.style.put((String)e.getKey(), this.createSequence(((String)e.getValue()).split("\\s")));
            }
        }

        private String createSequence(String ... names) {
            StringBuilder sb = new StringBuilder(SEQUENCES.get("csi"));
            boolean first = true;
            for (String name : names) {
                name = name.trim();
                if (!first) {
                    sb.append(SEQUENCES.get("separator"));
                }
                first = false;
                sb.append(SEQUENCES.getOrDefault(name, name));
            }
            sb.append(SEQUENCES.get("suffix"));
            return sb.toString();
        }

        @Override
        public String convert(PaxLoggingEvent event) {
            String s = event.getLevel().toLevel().equals((Object)LogLevel.TRACE) ? "trace" : (event.getLevel().toLevel().equals((Object)LogLevel.DEBUG) ? "debug" : (event.getLevel().toLevel().equals((Object)LogLevel.INFO) ? "info" : (event.getLevel().toLevel().equals((Object)LogLevel.WARN) ? "warn" : (event.getLevel().toLevel().equals((Object)LogLevel.ERROR) ? "error" : (event.getLevel().toLevel().equals((Object)LogLevel.AUDIT) ? "audit" : "error")))));
            String str = this.style.get(s);
            if (str != null) {
                return str + this.pattern.convert(event) + SEQUENCES.get("csi") + SEQUENCES.get("suffix");
            }
            return this.pattern.convert(event);
        }

        static {
            SEQUENCES.put("csi", "\u001b[");
            SEQUENCES.put("suffix", "m");
            SEQUENCES.put("separator", ";");
            SEQUENCES.put("normal", "0");
            SEQUENCES.put("bold", "1");
            SEQUENCES.put("bright", "1");
            SEQUENCES.put("dim", "2");
            SEQUENCES.put("underline", "3");
            SEQUENCES.put("blink", "5");
            SEQUENCES.put("reverse", "7");
            SEQUENCES.put("hidden", "8");
            SEQUENCES.put("black", "30");
            SEQUENCES.put("fg_black", "30");
            SEQUENCES.put("red", "31");
            SEQUENCES.put("fg_red", "31");
            SEQUENCES.put("green", "32");
            SEQUENCES.put("fg_green", "32");
            SEQUENCES.put("yellow", "33");
            SEQUENCES.put("fg_yellow", "33");
            SEQUENCES.put("blue", "34");
            SEQUENCES.put("fg_blue", "34");
            SEQUENCES.put("magenta", "35");
            SEQUENCES.put("fg_magenta", "35");
            SEQUENCES.put("cyan", "36");
            SEQUENCES.put("fg_cyan", "36");
            SEQUENCES.put("white", "37");
            SEQUENCES.put("fg_white", "37");
            SEQUENCES.put("default", "39");
            SEQUENCES.put("fg_default", "39");
            SEQUENCES.put("bg_black", "40");
            SEQUENCES.put("bg_red", "41");
            SEQUENCES.put("bg_green", "42");
            SEQUENCES.put("bg_yellow", "43");
            SEQUENCES.put("bg_blue", "44");
            SEQUENCES.put("bg_magenta", "45");
            SEQUENCES.put("bg_cyan", "46");
            SEQUENCES.put("bg_white", "47");
            SEQUENCES.put("bg_default", "49");
        }
    }

    private static class DatePatternConverter
    extends PatternConverter {
        private DateFormat df;
        private Date date = new Date();

        DatePatternConverter(FormattingInfo formattingInfo, DateFormat df) {
            super(formattingInfo);
            this.df = df;
        }

        @Override
        public String convert(PaxLoggingEvent event) {
            this.date.setTime(event.getTimeStamp());
            String converted = null;
            try {
                converted = this.df.format(this.date);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return converted;
        }
    }

    private static class LiteralPatternConverter
    extends PatternConverter {
        private String literal;

        LiteralPatternConverter(String value) {
            this.literal = value;
        }

        @Override
        public final void format(StringBuffer sbuf, PaxLoggingEvent event) {
            sbuf.append(this.literal);
        }

        @Override
        public String convert(PaxLoggingEvent event) {
            return this.literal;
        }
    }

    private static class BasicPatternConverter
    extends PatternConverter {
        int type;

        BasicPatternConverter(FormattingInfo formattingInfo, int type) {
            super(formattingInfo);
            this.type = type;
        }

        @Override
        public String convert(PaxLoggingEvent event) {
            switch (this.type) {
                case 2000: {
                    return Long.toString(event.getTimeStamp() - PatternParser.getStartTime());
                }
                case 2001: {
                    return event.getThreadName();
                }
                case 2002: {
                    return event.getLevel().toString();
                }
                case 2004: {
                    return event.getRenderedMessage();
                }
            }
            return null;
        }
    }
}

