/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.terms;

import org.apache.james.jspf.core.DNSLookupContinuation;
import org.apache.james.jspf.core.MacroExpand;
import org.apache.james.jspf.core.MacroExpandEnabled;
import org.apache.james.jspf.core.SPFCheckEnabled;
import org.apache.james.jspf.core.SPFChecker;
import org.apache.james.jspf.core.SPFCheckerExceptionCatcher;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.NeutralException;
import org.apache.james.jspf.core.exceptions.NoneException;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.core.exceptions.TempErrorException;
import org.apache.james.jspf.terms.GenericModifier;

public class RedirectModifier
extends GenericModifier
implements SPFCheckEnabled,
MacroExpandEnabled {
    public static final String REGEX = "[rR][eE][dD][iI][rR][eE][cC][tT]\\=((?:\\%(?:\\{[rctlsodipvhRCTLSODIPVH]\\d*[r]?[\\.\\-\\+,/_\\=]*\\}|\\%|\\_|\\-)|[\\x21-\\x24\\x26-\\x7e]{1})*(?:\\.(?:[a-zA-Z0-9]*[a-zA-Z]{1}[a-zA-Z0-9]*|(?:[a-zA-Z0-9]+\\-(?:[a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))\\.?|\\%(?:\\{[rctlsodipvhRCTLSODIPVH]\\d*[r]?[\\.\\-\\+,/_\\=]*\\}|\\%|\\_|\\-)))";
    private SPFChecker spfChecker;
    private MacroExpand macroExpand;
    private SPFChecker cleanupChecker = new CleanupChecker();
    private SPFChecker expandedChecker = new ExpandedChecker();

    protected DNSLookupContinuation checkSPFLogged(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
        if (spfData.getCurrentResult() == null) {
            spfData.increaseCurrentDepth();
            spfData.pushChecker(this.cleanupChecker);
            spfData.pushChecker(this.expandedChecker);
            return this.macroExpand.checkExpand(this.getHost(), spfData, false);
        }
        return null;
    }

    public String toString() {
        return "redirect=" + this.getHost();
    }

    public void enableSPFChecking(SPFChecker checker) {
        this.spfChecker = checker;
    }

    public void enableMacroExpand(MacroExpand macroExpand) {
        this.macroExpand = macroExpand;
    }

    private final class CleanupChecker
    implements SPFChecker,
    SPFCheckerExceptionCatcher {
        private CleanupChecker() {
        }

        public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
            spfData.setIgnoreExplanation(true);
            return null;
        }

        public void onException(Exception exception, SPFSession session) throws PermErrorException, NoneException, TempErrorException, NeutralException {
            session.setIgnoreExplanation(true);
            if (exception instanceof NeutralException) {
                throw new PermErrorException("included checkSPF returned NeutralException");
            }
            if (exception instanceof NoneException) {
                throw new PermErrorException("included checkSPF returned NoneException");
            }
            if (exception instanceof PermErrorException) {
                throw (PermErrorException)exception;
            }
            if (exception instanceof TempErrorException) {
                throw (TempErrorException)exception;
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new IllegalStateException(exception.getMessage());
        }
    }

    private final class ExpandedChecker
    implements SPFChecker {
        private ExpandedChecker() {
        }

        public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, NoneException, TempErrorException, NeutralException {
            String host = RedirectModifier.this.getHost();
            host = RedirectModifier.this.macroExpand.expand(host, spfData, false);
            spfData.setCurrentDomain(host);
            spfData.pushChecker(RedirectModifier.this.spfChecker);
            return null;
        }
    }
}

