/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.io.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.http.io.entity.BasicHttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.WWWFormCodec;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestEntityUtils {
    static final int[] SWISS_GERMAN_HELLO = new int[]{71, 114, 252, 101, 122, 105, 95, 122, 228, 109, 228};
    static final int[] RUSSIAN_HELLO = new int[]{1042, 1089, 1077, 1084, 95, 1087, 1088, 1080, 1074, 1077, 1090};

    TestEntityUtils() {
    }

    @Test
    void testNullEntityToByteArray() {
        Assertions.assertThrows(NullPointerException.class, () -> EntityUtils.toByteArray(null));
    }

    @Test
    void testMaxIntContentToByteArray() {
        byte[] content = "Message content".getBytes(StandardCharsets.US_ASCII);
        BasicHttpEntity entity = new BasicHttpEntity((InputStream)new ByteArrayInputStream(content), 2147483747L, ContentType.TEXT_PLAIN.withCharset(StandardCharsets.US_ASCII));
        Assertions.assertThrows(IllegalArgumentException.class, () -> EntityUtils.toByteArray((HttpEntity)entity));
    }

    @Test
    void testUnknownLengthContentToByteArray() throws Exception {
        byte[] bytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        BasicHttpEntity entity = new BasicHttpEntity((InputStream)new ByteArrayInputStream(bytes), -1L, null);
        byte[] bytes2 = EntityUtils.toByteArray((HttpEntity)entity);
        Assertions.assertNotNull((Object)bytes2);
        Assertions.assertEquals((int)bytes.length, (int)bytes2.length);
        for (int i = 0; i < bytes.length; ++i) {
            Assertions.assertEquals((byte)bytes[i], (byte)bytes2[i]);
        }
    }

    @Test
    void testKnownLengthContentToByteArray() throws Exception {
        byte[] bytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        BasicHttpEntity entity = new BasicHttpEntity((InputStream)new ByteArrayInputStream(bytes), (long)bytes.length, null);
        byte[] bytes2 = EntityUtils.toByteArray((HttpEntity)entity);
        Assertions.assertNotNull((Object)bytes2);
        Assertions.assertEquals((int)bytes.length, (int)bytes2.length);
        for (int i = 0; i < bytes.length; ++i) {
            Assertions.assertEquals((byte)bytes[i], (byte)bytes2[i]);
        }
    }

    @Test
    void testNullEntityToString() {
        Assertions.assertThrows(NullPointerException.class, () -> EntityUtils.toString(null));
    }

    @Test
    void testMaxIntContentToString() {
        byte[] content = "Message content".getBytes(StandardCharsets.US_ASCII);
        BasicHttpEntity entity = new BasicHttpEntity((InputStream)new ByteArrayInputStream(content), 2147483747L, ContentType.TEXT_PLAIN.withCharset(StandardCharsets.US_ASCII));
        Assertions.assertThrows(IllegalArgumentException.class, () -> EntityUtils.toString((HttpEntity)entity, (String)"US-ASCII"));
    }

    @Test
    void testUnknownLengthContentToString() throws Exception {
        byte[] bytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        BasicHttpEntity entity = new BasicHttpEntity((InputStream)new ByteArrayInputStream(bytes), -1L, null);
        String s = EntityUtils.toString((HttpEntity)entity, (String)"US-ASCII");
        Assertions.assertEquals((Object)"Message content", (Object)s);
    }

    @Test
    void testKnownLengthContentToString() throws Exception {
        byte[] bytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        BasicHttpEntity entity = new BasicHttpEntity((InputStream)new ByteArrayInputStream(bytes), (long)bytes.length, ContentType.TEXT_PLAIN.withCharset(StandardCharsets.US_ASCII));
        String s = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"Message content", (Object)s);
    }

    private static String constructString(int[] unicodeChars) {
        StringBuilder buffer = new StringBuilder();
        if (unicodeChars != null) {
            for (int unicodeChar : unicodeChars) {
                buffer.append((char)unicodeChar);
            }
        }
        return buffer.toString();
    }

    @Test
    void testNoCharsetContentToString() {
        String content = TestEntityUtils.constructString(SWISS_GERMAN_HELLO);
        byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        BasicHttpEntity entity = new BasicHttpEntity((InputStream)new ByteArrayInputStream(bytes), ContentType.TEXT_PLAIN);
        Assertions.assertDoesNotThrow(() -> EntityUtils.toString((HttpEntity)entity));
    }

    @Test
    void testDefaultCharsetContentToString() throws Exception {
        String content = TestEntityUtils.constructString(RUSSIAN_HELLO);
        byte[] bytes = content.getBytes(Charset.forName("KOI8-R"));
        BasicHttpEntity entity = new BasicHttpEntity((InputStream)new ByteArrayInputStream(bytes), ContentType.parse((CharSequence)"text/plain"));
        String s = EntityUtils.toString((HttpEntity)entity, (Charset)Charset.forName("KOI8-R"));
        Assertions.assertEquals((Object)content, (Object)s);
    }

    @Test
    void testContentWithContentTypeToString() throws Exception {
        String content = TestEntityUtils.constructString(RUSSIAN_HELLO);
        byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        BasicHttpEntity entity = new BasicHttpEntity((InputStream)new ByteArrayInputStream(bytes), ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8));
        String s = EntityUtils.toString((HttpEntity)entity, (String)"ISO-8859-1");
        Assertions.assertEquals((Object)content, (Object)s);
    }

    @Test
    void testContentWithInvalidContentTypeToString() throws Exception {
        String content = TestEntityUtils.constructString(RUSSIAN_HELLO);
        final byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
        AbstractHttpEntity entity = new AbstractHttpEntity("text/plain; charset=nosuchcharset", null){

            public InputStream getContent() throws IOException, UnsupportedOperationException {
                return new ByteArrayInputStream(bytes);
            }

            public boolean isStreaming() {
                return false;
            }

            public long getContentLength() {
                return bytes.length;
            }

            public void close() throws IOException {
            }
        };
        String s = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        Assertions.assertEquals((Object)content, (Object)s);
    }

    private static void assertNameValuePair(NameValuePair parameter, String expectedName, String expectedValue) {
        Assertions.assertEquals((Object)parameter.getName(), (Object)expectedName);
        Assertions.assertEquals((Object)parameter.getValue(), (Object)expectedValue);
    }

    @Test
    void testParseEntity() throws Exception {
        StringEntity entity1 = new StringEntity("Name1=Value1", ContentType.APPLICATION_FORM_URLENCODED);
        List result = EntityUtils.parse((HttpEntity)entity1);
        Assertions.assertEquals((int)1, (int)result.size());
        TestEntityUtils.assertNameValuePair((NameValuePair)result.get(0), "Name1", "Value1");
        StringEntity entity2 = new StringEntity("Name1=Value1", ContentType.parse((CharSequence)"text/test"));
        Assertions.assertTrue((boolean)EntityUtils.parse((HttpEntity)entity2).isEmpty());
    }

    @Test
    void testParseUTF8Entity() throws Exception {
        String ru_hello = TestEntityUtils.constructString(RUSSIAN_HELLO);
        String ch_hello = TestEntityUtils.constructString(SWISS_GERMAN_HELLO);
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("russian", ru_hello));
        parameters.add(new BasicNameValuePair("swiss", ch_hello));
        String s = WWWFormCodec.format(parameters, (Charset)StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)"russian=%D0%92%D1%81%D0%B5%D0%BC_%D0%BF%D1%80%D0%B8%D0%B2%D0%B5%D1%82&swiss=Gr%C3%BCezi_z%C3%A4m%C3%A4", (Object)s);
        StringEntity entity = new StringEntity(s, ContentType.APPLICATION_FORM_URLENCODED.withCharset(StandardCharsets.UTF_8));
        List result = EntityUtils.parse((HttpEntity)entity);
        Assertions.assertEquals((int)2, (int)result.size());
        TestEntityUtils.assertNameValuePair((NameValuePair)result.get(0), "russian", ru_hello);
        TestEntityUtils.assertNameValuePair((NameValuePair)result.get(1), "swiss", ch_hello);
    }

    @Test
    void testByteArrayMaxResultLength() throws IOException {
        byte[] allBytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        HashMap<Integer, byte[]> testCases = new HashMap<Integer, byte[]>();
        testCases.put(0, new byte[0]);
        testCases.put(2, Arrays.copyOfRange(allBytes, 0, 2));
        testCases.put(allBytes.length, allBytes);
        testCases.put(Integer.MAX_VALUE, allBytes);
        for (Map.Entry tc : testCases.entrySet()) {
            BasicHttpEntity entity = new BasicHttpEntity((InputStream)new ByteArrayInputStream(allBytes), (long)allBytes.length, null);
            byte[] bytes = EntityUtils.toByteArray((HttpEntity)entity, (int)((Integer)tc.getKey()));
            byte[] expectedBytes = (byte[])tc.getValue();
            Assertions.assertNotNull((Object)bytes);
            Assertions.assertEquals((int)expectedBytes.length, (int)bytes.length);
            for (int i = 0; i < expectedBytes.length; ++i) {
                Assertions.assertEquals((byte)expectedBytes[i], (byte)bytes[i]);
            }
        }
    }

    @Test
    void testByteArrayMaxResultLengthWithNoContentLength() throws IOException {
        int b = 98;
        byte[] allBytes = new byte[5000];
        Arrays.fill(allBytes, (byte)98);
        HashMap<Integer, byte[]> testCases = new HashMap<Integer, byte[]>();
        testCases.put(0, new byte[0]);
        testCases.put(2, Arrays.copyOfRange(allBytes, 0, 2));
        testCases.put(allBytes.length, allBytes);
        testCases.put(Integer.MAX_VALUE, allBytes);
        for (Map.Entry tc : testCases.entrySet()) {
            BasicHttpEntity entity = new BasicHttpEntity((InputStream)new ByteArrayInputStream(allBytes), null);
            byte[] bytes = EntityUtils.toByteArray((HttpEntity)entity, (int)((Integer)tc.getKey()));
            byte[] expectedBytes = (byte[])tc.getValue();
            Assertions.assertNotNull((Object)bytes);
            Assertions.assertEquals((int)expectedBytes.length, (int)bytes.length);
            for (int i = 0; i < expectedBytes.length; ++i) {
                Assertions.assertEquals((byte)expectedBytes[i], (byte)bytes[i]);
            }
        }
    }

    @Test
    void testStringMaxResultLength() throws IOException, ParseException {
        String allMessage = "Message content";
        byte[] allBytes = "Message content".getBytes(StandardCharsets.US_ASCII);
        HashMap<Integer, String> testCases = new HashMap<Integer, String>();
        testCases.put(7, "Message content".substring(0, 7));
        testCases.put("Message content".length(), "Message content");
        testCases.put(Integer.MAX_VALUE, "Message content");
        for (Map.Entry tc : testCases.entrySet()) {
            BasicHttpEntity entity = new BasicHttpEntity((InputStream)new ByteArrayInputStream(allBytes), (long)allBytes.length, null);
            String string = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.US_ASCII, (int)((Integer)tc.getKey()));
            String expectedString = (String)tc.getValue();
            Assertions.assertNotNull((Object)string);
            Assertions.assertEquals((Object)expectedString, (Object)string);
        }
    }
}

