/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.servererrors;

import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.servererrors.QueryValidationException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public class AlreadyExistsException
extends QueryValidationException {
    private final String keyspace;
    private final String table;

    public AlreadyExistsException(@NonNull Node coordinator, @NonNull String keyspace, @NonNull String table) {
        this(coordinator, AlreadyExistsException.makeMessage(keyspace, table), keyspace, table, null, false);
    }

    private AlreadyExistsException(@NonNull Node coordinator, @NonNull String message, @NonNull String keyspace, @NonNull String table, @Nullable ExecutionInfo executionInfo, boolean writableStackTrace) {
        super(coordinator, message, executionInfo, writableStackTrace);
        this.keyspace = keyspace;
        this.table = table;
    }

    private static String makeMessage(String keyspace, String table) {
        if (table == null || table.isEmpty()) {
            return String.format("Keyspace %s already exists", keyspace);
        }
        return String.format("Object %s.%s already exists", keyspace, table);
    }

    @Override
    @NonNull
    public DriverException copy() {
        return new AlreadyExistsException(this.getCoordinator(), this.getMessage(), this.keyspace, this.table, this.getExecutionInfo(), true);
    }
}

