/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.logicaltypes;

import java.time.Duration;
import org.apache.beam.sdk.schemas.logicaltypes.NanosType;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class NanosDuration
extends NanosType<Duration> {
    public static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = "beam:logical_type:nanos_duration:v1";

    public NanosDuration() {
        super(IDENTIFIER);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Row toBaseType(@UnknownKeyFor @NonNull @Initialized Duration input) {
        return Row.withSchema(this.schema).addValues(input.getSeconds(), input.getNano()).build();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Duration toInputType(@UnknownKeyFor @NonNull @Initialized Row row) {
        return Duration.ofSeconds(Preconditions.checkArgumentNotNull(row.getInt64(0), "While trying to convert to Duration: Row missing seconds field"), Preconditions.checkArgumentNotNull(row.getInt32(1), "While trying to convert to Duration: Row missing nanos field").intValue());
    }
}

