/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.groupby;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringJoiner;
import java.util.TreeSet;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.ValueDataUtil;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNone;
import org.apache.hop.core.row.value.ValueMetaNumber;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.groupby.Aggregation;
import org.apache.hop.pipeline.transforms.groupby.GroupByData;
import org.apache.hop.pipeline.transforms.groupby.GroupByMeta;

public class GroupBy
extends BaseTransform<GroupByMeta, GroupByData> {
    private static final Class<?> PKG = GroupByMeta.class;
    private boolean allNullsAreZero = false;
    private boolean minNullIsValued = false;

    public GroupBy(TransformMeta transformMeta, GroupByMeta meta, GroupByData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (this.first) {
            int i;
            if (!((GroupByMeta)this.meta).isAlwaysGivingBackOneRow() && r == null) {
                this.setOutputDone();
                return false;
            }
            this.allNullsAreZero = this.getVariableBoolean("HOP_AGGREGATION_ALL_NULLS_ARE_ZERO", false);
            this.minNullIsValued = this.getVariableBoolean("HOP_AGGREGATION_MIN_NULL_IS_VALUED", false);
            ((GroupByData)this.data).inputRowMeta = this.getInputRowMeta();
            if (((GroupByData)this.data).inputRowMeta == null) {
                ((GroupByData)this.data).inputRowMeta = this.getPipelineMeta().getPrevTransformFields((IVariables)this, this.getTransformMeta());
            }
            ((GroupByData)this.data).outputRowMeta = ((GroupByData)this.data).inputRowMeta.clone();
            ((GroupByMeta)this.meta).getFields(((GroupByData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((GroupByData)this.data).counts = new long[((GroupByMeta)this.meta).getAggregations().size()];
            ((GroupByData)this.data).subjectnrs = new int[((GroupByMeta)this.meta).getAggregations().size()];
            ((GroupByData)this.data).cumulativeSumSourceIndexes = new ArrayList<Integer>();
            ((GroupByData)this.data).cumulativeSumTargetIndexes = new ArrayList<Integer>();
            ((GroupByData)this.data).cumulativeAvgSourceIndexes = new ArrayList<Integer>();
            ((GroupByData)this.data).cumulativeAvgTargetIndexes = new ArrayList<Integer>();
            for (i = 0; i < ((GroupByMeta)this.meta).getAggregations().size(); ++i) {
                Aggregation aggregation = ((GroupByMeta)this.meta).getAggregations().get(i);
                ((GroupByData)this.data).subjectnrs[i] = aggregation.getType() == 18 ? 0 : ((GroupByData)this.data).inputRowMeta.indexOfValue(aggregation.getSubject());
                if (r != null && ((GroupByData)this.data).subjectnrs[i] < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"GroupBy.Log.AggregateSubjectFieldCouldNotFound", (String[])new String[]{aggregation.getSubject()}));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                if (aggregation.getType() == 13) {
                    ((GroupByData)this.data).cumulativeSumSourceIndexes.add(((GroupByData)this.data).subjectnrs[i]);
                    ((GroupByData)this.data).cumulativeSumTargetIndexes.add(((GroupByData)this.data).inputRowMeta.size() + i);
                }
                if (aggregation.getType() != 14) continue;
                ((GroupByData)this.data).cumulativeAvgSourceIndexes.add(((GroupByData)this.data).subjectnrs[i]);
                ((GroupByData)this.data).cumulativeAvgTargetIndexes.add(((GroupByData)this.data).inputRowMeta.size() + i);
            }
            ((GroupByData)this.data).previousSums = new Object[((GroupByData)this.data).cumulativeSumTargetIndexes.size()];
            ((GroupByData)this.data).previousAvgSum = new Object[((GroupByData)this.data).cumulativeAvgTargetIndexes.size()];
            ((GroupByData)this.data).previousAvgCount = new long[((GroupByData)this.data).cumulativeAvgTargetIndexes.size()];
            ((GroupByData)this.data).groupnrs = new int[((GroupByMeta)this.meta).getGroupingFields().size()];
            for (i = 0; i < ((GroupByMeta)this.meta).getGroupingFields().size(); ++i) {
                ((GroupByData)this.data).groupnrs[i] = ((GroupByData)this.data).inputRowMeta.indexOfValue(((GroupByMeta)this.meta).getGroupingFields().get(i).getName());
                if (r == null || ((GroupByData)this.data).groupnrs[i] >= 0) continue;
                this.logError(BaseMessages.getString(PKG, (String)"GroupBy.Log.GroupFieldCouldNotFound", (String[])new String[]{((GroupByMeta)this.meta).getGroupingFields().get(i).getName()}));
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            ((GroupByData)this.data).valueMetaInteger = new ValueMetaInteger("count");
            ((GroupByData)this.data).valueMetaNumber = new ValueMetaNumber("sum");
            this.initGroupMeta(((GroupByData)this.data).inputRowMeta);
        }
        if (this.first || ((GroupByData)this.data).newBatch) {
            this.newAggregate(r);
        }
        if (this.first) {
            ((GroupByData)this.data).groupAggMeta = new RowMeta();
            ((GroupByData)this.data).groupAggMeta.addRowMeta(((GroupByData)this.data).groupMeta);
            ((GroupByData)this.data).groupAggMeta.addRowMeta(((GroupByData)this.data).aggMeta);
        }
        if (r == null) {
            this.handleLastOfGroup();
            this.setOutputDone();
            return false;
        }
        if (this.first || ((GroupByData)this.data).newBatch) {
            this.first = false;
            ((GroupByData)this.data).newBatch = false;
            ((GroupByData)this.data).previous = ((GroupByData)this.data).inputRowMeta.cloneRow(r);
        } else {
            this.calcAggregate(((GroupByData)this.data).previous);
            if (((GroupByMeta)this.meta).isPassAllRows()) {
                this.addToBuffer(((GroupByData)this.data).previous);
            }
        }
        if (!this.sameGroup(((GroupByData)this.data).previous, r)) {
            if (((GroupByMeta)this.meta).isPassAllRows()) {
                this.closeOutput();
                ((GroupByData)this.data).groupResult = this.getAggregateResult();
                Object[] row = this.getRowFromBuffer();
                long lineNr = 0L;
                while (row != null) {
                    int size = ((GroupByData)this.data).inputRowMeta.size();
                    row = RowDataUtil.addRowData((Object[])row, (int)size, (Object[])((GroupByData)this.data).groupResult);
                    size += ((GroupByData)this.data).groupResult.length;
                    ++lineNr;
                    if (((GroupByMeta)this.meta).isAddingLineNrInGroup() && !Utils.isEmpty((CharSequence)((GroupByMeta)this.meta).getLineNrInGroupField())) {
                        Long lineNrValue = lineNr;
                        row = RowDataUtil.addValueData((Object[])row, (int)size, (Object)lineNrValue);
                    }
                    this.addCumulativeSums(row);
                    this.addCumulativeAverages(row);
                    this.putRow(((GroupByData)this.data).outputRowMeta, row);
                    row = this.getRowFromBuffer();
                }
                this.closeInput();
            } else {
                Object[] result = this.buildResult(((GroupByData)this.data).previous);
                if (result != null) {
                    this.putRow(((GroupByData)this.data).groupAggMeta, result);
                }
            }
            this.newAggregate(r);
        }
        ((GroupByData)this.data).previous = ((GroupByData)this.data).inputRowMeta.cloneRow(r);
        if (this.checkFeedback(this.getLinesRead()) && this.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"GroupBy.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    private void handleLastOfGroup() throws HopException {
        if (((GroupByMeta)this.meta).isPassAllRows()) {
            if (((GroupByData)this.data).previous != null) {
                this.calcAggregate(((GroupByData)this.data).previous);
                this.addToBuffer(((GroupByData)this.data).previous);
            }
            ((GroupByData)this.data).groupResult = this.getAggregateResult();
            Object[] row = this.getRowFromBuffer();
            long lineNr = 0L;
            while (row != null) {
                int size = ((GroupByData)this.data).inputRowMeta.size();
                row = RowDataUtil.addRowData((Object[])row, (int)size, (Object[])((GroupByData)this.data).groupResult);
                size += ((GroupByData)this.data).groupResult.length;
                ++lineNr;
                if (((GroupByMeta)this.meta).isAddingLineNrInGroup() && !Utils.isEmpty((CharSequence)((GroupByMeta)this.meta).getLineNrInGroupField())) {
                    Long lineNrValue = lineNr;
                    row = RowDataUtil.addValueData((Object[])row, (int)size, (Object)lineNrValue);
                }
                this.addCumulativeSums(row);
                this.addCumulativeAverages(row);
                this.putRow(((GroupByData)this.data).outputRowMeta, row);
                row = this.getRowFromBuffer();
            }
            this.closeInput();
        } else {
            Object[] result;
            if (((GroupByData)this.data).previous != null) {
                this.calcAggregate(((GroupByData)this.data).previous);
            }
            if ((result = this.buildResult(((GroupByData)this.data).previous)) != null) {
                this.putRow(((GroupByData)this.data).groupAggMeta, result);
            }
        }
    }

    private void addCumulativeSums(Object[] row) throws HopValueException {
        for (int i = 0; i < ((GroupByData)this.data).cumulativeSumSourceIndexes.size(); ++i) {
            int sourceIndex = ((GroupByData)this.data).cumulativeSumSourceIndexes.get(i);
            Object previousTarget = ((GroupByData)this.data).previousSums[i];
            Object sourceValue = row[sourceIndex];
            int targetIndex = ((GroupByData)this.data).cumulativeSumTargetIndexes.get(i);
            IValueMeta sourceMeta = ((GroupByData)this.data).inputRowMeta.getValueMeta(sourceIndex);
            IValueMeta targetMeta = ((GroupByData)this.data).outputRowMeta.getValueMeta(targetIndex);
            row[targetIndex] = targetMeta.isNull(previousTarget) ? sourceMeta.convertToNormalStorageType(sourceValue) : (sourceMeta.isNull(sourceValue) ? previousTarget : ValueDataUtil.plus((IValueMeta)targetMeta, (Object)((GroupByData)this.data).previousSums[i], (IValueMeta)sourceMeta, (Object)row[sourceIndex]));
            ((GroupByData)this.data).previousSums[i] = row[targetIndex];
        }
    }

    private void addCumulativeAverages(Object[] row) throws HopValueException {
        for (int i = 0; i < ((GroupByData)this.data).cumulativeAvgSourceIndexes.size(); ++i) {
            int sourceIndex = ((GroupByData)this.data).cumulativeAvgSourceIndexes.get(i);
            Object previousTarget = ((GroupByData)this.data).previousAvgSum[i];
            Object sourceValue = row[sourceIndex];
            int targetIndex = ((GroupByData)this.data).cumulativeAvgTargetIndexes.get(i);
            IValueMeta sourceMeta = ((GroupByData)this.data).inputRowMeta.getValueMeta(sourceIndex);
            IValueMeta targetMeta = ((GroupByData)this.data).outputRowMeta.getValueMeta(targetIndex);
            Object sum = null;
            sum = targetMeta.isNull(previousTarget) ? sourceMeta.convertToNormalStorageType(sourceValue) : (sourceMeta.isNull(sourceValue) ? previousTarget : (sourceMeta.isInteger() ? ValueDataUtil.plus((IValueMeta)((GroupByData)this.data).valueMetaInteger, (Object)((GroupByData)this.data).previousAvgSum[i], (IValueMeta)sourceMeta, (Object)row[sourceIndex]) : ValueDataUtil.plus((IValueMeta)targetMeta, (Object)((GroupByData)this.data).previousAvgSum[i], (IValueMeta)sourceMeta, (Object)row[sourceIndex])));
            ((GroupByData)this.data).previousAvgSum[i] = sum;
            if (!sourceMeta.isNull(sourceValue)) {
                int n = i;
                ((GroupByData)this.data).previousAvgCount[n] = ((GroupByData)this.data).previousAvgCount[n] + 1L;
            }
            if (sourceMeta.isInteger()) {
                if (sum == null) {
                    row[targetIndex] = null;
                    continue;
                }
                row[targetIndex] = ((Long)sum).doubleValue() / (double)((GroupByData)this.data).previousAvgCount[i];
                continue;
            }
            row[targetIndex] = ValueDataUtil.divide((IValueMeta)targetMeta, (Object)sum, (IValueMeta)((GroupByData)this.data).valueMetaInteger, (Object)((GroupByData)this.data).previousAvgCount[i]);
        }
    }

    boolean sameGroup(Object[] previous, Object[] r) throws HopValueException {
        return ((GroupByData)this.data).inputRowMeta.compare(previous, r, ((GroupByData)this.data).groupnrs) == 0;
    }

    void calcAggregate(Object[] row) throws HopValueException {
        block19: for (int i = 0; i < ((GroupByData)this.data).subjectnrs.length; ++i) {
            Aggregation aggregation = ((GroupByMeta)this.meta).getAggregations().get(i);
            Object subj = row[((GroupByData)this.data).subjectnrs[i]];
            IValueMeta subjMeta = ((GroupByData)this.data).inputRowMeta.getValueMeta(((GroupByData)this.data).subjectnrs[i]);
            Object value = ((GroupByData)this.data).agg[i];
            IValueMeta valueMeta = ((GroupByData)this.data).aggMeta.getValueMeta(i);
            switch (aggregation.getType()) {
                case 1: {
                    ((GroupByData)this.data).agg[i] = ValueDataUtil.sum((IValueMeta)valueMeta, (Object)value, (IValueMeta)subjMeta, (Object)subj);
                    continue block19;
                }
                case 2: {
                    if (subjMeta.isNull(subj)) continue block19;
                    ((GroupByData)this.data).agg[i] = ValueDataUtil.sum((IValueMeta)valueMeta, (Object)value, (IValueMeta)subjMeta, (Object)subj);
                    int n = i;
                    ((GroupByData)this.data).counts[n] = ((GroupByData)this.data).counts[n] + 1L;
                    continue block19;
                }
                case 3: 
                case 4: 
                case 20: {
                    if (subjMeta.isNull(subj)) continue block19;
                    ((List)((GroupByData)this.data).agg[i]).add(subjMeta.getNumber(subj));
                    continue block19;
                }
                case 15: 
                case 19: {
                    if (subjMeta.isNull(subj)) continue block19;
                    int n = i;
                    ((GroupByData)this.data).counts[n] = ((GroupByData)this.data).counts[n] + 1L;
                    double n2 = ((GroupByData)this.data).counts[i];
                    double x = subjMeta.getNumber(subj);
                    double sum = value == null ? Double.valueOf(0.0) : (Double)value;
                    double mean = ((GroupByData)this.data).mean[i];
                    double delta = x - mean;
                    ((GroupByData)this.data).mean[i] = mean;
                    ((GroupByData)this.data).agg[i] = sum += delta * (x - (mean += delta / n2));
                    continue block19;
                }
                case 17: {
                    Object obj;
                    if (subjMeta.isNull(subj)) continue block19;
                    if (((GroupByData)this.data).distinctObjs == null) {
                        ((GroupByData)this.data).distinctObjs = new Set[((GroupByMeta)this.meta).getAggregations().size()];
                    }
                    if (((GroupByData)this.data).distinctObjs[i] == null) {
                        ((GroupByData)this.data).distinctObjs[i] = new TreeSet<Object>();
                    }
                    if (((GroupByData)this.data).distinctObjs[i].contains(obj = subjMeta.convertToNormalStorageType(subj))) continue block19;
                    ((GroupByData)this.data).distinctObjs[i].add(obj);
                    value = value == null ? Long.valueOf(0L) : value;
                    ((GroupByData)this.data).agg[i] = (Long)value + 1L;
                    continue block19;
                }
                case 7: {
                    if (subjMeta.isNull(subj)) continue block19;
                    int n = i;
                    ((GroupByData)this.data).counts[n] = ((GroupByData)this.data).counts[n] + 1L;
                    continue block19;
                }
                case 18: {
                    int n = i;
                    ((GroupByData)this.data).counts[n] = ((GroupByData)this.data).counts[n] + 1L;
                    continue block19;
                }
                case 5: {
                    if (subj == null && !this.minNullIsValued) continue block19;
                    if (value == null && subj != null && !this.minNullIsValued) {
                        ((GroupByData)this.data).agg[i] = subj;
                        continue block19;
                    }
                    if (subjMeta.isSortedDescending()) {
                        if (subjMeta.compare(value, valueMeta, subj) >= 0) continue block19;
                        ((GroupByData)this.data).agg[i] = subj;
                        continue block19;
                    }
                    if (subjMeta.compare(subj, valueMeta, value) >= 0) continue block19;
                    ((GroupByData)this.data).agg[i] = subj;
                    continue block19;
                }
                case 6: {
                    if (subjMeta.isSortedDescending()) {
                        if (subjMeta.compare(value, valueMeta, subj) <= 0) continue block19;
                        ((GroupByData)this.data).agg[i] = subj;
                        continue block19;
                    }
                    if (subjMeta.compare(subj, valueMeta, value) <= 0) continue block19;
                    ((GroupByData)this.data).agg[i] = subj;
                    continue block19;
                }
                case 9: {
                    if (subj == null || value != null) continue block19;
                    ((GroupByData)this.data).agg[i] = subj;
                    continue block19;
                }
                case 10: {
                    if (subj == null) continue block19;
                    ((GroupByData)this.data).agg[i] = subj;
                    continue block19;
                }
                case 11: {
                    continue block19;
                }
                case 12: {
                    ((GroupByData)this.data).agg[i] = subj;
                    continue block19;
                }
                case 8: {
                    if (subj == null) continue block19;
                    StringBuilder sb = (StringBuilder)value;
                    if (!sb.isEmpty()) {
                        sb.append(", ");
                    }
                    sb.append(subjMeta.getString(subj));
                    continue block19;
                }
                case 21: {
                    if (subj == null) continue block19;
                    StringBuilder sb = (StringBuilder)value;
                    if (!sb.isEmpty()) {
                        sb.append(Const.CR);
                    }
                    sb.append(subjMeta.getString(subj));
                    continue block19;
                }
                case 16: {
                    StringBuilder sb;
                    if (subj == null) continue block19;
                    String separator = "";
                    if (!Utils.isEmpty((CharSequence)aggregation.getValue())) {
                        separator = this.resolve(aggregation.getValue());
                    }
                    if (!(sb = (StringBuilder)value).isEmpty()) {
                        sb.append(separator);
                    }
                    sb.append(subjMeta.getString(subj));
                    continue block19;
                }
                case 22: {
                    if (subj == null) continue block19;
                    SortedSet set = (SortedSet)value;
                    set.add(subj);
                }
            }
        }
    }

    void newAggregate(Object[] r) throws HopException {
        int i;
        for (i = 0; i < ((GroupByData)this.data).counts.length; ++i) {
            ((GroupByData)this.data).counts[i] = 0L;
        }
        ((GroupByData)this.data).distinctObjs = null;
        ((GroupByData)this.data).agg = new Object[((GroupByData)this.data).subjectnrs.length];
        ((GroupByData)this.data).mean = new double[((GroupByData)this.data).subjectnrs.length];
        ((GroupByData)this.data).aggMeta = new RowMeta();
        for (i = 0; i < ((GroupByData)this.data).subjectnrs.length; ++i) {
            Aggregation aggregation = ((GroupByMeta)this.meta).getAggregations().get(i);
            IValueMeta subjMeta = ((GroupByData)this.data).inputRowMeta.getValueMeta(((GroupByData)this.data).subjectnrs[i]);
            Serializable v = null;
            IValueMeta vMeta = null;
            int aggType = aggregation.getType();
            String fieldName = aggregation.getField();
            switch (aggType) {
                case 1: 
                case 2: 
                case 13: 
                case 14: {
                    if (subjMeta.isNumeric()) {
                        try {
                            vMeta = ValueMetaFactory.createValueMeta((String)fieldName, (int)subjMeta.getType());
                        }
                        catch (HopPluginException e) {
                            vMeta = new ValueMetaNone(fieldName);
                        }
                        break;
                    }
                    vMeta = new ValueMetaNumber(fieldName);
                    break;
                }
                case 3: 
                case 4: 
                case 20: {
                    vMeta = new ValueMetaNumber(fieldName);
                    v = new ArrayList();
                    break;
                }
                case 15: 
                case 19: {
                    vMeta = new ValueMetaNumber(fieldName);
                    break;
                }
                case 7: 
                case 17: 
                case 18: {
                    vMeta = new ValueMetaInteger(fieldName);
                    break;
                }
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    vMeta = subjMeta.clone();
                    vMeta.setName(fieldName);
                    v = r == null ? null : r[((GroupByData)this.data).subjectnrs[i]];
                    break;
                }
                case 8: 
                case 21: {
                    vMeta = new ValueMetaString(fieldName);
                    v = new StringBuilder();
                    break;
                }
                case 16: {
                    vMeta = new ValueMetaString(fieldName);
                    v = new StringBuilder();
                    break;
                }
                case 22: {
                    vMeta = new ValueMetaString(fieldName);
                    v = new TreeSet();
                    break;
                }
                default: {
                    throw new HopException("Please specify an aggregation type for field '" + fieldName + "'");
                }
            }
            if (subjMeta != null && aggType != 7 && aggType != 17 && aggType != 18) {
                vMeta.setLength(subjMeta.getLength(), subjMeta.getPrecision());
            }
            ((GroupByData)this.data).agg[i] = v;
            ((GroupByData)this.data).aggMeta.addValueMeta(vMeta);
        }
        for (i = 0; i < ((GroupByData)this.data).previousSums.length; ++i) {
            ((GroupByData)this.data).previousSums[i] = null;
        }
        for (i = 0; i < ((GroupByData)this.data).previousAvgCount.length; ++i) {
            ((GroupByData)this.data).previousAvgCount[i] = 0L;
            ((GroupByData)this.data).previousAvgSum[i] = null;
        }
    }

    private Object[] buildResult(Object[] r) throws HopValueException {
        Object[] result = null;
        if (r != null || ((GroupByMeta)this.meta).isAlwaysGivingBackOneRow()) {
            result = RowDataUtil.allocateRowData((int)((GroupByData)this.data).groupnrs.length);
            if (r != null) {
                for (int i = 0; i < ((GroupByData)this.data).groupnrs.length; ++i) {
                    result[i] = r[((GroupByData)this.data).groupnrs[i]];
                }
            }
            result = RowDataUtil.addRowData((Object[])result, (int)((GroupByData)this.data).groupnrs.length, (Object[])this.getAggregateResult());
        }
        return result;
    }

    private void initGroupMeta(IRowMeta previousRowMeta) throws HopValueException {
        ((GroupByData)this.data).groupMeta = new RowMeta();
        for (int i = 0; i < ((GroupByData)this.data).groupnrs.length; ++i) {
            ((GroupByData)this.data).groupMeta.addValueMeta(previousRowMeta.getValueMeta(((GroupByData)this.data).groupnrs[i]));
        }
    }

    Object[] getAggregateResult() throws HopValueException {
        if (((GroupByData)this.data).subjectnrs == null) {
            return new Object[0];
        }
        Object[] result = new Object[((GroupByData)this.data).subjectnrs.length];
        for (int i = 0; i < ((GroupByData)this.data).subjectnrs.length; ++i) {
            Aggregation aggregation = ((GroupByMeta)this.meta).getAggregations().get(i);
            Object ag = ((GroupByData)this.data).agg[i];
            int aggType = aggregation.getType();
            String fieldName = aggregation.getField();
            switch (aggType) {
                case 1: {
                    break;
                }
                case 2: {
                    ag = ValueDataUtil.divide((IValueMeta)((GroupByData)this.data).aggMeta.getValueMeta(i), (Object)ag, (IValueMeta)new ValueMetaInteger("c"), (Object)((GroupByData)this.data).counts[i]);
                    break;
                }
                case 3: 
                case 4: {
                    double percentile = 50.0;
                    if (aggType == 4) {
                        percentile = Double.parseDouble(aggregation.getValue());
                    }
                    List valuesList = (List)((GroupByData)this.data).agg[i];
                    double[] values = new double[valuesList.size()];
                    for (int v = 0; v < values.length; ++v) {
                        values[v] = (Double)valuesList.get(v);
                    }
                    ag = new Percentile().evaluate(values, percentile);
                    break;
                }
                case 20: {
                    double percentileValue = 50.0;
                    if (aggType == 20) {
                        percentileValue = Double.parseDouble(aggregation.getValue());
                    }
                    List latenciesList = (List)((GroupByData)this.data).agg[i];
                    Collections.sort(latenciesList);
                    Double[] latencies = new Double[latenciesList.size()];
                    latencies = latenciesList.toArray(latencies);
                    int index = (int)Math.ceil(percentileValue / 100.0 * (double)latencies.length);
                    ag = latencies[index - 1];
                    break;
                }
                case 7: 
                case 18: {
                    ag = ((GroupByData)this.data).counts[i];
                    break;
                }
                case 17: {
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    break;
                }
                case 15: {
                    if (ag == null) break;
                    double sum = (Double)ag / (double)((GroupByData)this.data).counts[i];
                    ag = Math.sqrt(sum);
                    break;
                }
                case 19: {
                    if (ag == null) break;
                    double sum = (Double)ag / (double)(((GroupByData)this.data).counts[i] - 1L);
                    ag = Math.sqrt(sum);
                    break;
                }
                case 8: 
                case 16: 
                case 21: {
                    ag = ((StringBuilder)ag).toString();
                    break;
                }
                case 22: {
                    IValueMeta subjMeta = ((GroupByData)this.data).inputRowMeta.getValueMeta(((GroupByData)this.data).subjectnrs[i]);
                    String separator = "";
                    if (!Utils.isEmpty((CharSequence)aggregation.getValue())) {
                        separator = this.resolve(aggregation.getValue());
                    }
                    StringJoiner joiner = new StringJoiner(separator);
                    for (Object value : (SortedSet)ag) {
                        joiner.add(subjMeta.getString(value));
                    }
                    ag = joiner.toString();
                    break;
                }
            }
            if (ag == null && this.allNullsAreZero) {
                IValueMeta vm = ((GroupByData)this.data).aggMeta.getValueMeta(i);
                ag = ValueDataUtil.getZeroForValueMetaType((IValueMeta)vm);
            }
            result[i] = ag;
        }
        return result;
    }

    void addToBuffer(Object[] row) throws HopFileException {
        ((GroupByData)this.data).bufferList.add(row);
        if (((GroupByData)this.data).bufferList.size() > 5000 && ((GroupByData)this.data).rowsOnFile == 0) {
            String pathToTmp = this.resolve(this.getMeta().getDirectory());
            try {
                File ioFile = new File(pathToTmp);
                if (!ioFile.exists()) {
                    pathToTmp = this.retrieveVfsPath(pathToTmp);
                }
                ((GroupByData)this.data).tempFile = File.createTempFile(this.getMeta().getPrefix(), ".tmp", new File(pathToTmp));
                ((GroupByData)this.data).fosToTempFile = new FileOutputStream(((GroupByData)this.data).tempFile);
                ((GroupByData)this.data).dosToTempFile = new DataOutputStream(((GroupByData)this.data).fosToTempFile);
                ((GroupByData)this.data).firstRead = true;
            }
            catch (IOException e) {
                throw new HopFileException(BaseMessages.getString(PKG, (String)"GroupBy.Exception.UnableToCreateTemporaryFile", (String[])new String[0]), (Throwable)e);
            }
            Object[] oldest = ((GroupByData)this.data).bufferList.get(0);
            ((GroupByData)this.data).inputRowMeta.writeData(((GroupByData)this.data).dosToTempFile, oldest);
            ((GroupByData)this.data).bufferList.remove(0);
            ++((GroupByData)this.data).rowsOnFile;
        }
    }

    public String retrieveVfsPath(String pathToTmp) throws HopFileException {
        FileObject vfsFile = HopVfs.getFileObject((String)pathToTmp);
        return vfsFile.getName().getPath();
    }

    private Object[] getRowFromBuffer() throws HopFileException {
        if (((GroupByData)this.data).rowsOnFile > 0) {
            Object[] row;
            if (((GroupByData)this.data).firstRead) {
                try {
                    ((GroupByData)this.data).fisToTmpFile = new FileInputStream(((GroupByData)this.data).tempFile);
                    ((GroupByData)this.data).disToTmpFile = new DataInputStream(((GroupByData)this.data).fisToTmpFile);
                    ((GroupByData)this.data).firstRead = false;
                }
                catch (IOException e) {
                    throw new HopFileException(BaseMessages.getString(PKG, (String)"GroupBy.Exception.UnableToReadBackRowFromTemporaryFile", (String[])new String[0]), (Throwable)e);
                }
            }
            try {
                row = ((GroupByData)this.data).inputRowMeta.readData(((GroupByData)this.data).disToTmpFile);
            }
            catch (SocketTimeoutException e) {
                throw new HopFileException((Throwable)e);
            }
            --((GroupByData)this.data).rowsOnFile;
            return row;
        }
        if (!((GroupByData)this.data).bufferList.isEmpty()) {
            Object[] row = ((GroupByData)this.data).bufferList.get(0);
            ((GroupByData)this.data).bufferList.remove(0);
            return row;
        }
        return null;
    }

    private void closeOutput() throws HopFileException {
        try {
            if (((GroupByData)this.data).dosToTempFile != null) {
                ((GroupByData)this.data).dosToTempFile.close();
                ((GroupByData)this.data).dosToTempFile = null;
            }
            if (((GroupByData)this.data).fosToTempFile != null) {
                ((GroupByData)this.data).fosToTempFile.close();
                ((GroupByData)this.data).fosToTempFile = null;
            }
            ((GroupByData)this.data).firstRead = true;
        }
        catch (IOException e) {
            throw new HopFileException(BaseMessages.getString(PKG, (String)"GroupBy.Exception.UnableToCloseInputStream", (String[])new String[]{((GroupByData)this.data).tempFile.getPath()}), (Throwable)e);
        }
    }

    private void closeInput() throws HopFileException {
        try {
            if (((GroupByData)this.data).fisToTmpFile != null) {
                ((GroupByData)this.data).fisToTmpFile.close();
                ((GroupByData)this.data).fisToTmpFile = null;
            }
            if (((GroupByData)this.data).disToTmpFile != null) {
                ((GroupByData)this.data).disToTmpFile.close();
                ((GroupByData)this.data).disToTmpFile = null;
            }
        }
        catch (IOException e) {
            throw new HopFileException(BaseMessages.getString(PKG, (String)"GroupBy.Exception.UnableToCloseInputStream", (String[])new String[]{((GroupByData)this.data).tempFile.getPath()}), (Throwable)e);
        }
    }

    public boolean init() {
        if (super.init()) {
            ((GroupByData)this.data).bufferList = new ArrayList();
            ((GroupByData)this.data).rowsOnFile = 0;
            return true;
        }
        return false;
    }

    public void dispose() {
        if (((GroupByData)this.data).tempFile != null) {
            try {
                this.closeInput();
                this.closeOutput();
            }
            catch (HopFileException e) {
                this.logError(e.getLocalizedMessage());
            }
            boolean tempFileDeleted = ((GroupByData)this.data).tempFile.delete();
            if (!tempFileDeleted && this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"GroupBy.Exception.UnableToDeleteTemporaryFile", (String[])new String[]{((GroupByData)this.data).tempFile.getPath()}));
            }
        }
        super.dispose();
    }

    public void batchComplete() throws HopException {
        this.handleLastOfGroup();
        ((GroupByData)this.data).newBatch = true;
    }

    void setAllNullsAreZero(boolean allNullsAreZero) {
        this.allNullsAreZero = allNullsAreZero;
    }

    void setMinNullIsValued(boolean minNullIsValued) {
        this.minNullIsValued = minNullIsValued;
    }

    public GroupByMeta getMeta() {
        return (GroupByMeta)this.meta;
    }
}

