/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.googleanalytics;

import com.google.analytics.data.v1beta.BetaAnalyticsDataClient;
import com.google.analytics.data.v1beta.BetaAnalyticsDataSettings;
import com.google.analytics.data.v1beta.DateRange;
import com.google.analytics.data.v1beta.Dimension;
import com.google.analytics.data.v1beta.DimensionHeader;
import com.google.analytics.data.v1beta.Metric;
import com.google.analytics.data.v1beta.MetricHeader;
import com.google.analytics.data.v1beta.MetricType;
import com.google.analytics.data.v1beta.Row;
import com.google.analytics.data.v1beta.RunReportRequest;
import com.google.analytics.data.v1beta.RunReportResponse;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNumber;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.TransformStatus;
import org.apache.hop.pipeline.transforms.googleanalytics.GoogleAnalyticsData;
import org.apache.hop.pipeline.transforms.googleanalytics.GoogleAnalyticsField;
import org.apache.hop.pipeline.transforms.googleanalytics.GoogleAnalyticsMeta;

public class GoogleAnalytics
extends BaseTransform<GoogleAnalyticsMeta, GoogleAnalyticsData> {
    private BetaAnalyticsDataClient analyticsData;
    private List<Dimension> dimensionList;
    private List<Metric> metricList;
    private InputStream inputStream;
    private int requestOffset = 0;
    private int requestRowSize = 100000;
    private int rowLimit;

    public GoogleAnalytics(TransformMeta transformMeta, GoogleAnalyticsMeta meta, GoogleAnalyticsData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean init() {
        if (super.init()) {
            try {
                this.rowLimit = ((GoogleAnalyticsMeta)this.meta).getRowLimit() == 0 ? Integer.MAX_VALUE : ((GoogleAnalyticsMeta)this.meta).getRowLimit();
                this.inputStream = new FileInputStream(((GoogleAnalyticsMeta)this.meta).getOAuthKeyFile());
                ServiceAccountCredentials credentials = ServiceAccountCredentials.fromStream((InputStream)this.inputStream);
                BetaAnalyticsDataSettings settings = ((BetaAnalyticsDataSettings.Builder)BetaAnalyticsDataSettings.newHttpJsonBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)credentials))).build();
                this.analyticsData = BetaAnalyticsDataClient.create((BetaAnalyticsDataSettings)settings);
                this.dimensionList = new ArrayList<Dimension>();
                String dimensionString = ((GoogleAnalyticsMeta)this.meta).getDimensions();
                for (String dimension : dimensionString.split(",")) {
                    this.dimensionList.add(Dimension.newBuilder().setName(dimension).build());
                }
                this.metricList = new ArrayList<Metric>();
                String metricsString = ((GoogleAnalyticsMeta)this.meta).getMetrics();
                for (String metric : metricsString.split(",")) {
                    this.metricList.add(Metric.newBuilder().setName(metric).build());
                }
                if (this.rowLimit < this.requestRowSize) {
                    this.requestRowSize = this.rowLimit;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            return true;
        }
        return false;
    }

    private RunReportRequest getRequest() {
        return RunReportRequest.newBuilder().setProperty("properties/" + ((GoogleAnalyticsMeta)this.meta).getGaProperty()).addAllDimensions(this.dimensionList).addAllMetrics(this.metricList).addDateRanges(DateRange.newBuilder().setStartDate(((GoogleAnalyticsMeta)this.meta).getStartDate()).setEndDate(((GoogleAnalyticsMeta)this.meta).getEndDate())).setLimit((long)this.requestRowSize).setOffset((long)this.requestOffset).build();
    }

    public boolean processRow() throws HopException {
        if (this.first) {
            this.first = false;
            ((GoogleAnalyticsData)this.data).outputMeta = new RowMeta();
            ((GoogleAnalyticsMeta)this.meta).getFields(((GoogleAnalyticsData)this.data).outputMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            this.readResponse();
        }
        if (this.isBasic()) {
            this.logBasic("all rows processed. ready to shut down.");
        }
        this.setOutputDone();
        return false;
    }

    private void readResponse() {
        RunReportResponse response = this.analyticsData.runReport(this.getRequest());
        List dimensionHeaders = response.getDimensionHeadersList();
        List metricHeaders = response.getMetricHeadersList();
        if (!response.getRowsList().isEmpty()) {
            try {
                for (Row gaRow : response.getRowsList()) {
                    Object[] newRow = RowDataUtil.allocateRowData((int)((GoogleAnalyticsMeta)this.meta).getGoogleAnalyticsFields().size());
                    for (int i = 0; i < ((GoogleAnalyticsMeta)this.meta).getGoogleAnalyticsFields().size(); ++i) {
                        int j;
                        GoogleAnalyticsField field = ((GoogleAnalyticsMeta)this.meta).getGoogleAnalyticsFields().get(i);
                        String fieldName = field.getFeedField();
                        String type = field.getFeedFieldType();
                        if (type.equals("Dimension")) {
                            for (j = 0; j < dimensionHeaders.size(); ++j) {
                                if (!((DimensionHeader)dimensionHeaders.get(j)).getName().equals(fieldName)) continue;
                                newRow[i] = gaRow.getDimensionValues(j).getValue();
                            }
                            continue;
                        }
                        if (!type.equals("Metric")) continue;
                        block9: for (j = 0; j < metricHeaders.size(); ++j) {
                            if (!((MetricHeader)metricHeaders.get(j)).getName().equals(fieldName)) continue;
                            MetricType metricType = ((MetricHeader)metricHeaders.get(j)).getType();
                            switch (metricType) {
                                case TYPE_INTEGER: {
                                    ValueMetaInteger valueMetaInt = new ValueMetaInteger("int");
                                    IValueMeta gaValueMetaInt = ((GoogleAnalyticsData)this.data).outputMeta.getValueMeta(this.dimensionList.size() + j);
                                    Long longValue = Long.valueOf(gaRow.getMetricValues(j).getValue());
                                    newRow[i] = gaValueMetaInt.convertData((IValueMeta)valueMetaInt, (Object)longValue);
                                    continue block9;
                                }
                                case TYPE_FLOAT: 
                                case TYPE_SECONDS: 
                                case TYPE_MILLISECONDS: 
                                case TYPE_MINUTES: 
                                case TYPE_HOURS: 
                                case TYPE_STANDARD: 
                                case TYPE_CURRENCY: 
                                case TYPE_FEET: 
                                case TYPE_MILES: 
                                case TYPE_METERS: 
                                case TYPE_KILOMETERS: {
                                    ValueMetaNumber valueMetaNumber = new ValueMetaNumber("num");
                                    IValueMeta gaValueMetaNumber = ((GoogleAnalyticsData)this.data).outputMeta.getValueMeta(this.dimensionList.size() + j);
                                    Double doubleValue = Double.valueOf(gaRow.getMetricValues(j).getValue());
                                    newRow[i] = gaValueMetaNumber.convertData((IValueMeta)valueMetaNumber, (Object)doubleValue);
                                    continue block9;
                                }
                                default: {
                                    newRow[i] = gaRow.getMetricValues(j).getValue();
                                }
                            }
                        }
                    }
                    this.putRow(((GoogleAnalyticsData)this.data).outputMeta, newRow);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int rowsProcessed = (int)this.getLinesWritten();
            if (this.getLinesWritten() + (long)this.requestRowSize > (long)this.rowLimit) {
                this.requestRowSize = this.rowLimit - (int)this.getLinesWritten();
            }
            this.requestOffset = (int)this.getLinesWritten();
            if (rowsProcessed < this.rowLimit) {
                this.readResponse();
            }
        }
    }

    public Collection<TransformStatus> subStatuses() {
        return super.subStatuses();
    }

    public void dispose() {
        try {
            this.inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.analyticsData.close();
        super.dispose();
    }
}

