/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.org.apache.commons.compress.archivers;

import com.clickhouse.client.internal.org.apache.commons.compress.CompressFilterOutputStream;
import com.clickhouse.client.internal.org.apache.commons.compress.archivers.ArchiveEntry;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public abstract class ArchiveOutputStream<E extends ArchiveEntry>
extends CompressFilterOutputStream<OutputStream> {
    static final int BYTE_MASK = 255;
    private final byte[] oneByte = new byte[1];
    private long bytesWritten;

    public ArchiveOutputStream() {
    }

    public ArchiveOutputStream(OutputStream out) {
        super(out);
    }

    public boolean canWriteEntryData(ArchiveEntry archiveEntry) {
        return true;
    }

    protected void checkFinished() throws IOException {
        if (this.isFinished()) {
            throw new IOException("Stream has already been finished.");
        }
    }

    public abstract void closeArchiveEntry() throws IOException;

    protected void count(int written) {
        this.count((long)written);
    }

    protected void count(long written) {
        if (written != -1L) {
            this.bytesWritten += written;
        }
    }

    public abstract E createArchiveEntry(File var1, String var2) throws IOException;

    public E createArchiveEntry(Path inputPath, String entryName, LinkOption ... options) throws IOException {
        return this.createArchiveEntry(inputPath.toFile(), entryName);
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Deprecated
    public int getCount() {
        return (int)this.bytesWritten;
    }

    public abstract void putArchiveEntry(E var1) throws IOException;

    @Override
    public void write(int b) throws IOException {
        this.oneByte[0] = (byte)(b & 0xFF);
        this.write(this.oneByte, 0, 1);
    }
}

