/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.execution.path.base;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.neo4j.execution.path.PathResult;
import org.apache.hop.neo4j.execution.path.base.NeoExecutionViewerTabBase;
import org.apache.hop.neo4j.logging.util.LoggingCore;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.TreeMemory;
import org.apache.hop.ui.core.widget.TreeUtil;
import org.apache.hop.ui.hopgui.shared.BaseExecutionViewer;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Value;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;

@GuiPlugin
public class NeoExecutionViewerLineageTab
extends NeoExecutionViewerTabBase {
    private Tree wTree;

    public NeoExecutionViewerLineageTab(BaseExecutionViewer viewer) {
        super(viewer);
    }

    public void addNeoExecutionPathTab(CTabFolder tabFolder) {
        Image lineageImage = GuiResource.getInstance().getImage("lineage.svg", this.classLoader, this.iconSize, this.iconSize);
        CTabItem lineageTab = new CTabItem(tabFolder, 0);
        lineageTab.setFont(GuiResource.getInstance().getFontDefault());
        lineageTab.setImage(lineageImage);
        lineageTab.setText(BaseMessages.getString((Class)PKG, (String)"Neo4jPerspectiveDialog.Lineage.Tab", (String[])new String[0]));
        Composite tabComposite = new Composite((Composite)tabFolder, 0);
        lineageTab.setControl((Control)tabComposite);
        tabComposite.setLayout((Layout)new FormLayout());
        Button wGo = new Button(tabComposite, 8);
        wGo.setText(BaseMessages.getString((String)"System.Button.Open"));
        PropsUi.setLook((Widget)wGo);
        wGo.addListener(13, e -> this.openItem(this.wTree));
        BaseTransformDialog.positionBottomButtons((Composite)tabComposite, (Button[])new Button[]{wGo}, (int)PropsUi.getMargin(), null);
        this.wTree = new Tree(tabComposite, 2820);
        PropsUi.setLook((Widget)this.wTree);
        FormData fdTree = new FormData();
        fdTree.left = new FormAttachment(0, 0);
        fdTree.top = new FormAttachment(0, 0);
        fdTree.bottom = new FormAttachment((Control)wGo, -PropsUi.getMargin());
        fdTree.right = new FormAttachment(100, 0);
        this.wTree.setLayoutData((Object)fdTree);
        this.wTree.addListener(14, e -> this.openItem(this.wTree));
        this.wTree.setHeaderVisible(true);
        TreeColumn column = new TreeColumn(this.wTree, 16384);
        column.setText("#");
        column.setWidth((int)(50.0 * this.props.getZoomFactor()));
        column = new TreeColumn(this.wTree, 16384);
        column.setText("id");
        column.setWidth((int)(250.0 * this.props.getZoomFactor()));
        column = new TreeColumn(this.wTree, 16384);
        column.setText("Name");
        column.setWidth((int)(300.0 * this.props.getZoomFactor()));
        column = new TreeColumn(this.wTree, 16384);
        column.setText("Type");
        column.setWidth((int)(100.0 * this.props.getZoomFactor()));
        column = new TreeColumn(this.wTree, 16384);
        column.setText("Failed?");
        column.setWidth((int)(50.0 * this.props.getZoomFactor()));
        column = new TreeColumn(this.wTree, 16384);
        column.setText("date");
        column.setWidth((int)(200.0 * this.props.getZoomFactor()));
        tabFolder.addListener(13, e -> {
            if (lineageTab == tabFolder.getSelection()) {
                this.refresh();
            }
        });
    }

    private void refresh() {
        List<List<PathResult>> lineagePaths = this.getLineageToRoot(this.getActiveLogChannelId());
        for (TreeItem treeItem : this.wTree.getItems()) {
            treeItem.dispose();
        }
        String treeName = "Execution Lineage";
        for (int p = lineagePaths.size() - 1; p >= 0; --p) {
            List<PathResult> shortestPath = lineagePaths.get(p);
            TreeItem pathItem = new TreeItem(this.wTree, 0);
            pathItem.setText(0, Integer.toString(p + 1));
            for (int e = 0; e < shortestPath.size(); ++e) {
                PathResult exec = shortestPath.get(e);
                TreeItem execItem = new TreeItem(pathItem, 0);
                int x = 0;
                execItem.setText(x++, Integer.toString(e + 1));
                execItem.setText(x++, Const.NVL((String)exec.getId(), (String)""));
                execItem.setText(x++, Const.NVL((String)exec.getName(), (String)""));
                execItem.setText(x++, Const.NVL((String)exec.getType(), (String)""));
                execItem.setText(x++, exec.getFailed() == null ? "" : exec.getFailed().toString());
                execItem.setText(x++, this.formatDate(exec.getRegistrationDate()));
                execItem.setExpanded(true);
            }
            if (p != lineagePaths.size() - 1) continue;
            TreeMemory.getInstance().storeExpanded(treeName, pathItem, true);
        }
        TreeMemory.setExpandedFromMemory((Tree)this.wTree, (String)treeName);
        if (this.wTree.getItemCount() > 0) {
            TreeItem firstItem = this.wTree.getItem(0);
            this.wTree.setSelection(firstItem);
        }
        TreeUtil.setOptimalWidthOnColumns((Tree)this.wTree);
    }

    private String formatDate(Date registrationDate) {
        if (registrationDate == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(registrationDate);
    }

    private List<List<PathResult>> getLineageToRoot(String executionId) {
        ArrayList<List<PathResult>> shortestPaths = new ArrayList<List<PathResult>>();
        for (TreeItem treeItem : this.wTree.getItems()) {
            treeItem.dispose();
        }
        if (this.viewer.getExecution().getParentId() == null) {
            return Collections.emptyList();
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("executionId", executionId);
        String pathCypher = this.getPathToRootCypher();
        this.getSession().executeRead(tx -> {
            Result pathResult = tx.run(pathCypher, pathParams);
            while (pathResult.hasNext()) {
                Record pathRecord = pathResult.next();
                Value pathValue = pathRecord.get(0);
                Path path = pathValue.asPath();
                ArrayList<PathResult> shortestPath = new ArrayList<PathResult>();
                for (Node node : path.nodes()) {
                    PathResult nodeResult = new PathResult();
                    nodeResult.setId(LoggingCore.getStringValue(node, "id"));
                    nodeResult.setName(LoggingCore.getStringValue(node, "name"));
                    nodeResult.setType(LoggingCore.getStringValue(node, "executionType"));
                    nodeResult.setFailed(LoggingCore.getBooleanValue(node, "failed"));
                    nodeResult.setRegistrationDate(LoggingCore.getDateValue(node, "registrationDate"));
                    nodeResult.setCopy(LoggingCore.getStringValue(node, "copyNr"));
                    shortestPath.add(0, nodeResult);
                }
                shortestPaths.add(shortestPath);
            }
            return null;
        });
        return shortestPaths;
    }
}

