/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws2.sqs.SqsUnboundedReader;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Objects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

class SqsCheckpointMark
implements UnboundedSource.CheckpointMark,
Serializable {
    private transient @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized SqsUnboundedReader> reader;
    private @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> safeToDeleteIds;
    @VisibleForTesting
    final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> notYetReadReceipts;

    SqsCheckpointMark(@UnknownKeyFor @NonNull @Initialized SqsUnboundedReader reader, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> messagesToDelete, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> notYetReadReceipts) {
        this.reader = Optional.of(reader);
        this.safeToDeleteIds = ImmutableList.copyOf(messagesToDelete);
        this.notYetReadReceipts = ImmutableList.copyOf(notYetReadReceipts);
    }

    public void finalizeCheckpoint() throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkState((this.reader.isPresent() && this.safeToDeleteIds != null ? 1 : 0) != 0, (Object)"Cannot finalize a restored checkpoint");
        try {
            this.reader.get().delete(this.safeToDeleteIds);
            int remainingInFlight = this.reader.get().numInFlightCheckpoints.decrementAndGet();
            Preconditions.checkState((remainingInFlight >= 0 ? 1 : 0) != 0, (Object)"Miscounted in-flight checkpoints");
        }
        catch (Throwable throwable) {
            int remainingInFlight = this.reader.get().numInFlightCheckpoints.decrementAndGet();
            Preconditions.checkState((remainingInFlight >= 0 ? 1 : 0) != 0, (Object)"Miscounted in-flight checkpoints");
            this.reader.get().maybeCloseClient();
            this.reader = Optional.empty();
            this.safeToDeleteIds = null;
            throw throwable;
        }
        this.reader.get().maybeCloseClient();
        this.reader = Optional.empty();
        this.safeToDeleteIds = null;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqsCheckpointMark that = (SqsCheckpointMark)o;
        return Objects.equal(this.safeToDeleteIds, that.safeToDeleteIds);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.safeToDeleteIds});
    }
}

