/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.HashSet;
import java.util.Set;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PCollectionViews;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class DirectWriteViewVisitor
extends Pipeline.PipelineVisitor.Defaults {
    static final @UnknownKeyFor @NonNull @Initialized String DIRECT_WRITE_VIEW_URN = "beam:directrunner:transforms:write_view:v1";
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> viewsToWrite;

    DirectWriteViewVisitor() {
    }

    @Override
    public void enterPipeline(@UnknownKeyFor @NonNull @Initialized Pipeline p) {
        this.viewsToWrite = new HashSet();
    }

    @Override
    public void leavePipeline(@UnknownKeyFor @NonNull @Initialized Pipeline p) {
        for (PCollectionView<?> view : this.viewsToWrite) {
            this.visitView(view);
        }
    }

    @Override
    public void visitPrimitiveTransform( @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        if (node.getTransform() instanceof ParDo.MultiOutput) {
            ParDo.MultiOutput parDo = (ParDo.MultiOutput)node.getTransform();
            this.viewsToWrite.addAll(parDo.getSideInputs().values());
        }
    }

    private <ElemT, ViewT> void visitView(@UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> view) {
        PCollection<?> collectionToMaterialize = view.getPCollection();
        collectionToMaterialize.apply("GroupAndWriteView", new GroupAndWriteView(view));
    }

    static final class WriteView<@UnknownKeyFor ElemT, @UnknownKeyFor ViewT>
    extends PTransform<PCollection<Iterable<ElemT>>, PCollection<Iterable<ElemT>>> {
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> view;

        WriteView(@UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> view) {
            this.view = view;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Iterable<ElemT>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Iterable<ElemT>> input) {
            return PCollection.createPrimitiveOutputInternal(input.getPipeline(), input.getWindowingStrategy(), input.isBounded(), input.getCoder());
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> getView() {
            return this.view;
        }
    }

    private static class GroupAndWriteView<@UnknownKeyFor ElemT, @UnknownKeyFor ViewT>
    extends PTransform<PCollection<ElemT>, PCollection<ElemT>> {
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> view;

        private GroupAndWriteView(@UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> view) {
            this.view = view;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<ElemT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<ElemT> input) {
            PCollection iterable = this.view.getViewFn() instanceof PCollectionViews.IsSingletonView ? ((PCollection)((Object)input.apply(MapElements.into(TypeDescriptors.iterables(input.getTypeDescriptor())).via(xva$0 -> Lists.newArrayList((Object[])new Object[]{xva$0}))))).setCoder(IterableCoder.of(input.getCoder())) : (PCollection)((PCollection)((PCollection)input.apply("Key by null", WithKeys.of((Void)null))).setCoder(KvCoder.of(VoidCoder.of(), input.getCoder())).apply("GBK", GroupByKey.create())).apply("Get values", Values.create());
            iterable.apply("WriteView", new WriteView(this.view));
            return input;
        }
    }
}

