/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.request;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.driver.NotificationCategory;
import org.neo4j.driver.NotificationConfig;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.InternalNotificationCategory;
import org.neo4j.driver.internal.InternalNotificationConfig;
import org.neo4j.driver.internal.InternalNotificationSeverity;
import org.neo4j.driver.internal.messaging.Message;

abstract class MessageWithMetadata
implements Message {
    static final String NOTIFICATIONS_MINIMUM_SEVERITY = "notifications_minimum_severity";
    static final String NOTIFICATIONS_DISABLED_CATEGORIES = "notifications_disabled_categories";
    private final Map<String, Value> metadata;

    public MessageWithMetadata(Map<String, Value> metadata) {
        this.metadata = metadata;
    }

    public Map<String, Value> metadata() {
        return this.metadata;
    }

    static void appendNotificationConfig(Map<String, Value> result, NotificationConfig config) {
        if (config != null && config instanceof InternalNotificationConfig) {
            Set<NotificationCategory> disabledCategories;
            InternalNotificationConfig internalConfig = (InternalNotificationConfig)config;
            InternalNotificationSeverity severity = (InternalNotificationSeverity)internalConfig.minimumSeverity();
            if (severity != null) {
                result.put(NOTIFICATIONS_MINIMUM_SEVERITY, Values.value(severity.type().toString()));
            }
            if ((disabledCategories = internalConfig.disabledCategories()) != null) {
                List<String> list = disabledCategories.stream().map(category -> (InternalNotificationCategory)category).map(category -> category.type().toString()).toList();
                result.put(NOTIFICATIONS_DISABLED_CATEGORIES, Values.value(list));
            }
        }
    }
}

