/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableCell;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.storage.v1.AnnotationsProto;
import com.google.cloud.bigquery.storage.v1.BigDecimalByteStringEncoder;
import com.google.cloud.bigquery.storage.v1.BigQuerySchemaUtil;
import com.google.cloud.bigquery.storage.v1.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.CivilTimeEncoder;
import org.apache.beam.sdk.io.gcp.bigquery.Mode;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiCDC;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Functions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.BaseEncoding;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Days;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public class TableRowToStorageApiProto {
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Mode, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Mode> MODE_MAP_JSON_PROTO = ImmutableMap.of((Object)((Object)Mode.NULLABLE), (Object)TableFieldSchema.Mode.NULLABLE, (Object)((Object)Mode.REQUIRED), (Object)TableFieldSchema.Mode.REQUIRED, (Object)((Object)Mode.REPEATED), (Object)TableFieldSchema.Mode.REPEATED);
    private static final @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Mode, @UnknownKeyFor @NonNull @Initialized String> MODE_MAP_PROTO_JSON = ImmutableMap.of((Object)TableFieldSchema.Mode.NULLABLE, (Object)"NULLABLE", (Object)TableFieldSchema.Mode.REQUIRED, (Object)"REQUIRED", (Object)TableFieldSchema.Mode.REPEATED, (Object)"REPEATED");
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Type> TYPE_MAP_JSON_PROTO = ImmutableMap.builder().put((Object)"STRUCT", (Object)TableFieldSchema.Type.STRUCT).put((Object)"RECORD", (Object)TableFieldSchema.Type.STRUCT).put((Object)"INT64", (Object)TableFieldSchema.Type.INT64).put((Object)"INTEGER", (Object)TableFieldSchema.Type.INT64).put((Object)"FLOAT64", (Object)TableFieldSchema.Type.DOUBLE).put((Object)"FLOAT", (Object)TableFieldSchema.Type.DOUBLE).put((Object)"STRING", (Object)TableFieldSchema.Type.STRING).put((Object)"BOOL", (Object)TableFieldSchema.Type.BOOL).put((Object)"BOOLEAN", (Object)TableFieldSchema.Type.BOOL).put((Object)"BYTES", (Object)TableFieldSchema.Type.BYTES).put((Object)"NUMERIC", (Object)TableFieldSchema.Type.NUMERIC).put((Object)"BIGNUMERIC", (Object)TableFieldSchema.Type.BIGNUMERIC).put((Object)"GEOGRAPHY", (Object)TableFieldSchema.Type.GEOGRAPHY).put((Object)"DATE", (Object)TableFieldSchema.Type.DATE).put((Object)"TIME", (Object)TableFieldSchema.Type.TIME).put((Object)"DATETIME", (Object)TableFieldSchema.Type.DATETIME).put((Object)"TIMESTAMP", (Object)TableFieldSchema.Type.TIMESTAMP).put((Object)"JSON", (Object)TableFieldSchema.Type.JSON).build();
    private static final @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Type, @UnknownKeyFor @NonNull @Initialized String> TYPE_MAP_PROTO_JSON = ImmutableMap.builder().put((Object)TableFieldSchema.Type.STRUCT, (Object)"STRUCT").put((Object)TableFieldSchema.Type.INT64, (Object)"INT64").put((Object)TableFieldSchema.Type.DOUBLE, (Object)"FLOAT64").put((Object)TableFieldSchema.Type.STRING, (Object)"STRING").put((Object)TableFieldSchema.Type.BOOL, (Object)"BOOL").put((Object)TableFieldSchema.Type.BYTES, (Object)"BYTES").put((Object)TableFieldSchema.Type.NUMERIC, (Object)"NUMERIC").put((Object)TableFieldSchema.Type.BIGNUMERIC, (Object)"BIGNUMERIC").put((Object)TableFieldSchema.Type.GEOGRAPHY, (Object)"GEOGRAPHY").put((Object)TableFieldSchema.Type.DATE, (Object)"DATE").put((Object)TableFieldSchema.Type.TIME, (Object)"TIME").put((Object)TableFieldSchema.Type.DATETIME, (Object)"DATETIME").put((Object)TableFieldSchema.Type.TIMESTAMP, (Object)"TIMESTAMP").put((Object)TableFieldSchema.Type.JSON, (Object)"JSON").build();
    static final @UnknownKeyFor @NonNull @Initialized DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.0###############", DecimalFormatSymbols.getInstance(Locale.ROOT));
    static final @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Type, @UnknownKeyFor @NonNull @Initialized ThrowingBiFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object, @Nullable @UnknownKeyFor @Initialized Object>> TYPE_MAP_PROTO_CONVERTERS = ImmutableMap.builder().put((Object)TableFieldSchema.Type.INT64, (fullName, value) -> {
        if (value instanceof String) {
            try {
                return Long.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new SingleValueConversionException(value, TableFieldSchema.Type.INT64, (String)fullName, e);
            }
        }
        if (value instanceof Integer || value instanceof Long) {
            return ((Number)value).longValue();
        }
        if (value instanceof BigDecimal) {
            try {
                return ((BigDecimal)value).longValueExact();
            }
            catch (ArithmeticException e) {
                throw new SingleValueConversionException(value, TableFieldSchema.Type.INT64, (String)fullName, e);
            }
        }
        if (value instanceof BigInteger) {
            try {
                return ((BigInteger)value).longValueExact();
            }
            catch (ArithmeticException e) {
                throw new SingleValueConversionException(value, TableFieldSchema.Type.INT64, (String)fullName, e);
            }
        }
        return null;
    }).put((Object)TableFieldSchema.Type.DOUBLE, (schemaInformation, value) -> {
        if (value instanceof String) {
            return Double.valueOf((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return null;
    }).put((Object)TableFieldSchema.Type.BOOL, (schemaInformation, value) -> {
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        if (value instanceof Boolean) {
            return value;
        }
        return null;
    }).put((Object)TableFieldSchema.Type.BYTES, (schemaInformation, value) -> {
        if (value instanceof String) {
            return ByteString.copyFrom((byte[])BaseEncoding.base64().decode((CharSequence)((String)value)));
        }
        if (value instanceof byte[]) {
            return ByteString.copyFrom((byte[])((byte[])value));
        }
        if (value instanceof ByteString) {
            return value;
        }
        return null;
    }).put((Object)TableFieldSchema.Type.TIMESTAMP, (schemaInformation, value) -> {
        if (value instanceof String) {
            try {
                Instant timestamp = Instant.from(BigQueryUtils.TIMESTAMP_FORMATTER.parse((String)value));
                return TableRowToStorageApiProto.toEpochMicros(timestamp);
            }
            catch (DateTimeException e) {
                try {
                    Instant timestamp = Instant.from(BigQueryUtils.TIMESTAMP_FORMATTER.withZone(ZoneOffset.UTC).parse((String)value));
                    return TableRowToStorageApiProto.toEpochMicros(timestamp);
                }
                catch (DateTimeParseException err) {
                    Instant timestamp = Instant.ofEpochMilli(Long.parseLong((String)value));
                    return TableRowToStorageApiProto.toEpochMicros(timestamp);
                }
            }
        }
        if (value instanceof Instant) {
            return TableRowToStorageApiProto.toEpochMicros((Instant)value);
        }
        if (value instanceof org.joda.time.Instant) {
            return ((org.joda.time.Instant)value).getMillis() * 1000L;
        }
        if (value instanceof Integer || value instanceof Long) {
            return ((Number)value).longValue();
        }
        if (value instanceof Double || value instanceof Float) {
            return BigDecimal.valueOf(((Number)value).doubleValue()).scaleByPowerOfTen(6).setScale(0, RoundingMode.HALF_UP).longValue();
        }
        return null;
    }).put((Object)TableFieldSchema.Type.DATE, (schemaInformation, value) -> {
        if (value instanceof String) {
            return Long.valueOf(LocalDate.parse((String)value).toEpochDay()).intValue();
        }
        if (value instanceof LocalDate) {
            return Long.valueOf(((LocalDate)value).toEpochDay()).intValue();
        }
        if (value instanceof org.joda.time.LocalDate) {
            return Days.daysBetween((ReadablePartial)org.joda.time.Instant.EPOCH.toDateTime().toLocalDate(), (ReadablePartial)((org.joda.time.LocalDate)value)).getDays();
        }
        if (value instanceof Integer || value instanceof Long) {
            return ((Number)value).intValue();
        }
        return null;
    }).put((Object)TableFieldSchema.Type.NUMERIC, (schemaInformation, value) -> {
        if (value instanceof String) {
            return BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal((String)value));
        }
        if (value instanceof BigDecimal) {
            return BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)((BigDecimal)value));
        }
        if (value instanceof Double || value instanceof Float) {
            return BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)BigDecimal.valueOf(((Number)value).doubleValue()));
        }
        if (value instanceof Short || value instanceof Integer || value instanceof Long) {
            return BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)BigDecimal.valueOf(((Number)value).longValue()));
        }
        return null;
    }).put((Object)TableFieldSchema.Type.BIGNUMERIC, (schemaInformation, value) -> {
        if (value instanceof String) {
            return BigDecimalByteStringEncoder.encodeToBigNumericByteString((BigDecimal)new BigDecimal((String)value));
        }
        if (value instanceof BigDecimal) {
            return BigDecimalByteStringEncoder.encodeToBigNumericByteString((BigDecimal)((BigDecimal)value));
        }
        if (value instanceof Double || value instanceof Float) {
            return BigDecimalByteStringEncoder.encodeToBigNumericByteString((BigDecimal)BigDecimal.valueOf(((Number)value).doubleValue()));
        }
        if (value instanceof Short || value instanceof Integer || value instanceof Long) {
            return BigDecimalByteStringEncoder.encodeToBigNumericByteString((BigDecimal)BigDecimal.valueOf(((Number)value).longValue()));
        }
        return null;
    }).put((Object)TableFieldSchema.Type.DATETIME, (schemaInformation, value) -> {
        if (value instanceof String) {
            try {
                return CivilTimeEncoder.encodePacked64DatetimeMicros(java.time.LocalDateTime.parse((String)value));
            }
            catch (DateTimeParseException e2) {
                return CivilTimeEncoder.encodePacked64DatetimeMicros(java.time.LocalDateTime.parse((String)value, BigQueryUtils.DATETIME_SPACE_FORMATTER));
            }
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof java.time.LocalDateTime) {
            return CivilTimeEncoder.encodePacked64DatetimeMicros((java.time.LocalDateTime)value);
        }
        if (value instanceof LocalDateTime) {
            return CivilTimeEncoder.encodePacked64DatetimeMicros((LocalDateTime)value);
        }
        return null;
    }).put((Object)TableFieldSchema.Type.TIME, (schemaInformation, value) -> {
        if (value instanceof String) {
            return CivilTimeEncoder.encodePacked64TimeMicros(java.time.LocalTime.parse((String)value));
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof java.time.LocalTime) {
            return CivilTimeEncoder.encodePacked64TimeMicros((java.time.LocalTime)value);
        }
        if (value instanceof LocalTime) {
            return CivilTimeEncoder.encodePacked64TimeMicros((LocalTime)value);
        }
        return null;
    }).put((Object)TableFieldSchema.Type.STRING, (schemaInformation, value) -> Preconditions.checkArgumentNotNull((Object)value).toString()).put((Object)TableFieldSchema.Type.JSON, (schemaInformation, value) -> Preconditions.checkArgumentNotNull((Object)value).toString()).put((Object)TableFieldSchema.Type.GEOGRAPHY, (schemaInformation, value) -> Preconditions.checkArgumentNotNull((Object)value).toString()).build();
    static final @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Type, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DescriptorProtos.FieldDescriptorProto.Type> PRIMITIVE_TYPES_BQ_TO_PROTO = ImmutableMap.builder().put((Object)TableFieldSchema.Type.INT64, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)TableFieldSchema.Type.DOUBLE, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE).put((Object)TableFieldSchema.Type.STRING, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)TableFieldSchema.Type.BOOL, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL).put((Object)TableFieldSchema.Type.BYTES, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).put((Object)TableFieldSchema.Type.NUMERIC, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).put((Object)TableFieldSchema.Type.BIGNUMERIC, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).put((Object)TableFieldSchema.Type.GEOGRAPHY, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)TableFieldSchema.Type.DATE, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32).put((Object)TableFieldSchema.Type.TIME, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)TableFieldSchema.Type.DATETIME, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)TableFieldSchema.Type.TIMESTAMP, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)TableFieldSchema.Type.JSON, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).build();
    static final @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor.Type, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Type> PRIMITIVE_TYPES_PROTO_TO_BQ = ImmutableMap.builder().put((Object)Descriptors.FieldDescriptor.Type.INT32, (Object)TableFieldSchema.Type.INT64).put((Object)Descriptors.FieldDescriptor.Type.FIXED32, (Object)TableFieldSchema.Type.INT64).put((Object)Descriptors.FieldDescriptor.Type.UINT32, (Object)TableFieldSchema.Type.INT64).put((Object)Descriptors.FieldDescriptor.Type.SFIXED32, (Object)TableFieldSchema.Type.INT64).put((Object)Descriptors.FieldDescriptor.Type.SINT32, (Object)TableFieldSchema.Type.INT64).put((Object)Descriptors.FieldDescriptor.Type.INT64, (Object)TableFieldSchema.Type.INT64).put((Object)Descriptors.FieldDescriptor.Type.FIXED64, (Object)TableFieldSchema.Type.NUMERIC).put((Object)Descriptors.FieldDescriptor.Type.UINT64, (Object)TableFieldSchema.Type.NUMERIC).put((Object)Descriptors.FieldDescriptor.Type.SFIXED64, (Object)TableFieldSchema.Type.INT64).put((Object)Descriptors.FieldDescriptor.Type.SINT64, (Object)TableFieldSchema.Type.INT64).put((Object)Descriptors.FieldDescriptor.Type.DOUBLE, (Object)TableFieldSchema.Type.DOUBLE).put((Object)Descriptors.FieldDescriptor.Type.FLOAT, (Object)TableFieldSchema.Type.DOUBLE).put((Object)Descriptors.FieldDescriptor.Type.STRING, (Object)TableFieldSchema.Type.STRING).put((Object)Descriptors.FieldDescriptor.Type.BOOL, (Object)TableFieldSchema.Type.BOOL).put((Object)Descriptors.FieldDescriptor.Type.BYTES, (Object)TableFieldSchema.Type.BYTES).build();
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> FLOAT_VALUE_DESCRIPTOR_NAMES = ImmutableSet.of((Object)"google_protobuf_FloatValue", (Object)"FloatValue");
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> DOUBLE_VALUE_DESCRIPTOR_NAMES = ImmutableSet.of((Object)"google_protobuf_DoubleValue", (Object)"DoubleValue");
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> BOOL_VALUE_DESCRIPTOR_NAMES = ImmutableSet.of((Object)"google_protobuf_BoolValue", (Object)"BoolValue");
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> INT32_VALUE_DESCRIPTOR_NAMES = ImmutableSet.of((Object)"google_protobuf_Int32Value", (Object)"Int32Value");
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> INT64_VALUE_DESCRIPTOR_NAMES = ImmutableSet.of((Object)"google_protobuf_Int64Value", (Object)"Int64Value");
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> UINT32_VALUE_DESCRIPTOR_NAMES = ImmutableSet.of((Object)"google_protobuf_UInt32Value", (Object)"UInt32Value");
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> UINT64_VALUE_DESCRIPTOR_NAMES = ImmutableSet.of((Object)"google_protobuf_UInt64Value", (Object)"UInt64Value");
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> BYTES_VALUE_DESCRIPTOR_NAMES = ImmutableSet.of((Object)"google_protobuf_BytesValue", (Object)"BytesValue");
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> TIMESTAMP_VALUE_DESCRIPTOR_NAMES = ImmutableSet.of((Object)"google_protobuf_Timestamp", (Object)"Timestamp");

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Mode modeToProtoMode(@Nullable @UnknownKeyFor @Initialized String defaultValueExpression, @UnknownKeyFor @NonNull @Initialized String mode) {
        TableFieldSchema.Mode resultMode = Optional.ofNullable(mode).map(Mode::valueOf).map(MODE_MAP_JSON_PROTO::get).orElse(TableFieldSchema.Mode.NULLABLE);
        if (defaultValueExpression == null) {
            return resultMode;
        }
        return resultMode.equals((Object)TableFieldSchema.Mode.REPEATED) ? resultMode : TableFieldSchema.Mode.NULLABLE;
    }

    public static @UnknownKeyFor @NonNull @Initialized String protoModeToJsonMode(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Mode protoMode) {
        String jsonMode = MODE_MAP_PROTO_JSON.get(protoMode);
        if (jsonMode == null) {
            throw new RuntimeException("Unknown mode " + protoMode);
        }
        return jsonMode;
    }

    public static @UnknownKeyFor @NonNull @Initialized String protoTypeToJsonType(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Type protoType) {
        String type = TYPE_MAP_PROTO_JSON.get(protoType);
        if (type == null) {
            throw new RuntimeException("Unknown type " + protoType);
        }
        return type;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Type typeToProtoType(@UnknownKeyFor @NonNull @Initialized String type) {
        TableFieldSchema.Type protoType = TYPE_MAP_JSON_PROTO.get(type);
        if (protoType == null) {
            throw new RuntimeException("Unknown type " + type);
        }
        return protoType;
    }

    public static @UnknownKeyFor @NonNull @Initialized TableSchema protoSchemaToTableSchema(@UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema protoTableSchema) {
        TableSchema tableSchema = new TableSchema();
        ArrayList tableFields = Lists.newArrayListWithExpectedSize((int)protoTableSchema.getFieldsCount());
        for (com.google.cloud.bigquery.storage.v1.TableFieldSchema protoTableField : protoTableSchema.getFieldsList()) {
            tableFields.add(TableRowToStorageApiProto.protoTableFieldToTableField(protoTableField));
        }
        return tableSchema.setFields((List)tableFields);
    }

    public static @UnknownKeyFor @NonNull @Initialized TableFieldSchema protoTableFieldToTableField(@UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableFieldSchema protoTableField) {
        TableFieldSchema tableField = new TableFieldSchema();
        if (!Strings.isNullOrEmpty((String)(tableField = tableField.setName(protoTableField.getName())).getDescription())) {
            tableField = tableField.setDescription(protoTableField.getDescription());
        }
        if (protoTableField.getMaxLength() != 0L) {
            tableField = tableField.setMaxLength(Long.valueOf(protoTableField.getMaxLength()));
        }
        if (protoTableField.getMode() != TableFieldSchema.Mode.MODE_UNSPECIFIED) {
            tableField = tableField.setMode(TableRowToStorageApiProto.protoModeToJsonMode(protoTableField.getMode()));
        }
        if (protoTableField.getPrecision() != 0L) {
            tableField = tableField.setPrecision(Long.valueOf(protoTableField.getPrecision()));
        }
        if (protoTableField.getScale() != 0L) {
            tableField = tableField.setScale(Long.valueOf(protoTableField.getScale()));
        }
        tableField = tableField.setType(TableRowToStorageApiProto.protoTypeToJsonType(protoTableField.getType()));
        if (protoTableField.getType().equals((Object)TableFieldSchema.Type.STRUCT)) {
            ArrayList subFields = Lists.newArrayListWithExpectedSize((int)protoTableField.getFieldsCount());
            for (com.google.cloud.bigquery.storage.v1.TableFieldSchema subField : protoTableField.getFieldsList()) {
                subFields.add(TableRowToStorageApiProto.protoTableFieldToTableField(subField));
            }
            tableField = tableField.setFields((List)subFields);
        }
        return tableField;
    }

    public static @UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema schemaToProtoTableSchema(@UnknownKeyFor @NonNull @Initialized TableSchema tableSchema) {
        TableSchema.Builder builder = com.google.cloud.bigquery.storage.v1.TableSchema.newBuilder();
        if (tableSchema.getFields() != null) {
            for (TableFieldSchema field : tableSchema.getFields()) {
                builder.addFields(TableRowToStorageApiProto.tableFieldToProtoTableField(field));
            }
        }
        return builder.build();
    }

    public static @UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableFieldSchema tableFieldToProtoTableField(@UnknownKeyFor @NonNull @Initialized TableFieldSchema field) {
        TableFieldSchema.Builder builder = com.google.cloud.bigquery.storage.v1.TableFieldSchema.newBuilder();
        builder.setName(field.getName().toLowerCase());
        if (field.getDescription() != null) {
            builder.setDescription(field.getDescription());
        }
        if (field.getMaxLength() != null) {
            builder.setMaxLength(field.getMaxLength().longValue());
        }
        builder.setMode(TableRowToStorageApiProto.modeToProtoMode(field.getDefaultValueExpression(), field.getMode()));
        if (field.getPrecision() != null) {
            builder.setPrecision(field.getPrecision().longValue());
        }
        if (field.getScale() != null) {
            builder.setScale(field.getScale().longValue());
        }
        builder.setType(TableRowToStorageApiProto.typeToProtoType(field.getType()));
        if (builder.getType().equals((Object)TableFieldSchema.Type.STRUCT)) {
            for (TableFieldSchema subField : field.getFields()) {
                builder.addFields(TableRowToStorageApiProto.tableFieldToProtoTableField(subField));
            }
        }
        return builder.build();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor getDescriptorFromTableSchema(@UnknownKeyFor @NonNull @Initialized TableSchema jsonSchema, @UnknownKeyFor @NonNull @Initialized boolean respectRequired, @UnknownKeyFor @NonNull @Initialized boolean includeCdcColumns) throws // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.DescriptorValidationException {
        return TableRowToStorageApiProto.getDescriptorFromTableSchema(TableRowToStorageApiProto.schemaToProtoTableSchema(jsonSchema), respectRequired, includeCdcColumns);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor getDescriptorFromTableSchema(@UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema tableSchema, @UnknownKeyFor @NonNull @Initialized boolean respectRequired, @UnknownKeyFor @NonNull @Initialized boolean includeCdcColumns) throws // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.DescriptorValidationException {
        return TableRowToStorageApiProto.wrapDescriptorProto(TableRowToStorageApiProto.descriptorSchemaFromTableSchema(tableSchema, respectRequired, includeCdcColumns));
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor wrapDescriptorProto(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DescriptorProtos.DescriptorProto descriptorProto) throws // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.DescriptorValidationException {
        DescriptorProtos.FileDescriptorProto fileDescriptorProto = DescriptorProtos.FileDescriptorProto.newBuilder().addMessageType(descriptorProto).build();
        Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescriptorProto, (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]);
        return (Descriptors.Descriptor)Iterables.getOnlyElement((Iterable)fileDescriptor.getMessageTypes());
    }

    public static @UnknownKeyFor @NonNull @Initialized DynamicMessage messageFromMap(@UnknownKeyFor @NonNull @Initialized SchemaInformation schemaInformation, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor, @UnknownKeyFor @NonNull @Initialized AbstractMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> map, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues, @UnknownKeyFor @NonNull @Initialized boolean allowMissingRequiredFields, @Nullable @UnknownKeyFor @Initialized TableRow unknownFields, @Nullable @UnknownKeyFor @Initialized String changeType, @Nullable @UnknownKeyFor @Initialized String changeSequenceNum) throws @UnknownKeyFor @NonNull @Initialized SchemaConversionException {
        DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey().toLowerCase();
            String protoFieldName = BigQuerySchemaUtil.isProtoCompatible((String)key) ? key : BigQuerySchemaUtil.generatePlaceholderFieldName((String)key);
            // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName(protoFieldName);
            if (fieldDescriptor == null) {
                if (unknownFields != null) {
                    unknownFields.set(key, entry.getValue());
                }
                if (ignoreUnknownValues) continue;
                throw new SchemaTooNarrowException("TableRow contained unexpected field with name " + entry.getKey() + " not found in schema for " + schemaInformation.getFullName());
            }
            SchemaInformation fieldSchemaInformation = schemaInformation.getSchemaForField(entry.getKey());
            try {
                Supplier<@Nullable TableRow> getNestedUnknown = () -> {
                    if (unknownFields == null) {
                        return null;
                    }
                    TableRow nestedUnknown = new TableRow();
                    if (fieldDescriptor.isRepeated()) {
                        ((List)unknownFields.computeIfAbsent((Object)key, k -> new ArrayList())).add(nestedUnknown);
                        return nestedUnknown;
                    }
                    return (TableRow)unknownFields.computeIfAbsent((Object)key, k -> nestedUnknown);
                };
                @Nullable Object value = TableRowToStorageApiProto.messageValueFromFieldValue(fieldSchemaInformation, fieldDescriptor, entry.getValue(), ignoreUnknownValues, allowMissingRequiredFields, getNestedUnknown);
                if (value != null) {
                    builder.setField(fieldDescriptor, value);
                }
                if (!fieldSchemaInformation.getType().equals((Object)TableFieldSchema.Type.STRUCT) || unknownFields == null || (!(unknownFields.get((Object)key) instanceof Map) || !((Map)unknownFields.get((Object)key)).isEmpty()) && (!(unknownFields.get((Object)key) instanceof List) || !((List)unknownFields.get((Object)key)).isEmpty() && !((List)unknownFields.get((Object)key)).stream().allMatch(row -> row == null || ((Map)row).isEmpty()))) continue;
                unknownFields.remove((Object)key);
            }
            catch (Exception e) {
                throw new SchemaDoesntMatchException("Problem converting field " + fieldSchemaInformation.getFullName() + " expected type: " + fieldSchemaInformation.getType(), e);
            }
        }
        if (changeType != null) {
            builder.setField((Descriptors.FieldDescriptor)Preconditions.checkStateNotNull((Object)descriptor.findFieldByName("_CHANGE_TYPE")), (Object)changeType);
            builder.setField((Descriptors.FieldDescriptor)Preconditions.checkStateNotNull((Object)descriptor.findFieldByName("_CHANGE_SEQUENCE_NUMBER")), Preconditions.checkStateNotNull((Object)changeSequenceNum));
        }
        try {
            return builder.build();
        }
        catch (Exception e) {
            throw new SchemaDoesntMatchException("Couldn't convert schema for " + schemaInformation.getFullName(), e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized DynamicMessage messageFromTableRow(@UnknownKeyFor @NonNull @Initialized SchemaInformation schemaInformation, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor, @UnknownKeyFor @NonNull @Initialized TableRow tableRow, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues, @UnknownKeyFor @NonNull @Initialized boolean allowMissingRequiredFields, @Nullable @UnknownKeyFor @Initialized TableRow unknownFields, @Nullable @UnknownKeyFor @Initialized String changeType, @UnknownKeyFor @NonNull @Initialized long changeSequenceNum) throws @UnknownKeyFor @NonNull @Initialized SchemaConversionException {
        return TableRowToStorageApiProto.messageFromTableRow(schemaInformation, descriptor, tableRow, ignoreUnknownValues, allowMissingRequiredFields, unknownFields, changeType, Long.toHexString(changeSequenceNum));
    }

    public static @UnknownKeyFor @NonNull @Initialized DynamicMessage messageFromTableRow(@UnknownKeyFor @NonNull @Initialized SchemaInformation schemaInformation, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor, @UnknownKeyFor @NonNull @Initialized TableRow tableRow, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues, @UnknownKeyFor @NonNull @Initialized boolean allowMissingRequiredFields, @Nullable @UnknownKeyFor @Initialized TableRow unknownFields, @Nullable @UnknownKeyFor @Initialized String changeType, @Nullable @UnknownKeyFor @Initialized String changeSequenceNum) throws @UnknownKeyFor @NonNull @Initialized SchemaConversionException {
        @Nullable Object fValue = tableRow.get((Object)"f");
        if (fValue instanceof List) {
            int i;
            List cells = (List)fValue;
            DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
            int cellsToProcess = cells.size();
            if (cells.size() > descriptor.getFields().size()) {
                if (ignoreUnknownValues) {
                    cellsToProcess = descriptor.getFields().size();
                } else {
                    throw new SchemaTooNarrowException("TableRow contained too many fields and ignoreUnknownValues not set in " + schemaInformation.getName());
                }
            }
            if (unknownFields != null) {
                ArrayList unknownValues = Lists.newArrayListWithExpectedSize((int)cells.size());
                for (int i2 = 0; i2 < cells.size(); ++i2) {
                    unknownValues.add(new TableCell().setV(null));
                }
                unknownFields.setF((List)unknownValues);
            }
            for (i = 0; i < cellsToProcess; ++i) {
                AbstractMap cell = (AbstractMap)cells.get(i);
                Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)descriptor.getFields().get(i);
                SchemaInformation fieldSchemaInformation = schemaInformation.getSchemaForField(i);
                try {
                    int finalIndex = i;
                    Supplier<@Nullable TableRow> getNestedUnknown = () -> {
                        if (unknownFields == null) {
                            return null;
                        }
                        TableRow localUnknownFields = (TableRow)Preconditions.checkStateNotNull((Object)unknownFields);
                        @Nullable TableRow nested = (TableRow)((TableCell)localUnknownFields.getF().get(finalIndex)).getV();
                        if (nested == null) {
                            nested = new TableRow();
                            localUnknownFields.getF().set(finalIndex, new TableCell().setV((Object)nested));
                        }
                        return nested;
                    };
                    @Nullable Object value = TableRowToStorageApiProto.messageValueFromFieldValue(fieldSchemaInformation, fieldDescriptor, cell.get("v"), ignoreUnknownValues, allowMissingRequiredFields, getNestedUnknown);
                    if (value == null) continue;
                    builder.setField(fieldDescriptor, value);
                    continue;
                }
                catch (Exception e) {
                    throw new SchemaDoesntMatchException("Problem converting field " + fieldSchemaInformation.getFullName() + " expected type: " + fieldSchemaInformation.getType(), e);
                }
            }
            if (changeType != null) {
                builder.setField((Descriptors.FieldDescriptor)Preconditions.checkStateNotNull((Object)descriptor.findFieldByName("_CHANGE_TYPE")), (Object)changeType);
                builder.setField((Descriptors.FieldDescriptor)Preconditions.checkStateNotNull((Object)descriptor.findFieldByName("_CHANGE_SEQUENCE_NUMBER")), Preconditions.checkStateNotNull((Object)changeSequenceNum));
            }
            if (unknownFields != null) {
                for (i = cellsToProcess; i < cells.size(); ++i) {
                    unknownFields.getF().set(i, new TableCell().setV(((AbstractMap)cells.get(i)).get("v")));
                }
            }
            try {
                return builder.build();
            }
            catch (Exception e) {
                throw new SchemaDoesntMatchException("Could convert schema for " + schemaInformation.getFullName(), e);
            }
        }
        return TableRowToStorageApiProto.messageFromMap(schemaInformation, descriptor, (AbstractMap<String, Object>)tableRow, ignoreUnknownValues, allowMissingRequiredFields, unknownFields, changeType, changeSequenceNum);
    }

    static @UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema tableSchemaFromDescriptor(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor) {
        List tableFields = descriptor.getFields().stream().map(f -> TableRowToStorageApiProto.tableFieldSchemaFromDescriptorField(f)).collect(Collectors.toList());
        return com.google.cloud.bigquery.storage.v1.TableSchema.newBuilder().addAllFields(tableFields).build();
    }

    private static @UnknownKeyFor @NonNull @Initialized String fieldNameFromProtoFieldDescriptor(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.getOptions().hasExtension(AnnotationsProto.columnName)) {
            return (String)fieldDescriptor.getOptions().getExtension(AnnotationsProto.columnName);
        }
        return fieldDescriptor.getName();
    }

    static @UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableFieldSchema tableFieldSchemaFromDescriptorField(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor) {
        TableFieldSchema.Builder tableFieldSchemaBuilder = com.google.cloud.bigquery.storage.v1.TableFieldSchema.newBuilder();
        tableFieldSchemaBuilder = tableFieldSchemaBuilder.setName(TableRowToStorageApiProto.fieldNameFromProtoFieldDescriptor(fieldDescriptor));
        switch (fieldDescriptor.getType()) {
            case MESSAGE: {
                tableFieldSchemaBuilder = tableFieldSchemaBuilder.setType(TableFieldSchema.Type.STRUCT);
                com.google.cloud.bigquery.storage.v1.TableSchema nestedTableField = TableRowToStorageApiProto.tableSchemaFromDescriptor(fieldDescriptor.getMessageType());
                tableFieldSchemaBuilder = tableFieldSchemaBuilder.addAllFields((Iterable)nestedTableField.getFieldsList());
                break;
            }
            default: {
                TableFieldSchema.Type type = PRIMITIVE_TYPES_PROTO_TO_BQ.get(fieldDescriptor.getType());
                if (type == null) {
                    throw new UnsupportedOperationException("proto type " + fieldDescriptor.getType() + " is unsupported.");
                }
                tableFieldSchemaBuilder = tableFieldSchemaBuilder.setType(type);
            }
        }
        tableFieldSchemaBuilder = fieldDescriptor.isRepeated() ? tableFieldSchemaBuilder.setMode(TableFieldSchema.Mode.REPEATED) : (fieldDescriptor.isRequired() ? tableFieldSchemaBuilder.setMode(TableFieldSchema.Mode.REQUIRED) : tableFieldSchemaBuilder.setMode(TableFieldSchema.Mode.NULLABLE));
        return tableFieldSchemaBuilder.build();
    }

    @VisibleForTesting
    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DescriptorProtos.DescriptorProto descriptorSchemaFromTableSchema(@UnknownKeyFor @NonNull @Initialized TableSchema tableSchema, @UnknownKeyFor @NonNull @Initialized boolean respectRequired, @UnknownKeyFor @NonNull @Initialized boolean includeCdcColumns) {
        return TableRowToStorageApiProto.descriptorSchemaFromTableSchema(TableRowToStorageApiProto.schemaToProtoTableSchema(tableSchema), respectRequired, includeCdcColumns);
    }

    @VisibleForTesting
    static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DescriptorProtos.DescriptorProto descriptorSchemaFromTableSchema(@UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema tableSchema, @UnknownKeyFor @NonNull @Initialized boolean respectRequired, @UnknownKeyFor @NonNull @Initialized boolean includeCdcColumns) {
        return TableRowToStorageApiProto.descriptorSchemaFromTableFieldSchemas(tableSchema.getFieldsList(), respectRequired, includeCdcColumns);
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DescriptorProtos.DescriptorProto descriptorSchemaFromTableFieldSchemas(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableFieldSchema> tableFieldSchemas, @UnknownKeyFor @NonNull @Initialized boolean respectRequired, @UnknownKeyFor @NonNull @Initialized boolean includeCdcColumns) {
        DescriptorProtos.DescriptorProto.Builder descriptorBuilder = DescriptorProtos.DescriptorProto.newBuilder();
        descriptorBuilder.setName("D" + UUID.randomUUID().toString().replace("-", "_"));
        int i = 1;
        for (com.google.cloud.bigquery.storage.v1.TableFieldSchema fieldSchema : tableFieldSchemas) {
            TableRowToStorageApiProto.fieldDescriptorFromTableField(fieldSchema, i++, descriptorBuilder, respectRequired);
        }
        if (includeCdcColumns) {
            DescriptorProtos.FieldDescriptorProto.Builder fieldDescriptorBuilder = DescriptorProtos.FieldDescriptorProto.newBuilder();
            fieldDescriptorBuilder = fieldDescriptorBuilder.setName("_CHANGE_TYPE");
            fieldDescriptorBuilder = fieldDescriptorBuilder.setNumber(i++);
            fieldDescriptorBuilder = fieldDescriptorBuilder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING);
            fieldDescriptorBuilder = fieldDescriptorBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL);
            descriptorBuilder.addField(fieldDescriptorBuilder.build());
            fieldDescriptorBuilder = DescriptorProtos.FieldDescriptorProto.newBuilder();
            fieldDescriptorBuilder = fieldDescriptorBuilder.setName("_CHANGE_SEQUENCE_NUMBER");
            fieldDescriptorBuilder = fieldDescriptorBuilder.setNumber(i++);
            fieldDescriptorBuilder = fieldDescriptorBuilder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING);
            fieldDescriptorBuilder = fieldDescriptorBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL);
            descriptorBuilder.addField(fieldDescriptorBuilder.build());
        }
        return descriptorBuilder.build();
    }

    private static void fieldDescriptorFromTableField(@UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableFieldSchema fieldSchema, @UnknownKeyFor @NonNull @Initialized int fieldNumber, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DescriptorProtos.DescriptorProto.Builder descriptorBuilder, @UnknownKeyFor @NonNull @Initialized boolean respectRequired) {
        if (StorageApiCDC.COLUMNS.contains(fieldSchema.getName())) {
            throw new RuntimeException("Reserved field name " + fieldSchema.getName() + " in user schema.");
        }
        DescriptorProtos.FieldDescriptorProto.Builder fieldDescriptorBuilder = DescriptorProtos.FieldDescriptorProto.newBuilder();
        String fieldName = fieldSchema.getName().toLowerCase();
        fieldDescriptorBuilder = fieldDescriptorBuilder.setName(fieldName);
        fieldDescriptorBuilder = fieldDescriptorBuilder.setNumber(fieldNumber);
        if (!BigQuerySchemaUtil.isProtoCompatible((String)fieldName)) {
            fieldDescriptorBuilder = fieldDescriptorBuilder.setName(BigQuerySchemaUtil.generatePlaceholderFieldName((String)fieldName));
            DescriptorProtos.FieldOptions.Builder fieldOptionBuilder = DescriptorProtos.FieldOptions.newBuilder();
            fieldOptionBuilder = fieldOptionBuilder.setField(AnnotationsProto.columnName.getDescriptor(), (Object)fieldName);
            fieldDescriptorBuilder = fieldDescriptorBuilder.setOptions((DescriptorProtos.FieldOptions)fieldOptionBuilder.build());
        }
        switch (fieldSchema.getType()) {
            case STRUCT: {
                DescriptorProtos.DescriptorProto nested = TableRowToStorageApiProto.descriptorSchemaFromTableFieldSchemas(fieldSchema.getFieldsList(), respectRequired, false);
                descriptorBuilder.addNestedType(nested);
                fieldDescriptorBuilder = fieldDescriptorBuilder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE).setTypeName(nested.getName());
                break;
            }
            default: {
                // Could not load outer class - annotation placement on inner may be incorrect
                 @Nullable DescriptorProtos.FieldDescriptorProto.Type type = PRIMITIVE_TYPES_BQ_TO_PROTO.get(fieldSchema.getType());
                if (type == null) {
                    throw new UnsupportedOperationException("Converting BigQuery type " + fieldSchema.getType() + " to Beam type is unsupported");
                }
                fieldDescriptorBuilder = fieldDescriptorBuilder.setType(type);
            }
        }
        fieldDescriptorBuilder = fieldSchema.getMode() == TableFieldSchema.Mode.REPEATED ? fieldDescriptorBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED) : (!respectRequired || fieldSchema.getMode() != TableFieldSchema.Mode.REQUIRED ? fieldDescriptorBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL) : fieldDescriptorBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED));
        descriptorBuilder.addField(fieldDescriptorBuilder.build());
    }

    private static @UnknownKeyFor @NonNull @Initialized TableRow mergeNewFields(@UnknownKeyFor @NonNull @Initialized TableRow original, @UnknownKeyFor @NonNull @Initialized TableRow newRow) {
        if (original == null) {
            return newRow;
        }
        if (newRow == null) {
            return original;
        }
        for (Map.Entry entry : newRow.entrySet()) {
            String key = (String)entry.getKey();
            Object value2 = entry.getValue();
            Object value1 = original.get((Object)key);
            if (value1 == null) {
                original.set(key, value2);
                continue;
            }
            if (value1 instanceof List && value2 instanceof List) {
                List list1 = (List)value1;
                List list2 = (List)value2;
                if (!list1.isEmpty() && list1.get(0) instanceof TableRow && !list2.isEmpty() && list2.get(0) instanceof TableRow) {
                    original.set(key, TableRowToStorageApiProto.mergeRepeatedStructs(list1, list2));
                    continue;
                }
                original.set(key, value2);
                continue;
            }
            if (!(value1 instanceof TableRow) || !(value2 instanceof TableRow)) continue;
            original.set(key, (Object)TableRowToStorageApiProto.mergeNewFields((TableRow)value1, (TableRow)value2));
        }
        return original;
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> mergeRepeatedStructs(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> list1, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> list2) {
        ArrayList<TableRow> mergedList = new ArrayList<TableRow>();
        int length = Math.min(list1.size(), list2.size());
        for (int i = 0; i < length; ++i) {
            TableRow orig = i < list1.size() ? list1.get(i) : null;
            TableRow delta = i < list2.size() ? list2.get(i) : null;
            Preconditions.checkArgumentNotNull((Object)orig);
            Preconditions.checkArgumentNotNull((Object)delta);
            mergedList.add(TableRowToStorageApiProto.mergeNewFields(orig, delta));
        }
        return mergedList;
    }

    public static @UnknownKeyFor @NonNull @Initialized ByteString mergeNewFields(@UnknownKeyFor @NonNull @Initialized ByteString tableRowProto, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DescriptorProtos.DescriptorProto descriptorProto, @UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema tableSchema, @UnknownKeyFor @NonNull @Initialized SchemaInformation schemaInformation, @UnknownKeyFor @NonNull @Initialized TableRow unknownFields, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues) throws @UnknownKeyFor @NonNull @Initialized SchemaConversionException {
        if (unknownFields == null || unknownFields.isEmpty()) {
            return tableRowProto;
        }
        boolean hasRepeatedStruct = unknownFields.entrySet().stream().anyMatch(entry -> entry.getValue() instanceof List && !((List)entry.getValue()).isEmpty() && ((List)entry.getValue()).get(0) instanceof TableRow);
        if (!hasRepeatedStruct) {
            Descriptors.Descriptor descriptorIgnoreRequired = null;
            try {
                descriptorIgnoreRequired = TableRowToStorageApiProto.getDescriptorFromTableSchema(tableSchema, false, false);
            }
            catch (Descriptors.DescriptorValidationException e) {
                throw new RuntimeException(e);
            }
            ByteString unknownFieldsProto = TableRowToStorageApiProto.messageFromTableRow(schemaInformation, descriptorIgnoreRequired, unknownFields, ignoreUnknownValues, true, null, null, null).toByteString();
            return tableRowProto.concat(unknownFieldsProto);
        }
        DynamicMessage message = null;
        Descriptors.Descriptor descriptor = null;
        try {
            descriptor = TableRowToStorageApiProto.wrapDescriptorProto(descriptorProto);
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new RuntimeException(e);
        }
        try {
            message = DynamicMessage.parseFrom((Descriptors.Descriptor)descriptor, (ByteString)tableRowProto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        TableRow original = TableRowToStorageApiProto.tableRowFromMessage(schemaInformation, (Message)message, true, (Predicate<String>)Predicates.alwaysTrue());
        Map fieldDescriptors = descriptor.getFields().stream().collect(Collectors.toMap(Descriptors.FieldDescriptor::getName, Functions.identity()));
        String cdcType = null;
        String sequence = null;
        if (fieldDescriptors.get("_CHANGE_TYPE") != null && fieldDescriptors.get("_CHANGE_SEQUENCE_NUMBER") != null) {
            cdcType = (String)message.getField((Descriptors.FieldDescriptor)Preconditions.checkStateNotNull((Object)((Descriptors.FieldDescriptor)fieldDescriptors.get("_CHANGE_TYPE"))));
            sequence = (String)message.getField((Descriptors.FieldDescriptor)Preconditions.checkStateNotNull((Object)((Descriptors.FieldDescriptor)fieldDescriptors.get("_CHANGE_SEQUENCE_NUMBER"))));
        }
        TableRow merged = TableRowToStorageApiProto.mergeNewFields(original, unknownFields);
        DynamicMessage dynamicMessage = TableRowToStorageApiProto.messageFromTableRow(schemaInformation, descriptor, merged, ignoreUnknownValues, false, null, cdcType, sequence);
        return dynamicMessage.toByteString();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @Nullable @UnknownKeyFor @Initialized Object messageValueFromFieldValue(@UnknownKeyFor @NonNull @Initialized SchemaInformation schemaInformation, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, @Nullable @UnknownKeyFor @Initialized Object bqValue, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues, @UnknownKeyFor @NonNull @Initialized boolean allowMissingRequiredFields, @UnknownKeyFor @NonNull @Initialized Supplier<@Nullable @UnknownKeyFor @Initialized TableRow> getUnknownNestedFields) throws @UnknownKeyFor @NonNull @Initialized SchemaConversionException {
        if (bqValue == null) {
            if (fieldDescriptor.isOptional() || allowMissingRequiredFields) {
                return null;
            }
            if (fieldDescriptor.isRepeated()) {
                return Collections.emptyList();
            }
            throw new SchemaDoesntMatchException("Received null value for non-nullable field " + schemaInformation.getFullName());
        }
        if (fieldDescriptor.isRepeated()) {
            List listValue = (List)bqValue;
            @Nullable ArrayList protoList = Lists.newArrayListWithCapacity((int)listValue.size());
            for (Object o : listValue) {
                if (o == null) continue;
                protoList.add(TableRowToStorageApiProto.singularFieldToProtoValue(schemaInformation, fieldDescriptor, o, ignoreUnknownValues, allowMissingRequiredFields, getUnknownNestedFields));
            }
            return protoList;
        }
        return TableRowToStorageApiProto.singularFieldToProtoValue(schemaInformation, fieldDescriptor, Preconditions.checkStateNotNull((Object)bqValue), ignoreUnknownValues, allowMissingRequiredFields, getUnknownNestedFields);
    }

    @VisibleForTesting
    static @Nullable @UnknownKeyFor @Initialized Object singularFieldToProtoValue(@UnknownKeyFor @NonNull @Initialized SchemaInformation schemaInformation, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, @UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues, @UnknownKeyFor @NonNull @Initialized boolean allowMissingRequiredFields, @UnknownKeyFor @NonNull @Initialized Supplier<@Nullable @UnknownKeyFor @Initialized TableRow> getUnknownNestedFields) throws @UnknownKeyFor @NonNull @Initialized SchemaConversionException {
        Object converted = null;
        if (schemaInformation.getType() == TableFieldSchema.Type.STRUCT) {
            if (value instanceof TableRow) {
                TableRow tableRow = (TableRow)value;
                converted = TableRowToStorageApiProto.messageFromTableRow(schemaInformation, fieldDescriptor.getMessageType(), tableRow, ignoreUnknownValues, allowMissingRequiredFields, getUnknownNestedFields.get(), null, null);
            } else if (value instanceof AbstractMap) {
                AbstractMap map = (AbstractMap)value;
                converted = TableRowToStorageApiProto.messageFromMap(schemaInformation, fieldDescriptor.getMessageType(), map, ignoreUnknownValues, allowMissingRequiredFields, getUnknownNestedFields.get(), null, null);
            }
        } else {
            @Nullable ThrowingBiFunction<String, Object, @Nullable Object> converter = TYPE_MAP_PROTO_CONVERTERS.get(schemaInformation.getType());
            if (converter == null) {
                throw new RuntimeException("Unknown type " + schemaInformation.getType());
            }
            converted = converter.apply(schemaInformation.getFullName(), value);
        }
        if (converted == null) {
            throw new SchemaDoesntMatchException("Unexpected value: " + value + ", type: " + (value == null ? "null" : value.getClass()) + ". Table field name: " + schemaInformation.getFullName() + ", type: " + schemaInformation.getType());
        }
        return converted;
    }

    private static @UnknownKeyFor @NonNull @Initialized long toEpochMicros(@UnknownKeyFor @NonNull @Initialized Instant timestamp) {
        return timestamp.getEpochSecond() * 1000000L + (long)(timestamp.getNano() / 1000);
    }

    @VisibleForTesting
    public static @UnknownKeyFor @NonNull @Initialized TableRow tableRowFromMessage(@UnknownKeyFor @NonNull @Initialized SchemaInformation schemaInformation, @UnknownKeyFor @NonNull @Initialized Message message, @UnknownKeyFor @NonNull @Initialized boolean includeCdcColumns, @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized String> includeField) {
        return TableRowToStorageApiProto.tableRowFromMessage(schemaInformation, message, includeCdcColumns, includeField, "");
    }

    public static @UnknownKeyFor @NonNull @Initialized TableRow tableRowFromMessage(@UnknownKeyFor @NonNull @Initialized SchemaInformation schemaInformation, @UnknownKeyFor @NonNull @Initialized Message message, @UnknownKeyFor @NonNull @Initialized boolean includeCdcColumns, @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized String> includeField, @UnknownKeyFor @NonNull @Initialized String namePrefix) {
        Optional<TableRow> tableRow = TableRowToStorageApiProto.tableRowFromMessageNoF(schemaInformation, message, includeCdcColumns, includeField, namePrefix);
        return tableRow.orElseGet(() -> TableRowToStorageApiProto.tableRowFromMessageUseSetF(schemaInformation, message, includeCdcColumns, includeField, ""));
    }

    private static @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized TableRow> tableRowFromMessageNoF(@UnknownKeyFor @NonNull @Initialized SchemaInformation schemaInformation, @UnknownKeyFor @NonNull @Initialized Message message, @UnknownKeyFor @NonNull @Initialized boolean includeCdcColumns, @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized String> includeField, @UnknownKeyFor @NonNull @Initialized String namePrefix) {
        TableRow tableRow = new TableRow();
        for (Map.Entry field : message.getAllFields().entrySet()) {
            StringBuilder fullName = new StringBuilder();
            Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)field.getKey();
            String fieldName = TableRowToStorageApiProto.fieldNameFromProtoFieldDescriptor(fieldDescriptor);
            if ("f".equals(fieldName)) {
                return Optional.empty();
            }
            fullName = fullName.append(namePrefix).append(fieldName);
            Object fieldValue = field.getValue();
            if (!includeCdcColumns && StorageApiCDC.COLUMNS.contains(fullName.toString()) || !includeField.test(fieldName)) continue;
            SchemaInformation fieldSchemaInformation = schemaInformation.getSchemaForField(fieldName);
            Object convertedFieldValue = TableRowToStorageApiProto.jsonValueFromMessageValue(fieldSchemaInformation, fieldDescriptor, fieldValue, true, includeField, fullName.append(".").toString(), false);
            if (convertedFieldValue instanceof Optional) {
                Optional optional = (Optional)convertedFieldValue;
                if (!optional.isPresent()) {
                    return Optional.empty();
                }
                convertedFieldValue = optional.get();
            }
            tableRow.put(fieldName, convertedFieldValue);
        }
        return Optional.of(tableRow);
    }

    public static @UnknownKeyFor @NonNull @Initialized TableRow tableRowFromMessageUseSetF(@UnknownKeyFor @NonNull @Initialized SchemaInformation schemaInformation, @UnknownKeyFor @NonNull @Initialized Message message, @UnknownKeyFor @NonNull @Initialized boolean includeCdcColumns, @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized String> includeField, @UnknownKeyFor @NonNull @Initialized String namePrefix) {
        ArrayList tableCells = Lists.newArrayListWithCapacity((int)message.getDescriptorForType().getFields().size());
        for (Descriptors.FieldDescriptor fieldDescriptor : message.getDescriptorForType().getFields()) {
            boolean isPresent;
            TableCell tableCell = new TableCell();
            boolean bl = isPresent = fieldDescriptor.isRepeated() && message.getRepeatedFieldCount(fieldDescriptor) > 0 || !fieldDescriptor.isRepeated() && message.hasField(fieldDescriptor);
            if (isPresent) {
                StringBuilder fullName = new StringBuilder();
                String fieldName = TableRowToStorageApiProto.fieldNameFromProtoFieldDescriptor(fieldDescriptor);
                fullName = fullName.append(namePrefix).append(fieldName);
                if ((includeCdcColumns || !StorageApiCDC.COLUMNS.contains(fullName.toString())) && includeField.test(fieldName)) {
                    SchemaInformation fieldSchemaInformation = schemaInformation.getSchemaForField(fieldName);
                    Object fieldValue = message.getField(fieldDescriptor);
                    Object converted = TableRowToStorageApiProto.jsonValueFromMessageValue(fieldSchemaInformation, fieldDescriptor, fieldValue, true, includeField, fullName.append(".").toString(), true);
                    tableCell.setV(converted);
                }
            }
            tableCells.add(tableCell);
        }
        TableRow tableRow = new TableRow();
        tableRow.setF((List)tableCells);
        return tableRow;
    }

    public static @UnknownKeyFor @NonNull @Initialized Object jsonValueFromMessageValue(@UnknownKeyFor @NonNull @Initialized SchemaInformation schemaInformation, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, @UnknownKeyFor @NonNull @Initialized Object fieldValue, @UnknownKeyFor @NonNull @Initialized boolean expandRepeated, @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized String> includeField, @UnknownKeyFor @NonNull @Initialized String prefix, @UnknownKeyFor @NonNull @Initialized boolean useSetF) {
        if (expandRepeated && fieldDescriptor.isRepeated()) {
            List valueList = (List)fieldValue;
            ArrayList expanded = Lists.newArrayListWithCapacity((int)valueList.size());
            for (Object value : valueList) {
                Object translatedValue = TableRowToStorageApiProto.jsonValueFromMessageValue(schemaInformation, fieldDescriptor, value, false, includeField, prefix, useSetF);
                if (!useSetF && translatedValue instanceof Optional) {
                    Optional optional = (Optional)translatedValue;
                    if (!optional.isPresent()) {
                        return Optional.empty();
                    }
                    translatedValue = optional.get();
                }
                expanded.add(translatedValue);
            }
            return expanded;
        }
        switch (schemaInformation.getType()) {
            case DOUBLE: {
                switch (fieldDescriptor.getType()) {
                    case FLOAT: 
                    case DOUBLE: 
                    case STRING: {
                        return DECIMAL_FORMAT.format(Double.parseDouble(fieldValue.toString()));
                    }
                    case MESSAGE: {
                        Message doubleMessage = (Message)fieldValue;
                        if (FLOAT_VALUE_DESCRIPTOR_NAMES.contains(fieldDescriptor.getMessageType().getName())) {
                            float floatValue = ((Float)doubleMessage.getField(doubleMessage.getDescriptorForType().findFieldByName("value"))).floatValue();
                            return DECIMAL_FORMAT.format(floatValue);
                        }
                        if (DOUBLE_VALUE_DESCRIPTOR_NAMES.contains(fieldDescriptor.getMessageType().getName())) {
                            double doubleValue = (Double)doubleMessage.getField(doubleMessage.getDescriptorForType().findFieldByName("value"));
                            return DECIMAL_FORMAT.format(doubleValue);
                        }
                        throw new RuntimeException("Not implemented yet " + fieldDescriptor.getMessageType().getName());
                    }
                }
                return fieldValue.toString();
            }
            case BOOL: {
                if (fieldDescriptor.getType().equals((Object)Descriptors.FieldDescriptor.Type.MESSAGE)) {
                    Message boolMessage = (Message)fieldValue;
                    if (BOOL_VALUE_DESCRIPTOR_NAMES.contains(fieldDescriptor.getMessageType().getName())) {
                        return boolMessage.getField(boolMessage.getDescriptorForType().findFieldByName("value")).toString();
                    }
                    throw new RuntimeException("Not implemented yet " + fieldDescriptor.getMessageType().getName());
                }
                return fieldValue.toString();
            }
            case JSON: 
            case GEOGRAPHY: 
            case STRING: {
                return fieldValue.toString();
            }
            case INT64: {
                switch (fieldDescriptor.getType()) {
                    case MESSAGE: {
                        Message message = (Message)fieldValue;
                        if (INT32_VALUE_DESCRIPTOR_NAMES.contains(fieldDescriptor.getMessageType().getName())) {
                            return message.getField(message.getDescriptorForType().findFieldByName("value")).toString();
                        }
                        if (INT64_VALUE_DESCRIPTOR_NAMES.contains(fieldDescriptor.getMessageType().getName())) {
                            return message.getField(message.getDescriptorForType().findFieldByName("value")).toString();
                        }
                        if (UINT32_VALUE_DESCRIPTOR_NAMES.contains(fieldDescriptor.getMessageType().getName())) {
                            return message.getField(message.getDescriptorForType().findFieldByName("value")).toString();
                        }
                        if (UINT64_VALUE_DESCRIPTOR_NAMES.contains(fieldDescriptor.getMessageType().getName())) {
                            return message.getField(message.getDescriptorForType().findFieldByName("value")).toString();
                        }
                        throw new RuntimeException("Not implemented yet " + fieldDescriptor.getMessageType().getFullName());
                    }
                }
                return fieldValue.toString();
            }
            case BYTES: {
                switch (fieldDescriptor.getType()) {
                    case BYTES: {
                        return BaseEncoding.base64().encode(((ByteString)fieldValue).toByteArray());
                    }
                    case STRING: {
                        return BaseEncoding.base64().encode(((String)fieldValue).getBytes(StandardCharsets.UTF_8));
                    }
                    case MESSAGE: {
                        Message message = (Message)fieldValue;
                        if (BYTES_VALUE_DESCRIPTOR_NAMES.contains(fieldDescriptor.getMessageType().getName())) {
                            ByteString byteString = (ByteString)message.getField(message.getDescriptorForType().findFieldByName("value"));
                            return BaseEncoding.base64().encode(byteString.toByteArray());
                        }
                        throw new RuntimeException("Not implemented " + fieldDescriptor.getMessageType().getFullName());
                    }
                }
                return fieldValue.toString();
            }
            case TIMESTAMP: {
                if (TableRowToStorageApiProto.isProtoFieldTypeInteger(fieldDescriptor.getType())) {
                    long epochMicros = Long.valueOf(fieldValue.toString());
                    long epochSeconds = epochMicros / 1000000L;
                    long nanoAdjustment = epochMicros % 1000000L * 1000L;
                    Instant instant = Instant.ofEpochSecond(epochSeconds, nanoAdjustment);
                    return java.time.LocalDateTime.ofInstant(instant, ZoneOffset.UTC).format(BigQueryUtils.TIMESTAMP_FORMATTER);
                }
                if (fieldDescriptor.getType().equals((Object)Descriptors.FieldDescriptor.Type.MESSAGE)) {
                    Message message = (Message)fieldValue;
                    if (TIMESTAMP_VALUE_DESCRIPTOR_NAMES.contains(fieldDescriptor.getMessageType().getName())) {
                        Descriptors.Descriptor descriptor = message.getDescriptorForType();
                        long seconds = (Long)message.getField(descriptor.findFieldByName("seconds"));
                        int nanos = (Integer)message.getField(descriptor.findFieldByName("nanos"));
                        Instant instant = Instant.ofEpochSecond(seconds, nanos);
                        return java.time.LocalDateTime.ofInstant(instant, ZoneOffset.UTC).format(BigQueryUtils.TIMESTAMP_FORMATTER);
                    }
                    throw new RuntimeException("Not implemented yet " + fieldDescriptor.getMessageType().getFullName());
                }
                return fieldValue.toString();
            }
            case DATE: {
                if (TableRowToStorageApiProto.isProtoFieldTypeInteger(fieldDescriptor.getType())) {
                    int intDate = Integer.parseInt(fieldValue.toString());
                    return LocalDate.ofEpochDay(intDate).toString();
                }
                return fieldValue.toString();
            }
            case NUMERIC: {
                switch (fieldDescriptor.getType()) {
                    case BYTES: {
                        ByteString numericByteString = (ByteString)fieldValue;
                        return BigDecimalByteStringEncoder.decodeNumericByteString((ByteString)numericByteString).stripTrailingZeros().toString();
                    }
                }
                return fieldValue.toString();
            }
            case BIGNUMERIC: {
                switch (fieldDescriptor.getType()) {
                    case BYTES: {
                        ByteString numericByteString = (ByteString)fieldValue;
                        return BigDecimalByteStringEncoder.decodeBigNumericByteString((ByteString)numericByteString).stripTrailingZeros().toString();
                    }
                }
                return fieldValue.toString();
            }
            case DATETIME: {
                if (TableRowToStorageApiProto.isProtoFieldTypeInteger(fieldDescriptor.getType())) {
                    long packedDateTime = Long.valueOf(fieldValue.toString());
                    return CivilTimeEncoder.decodePacked64DatetimeMicrosAsJavaTime(packedDateTime).format(BigQueryUtils.BIGQUERY_DATETIME_FORMATTER);
                }
                return fieldValue.toString();
            }
            case TIME: {
                if (TableRowToStorageApiProto.isProtoFieldTypeInteger(fieldDescriptor.getType())) {
                    long packedTime = Long.valueOf(fieldValue.toString());
                    return CivilTimeEncoder.decodePacked64TimeMicrosAsJavaTime(packedTime).toString();
                }
                return fieldValue.toString();
            }
            case STRUCT: {
                return useSetF ? TableRowToStorageApiProto.tableRowFromMessageUseSetF(schemaInformation, (Message)fieldValue, false, includeField, prefix) : TableRowToStorageApiProto.tableRowFromMessageNoF(schemaInformation, (Message)fieldValue, false, includeField, prefix);
            }
        }
        return fieldValue.toString();
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isProtoFieldTypeInteger(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor.Type type) {
        switch (type) {
            case INT32: 
            case INT64: 
            case UINT32: 
            case UINT64: 
            case SFIXED32: 
            case SFIXED64: 
            case SINT64: {
                return true;
            }
        }
        return false;
    }

    public static class SchemaInformation {
        private final @UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableFieldSchema tableFieldSchema;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SchemaInformation> subFields;
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized SchemaInformation> subFieldsByName;
        private final @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized SchemaInformation> parentSchemas;

        private SchemaInformation(@UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableFieldSchema tableFieldSchema, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized SchemaInformation> parentSchemas) {
            this.tableFieldSchema = tableFieldSchema;
            this.subFields = Lists.newArrayList();
            this.subFieldsByName = Maps.newHashMap();
            this.parentSchemas = parentSchemas;
            for (com.google.cloud.bigquery.storage.v1.TableFieldSchema field : tableFieldSchema.getFieldsList()) {
                SchemaInformation schemaInformation = new SchemaInformation(field, Iterables.concat(this.parentSchemas, (Iterable)ImmutableList.of((Object)this)));
                this.subFields.add(schemaInformation);
                this.subFieldsByName.put(field.getName().toLowerCase(), schemaInformation);
            }
        }

        public @UnknownKeyFor @NonNull @Initialized String getFullName() {
            String prefix = StreamSupport.stream(this.parentSchemas.spliterator(), false).map(SchemaInformation::getName).collect(Collectors.joining("."));
            return prefix.isEmpty() ? this.getName() : prefix + "." + this.getName();
        }

        public @UnknownKeyFor @NonNull @Initialized String getName() {
            return this.tableFieldSchema.getName();
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Type getType() {
            return this.tableFieldSchema.getType();
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isNullable() {
            return this.tableFieldSchema.getMode().equals((Object)TableFieldSchema.Mode.NULLABLE);
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isRepeated() {
            return this.tableFieldSchema.getMode().equals((Object)TableFieldSchema.Mode.REPEATED);
        }

        public @UnknownKeyFor @NonNull @Initialized SchemaInformation getSchemaForField(@UnknownKeyFor @NonNull @Initialized String name) {
            SchemaInformation schemaInformation = this.subFieldsByName.get(name.toLowerCase());
            if (schemaInformation == null) {
                throw new RuntimeException("Schema field not found: " + name.toLowerCase());
            }
            return schemaInformation;
        }

        public @UnknownKeyFor @NonNull @Initialized SchemaInformation getSchemaForField(@UnknownKeyFor @NonNull @Initialized int i) {
            SchemaInformation schemaInformation = this.subFields.get(i);
            if (schemaInformation == null) {
                throw new RuntimeException("Schema field not found: " + i);
            }
            return schemaInformation;
        }

        public static @UnknownKeyFor @NonNull @Initialized SchemaInformation fromTableSchema(@UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema tableSchema) {
            com.google.cloud.bigquery.storage.v1.TableFieldSchema root = com.google.cloud.bigquery.storage.v1.TableFieldSchema.newBuilder().addAllFields((Iterable)tableSchema.getFieldsList()).setName("root").build();
            return new SchemaInformation(root, Collections.emptyList());
        }

        static @UnknownKeyFor @NonNull @Initialized SchemaInformation fromTableSchema(@UnknownKeyFor @NonNull @Initialized TableSchema jsonTableSchema) {
            return SchemaInformation.fromTableSchema(TableRowToStorageApiProto.schemaToProtoTableSchema(jsonTableSchema));
        }
    }

    @FunctionalInterface
    public static interface ThrowingBiFunction<@UnknownKeyFor FirstInputT, @UnknownKeyFor SecondInputT, @UnknownKeyFor OutputT> {
        public OutputT apply(FirstInputT var1, SecondInputT var2) throws @UnknownKeyFor @NonNull @Initialized SchemaConversionException;
    }

    public static class SingleValueConversionException
    extends SchemaConversionException {
        SingleValueConversionException(@UnknownKeyFor @NonNull @Initialized Object sourceValue, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Type type, @UnknownKeyFor @NonNull @Initialized String fullName, @UnknownKeyFor @NonNull @Initialized Exception e) {
            super("Column: " + SingleValueConversionException.getPrettyFieldName(fullName) + " (" + type + "). Value: " + sourceValue + " (" + sourceValue.getClass().getName() + "). Reason: " + e);
        }

        private static @UnknownKeyFor @NonNull @Initialized String getPrettyFieldName(@UnknownKeyFor @NonNull @Initialized String fullName) {
            String rootPrefix = "root.";
            return fullName.startsWith(rootPrefix) ? fullName.substring(rootPrefix.length()) : fullName;
        }
    }

    public static class SchemaDoesntMatchException
    extends SchemaConversionException {
        SchemaDoesntMatchException(@UnknownKeyFor @NonNull @Initialized String msg) {
            super(msg);
        }

        SchemaDoesntMatchException(@UnknownKeyFor @NonNull @Initialized String msg, @UnknownKeyFor @NonNull @Initialized Exception e) {
            super(msg + ". Exception: " + e, e);
        }
    }

    public static class SchemaTooNarrowException
    extends SchemaConversionException {
        SchemaTooNarrowException(@UnknownKeyFor @NonNull @Initialized String msg) {
            super(msg);
        }
    }

    static abstract class SchemaConversionException
    extends Exception {
        SchemaConversionException(@UnknownKeyFor @NonNull @Initialized String msg) {
            super(msg);
        }

        SchemaConversionException(@UnknownKeyFor @NonNull @Initialized String msg, @UnknownKeyFor @NonNull @Initialized Exception e) {
            super(msg, e);
        }
    }
}

