/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.drools;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transform.BaseTransformData;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transforms.drools.RuleValidationException;
import org.apache.hop.pipeline.transforms.drools.Rules;
import org.apache.hop.pipeline.transforms.drools.RulesAccumulator;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.utils.KieHelper;

public class RulesAccumulatorData
extends BaseTransformData
implements ITransformData {
    private static final Class<?> PKG = RulesAccumulator.class;
    private IRowMeta outputRowMeta;
    private IRowMeta inputRowMeta;
    private List<Object[]> results;
    private String ruleString;
    private List<Rules.Row> rowList = new ArrayList<Rules.Row>();
    private List<Rules.Row> resultList = new ArrayList<Rules.Row>();
    private KieHelper kieHelper;
    private String ruleFilePath;

    public String getRuleString() {
        return this.ruleString;
    }

    public void setRuleString(String ruleString) {
        this.ruleString = ruleString;
    }

    public String getRuleFilePath() {
        return this.ruleFilePath;
    }

    public void setRuleFilePath(String ruleFilePath) {
        this.ruleFilePath = ruleFilePath;
    }

    public void setOutputRowMeta(IRowMeta outputRowMeta) {
        this.outputRowMeta = outputRowMeta;
    }

    public IRowMeta getOutputRowMeta() {
        return this.outputRowMeta;
    }

    public void initializeRules() throws RuleValidationException {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(loader);
        Resource ruleSet = null;
        ruleSet = this.ruleString != null ? ResourceFactory.newReaderResource((Reader)new StringReader(this.ruleString)) : ResourceFactory.newFileResource((String)this.ruleFilePath);
        this.kieHelper = new KieHelper();
        this.kieHelper.addResource(ruleSet, ResourceType.DRL);
        Results results1 = this.kieHelper.verify();
        if (results1.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new RuleValidationException(results1.getMessages());
        }
        Thread.currentThread().setContextClassLoader(orig);
    }

    public void initializeInput(IRowMeta _inputRowMeta) {
        if (_inputRowMeta == null) {
            BaseMessages.getString(PKG, (String)"RulesData.InitializeColumns.InputRowMetaIsNull", (String[])new String[0]);
            return;
        }
        this.inputRowMeta = _inputRowMeta;
    }

    public void loadRow(Object[] r) {
        Hashtable<String, Object> columns = new Hashtable<String, Object>();
        for (String field : this.inputRowMeta.getFieldNames()) {
            columns.put(field, r[this.inputRowMeta.indexOfValue(field)]);
        }
        this.rowList.add(new Rules.Row(columns, true));
    }

    public List<Rules.Row> getResultRows() {
        return this.resultList;
    }

    public void execute() {
        ClassLoader orig = Thread.currentThread().getContextClassLoader();
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(loader);
        if (this.kieHelper != null) {
            KieSession session = this.kieHelper.getKieContainer().newKieSession();
            for (Rules.Row fact : this.rowList) {
                session.insert((Object)fact);
            }
            int fh = session.fireAllRules();
            Collection oList = session.getObjects(o -> {
                Rules.Row row;
                return o instanceof Rules.Row && !(row = (Rules.Row)o).isExternalSource();
            });
            for (Object o2 : oList) {
                this.resultList.add((Rules.Row)o2);
            }
            session.dispose();
        }
        Thread.currentThread().setContextClassLoader(orig);
    }

    public List<Object[]> fetchResults() {
        return this.results;
    }

    public void shutdown() {
    }
}

