/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.SystemValue;
import com.ibm.as400.access.SystemValueInfo;
import com.ibm.as400.access.SystemValueList;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;

class SystemValueUtility {
    SystemValueUtility() {
    }

    private static Vector parse(byte[] data, AS400 system, Converter conv) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException, IOException {
        Vector<String[]> values = new Vector<String[]>();
        int valueNumber = BinaryConverter.byteArrayToInt(data, 0);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Number of values:", valueNumber);
        }
        for (int i = 0; i < valueNumber; ++i) {
            int valueOffset = BinaryConverter.byteArrayToInt(data, (i + 1) * 4);
            String name = conv.byteArrayToString(data, valueOffset, 10).trim();
            SystemValueInfo obj = SystemValueList.lookup(name);
            if (data[valueOffset + 11] == -45) {
                Trace.log(2, "System value is locked, name: " + name);
                throw new ExtendedIOException(name, 33);
            }
            if (data[valueOffset + 10] != obj.serverDataType_) {
                Trace.log(2, "System value type mismatch, name: " + name);
                throw new ExtendedIllegalStateException("type", 4);
            }
            int size = BinaryConverter.byteArrayToInt(data, valueOffset + 12);
            Object value = null;
            switch (obj.serverDataType_) {
                case -61: {
                    if (obj.type_ == 4) {
                        int arrayCount;
                        int dataOffset = valueOffset + 16;
                        for (arrayCount = 0; arrayCount < obj.arraySize_ && data[dataOffset + arrayCount * obj.size_] != 64; ++arrayCount) {
                        }
                        String[] valueArray = new String[arrayCount];
                        for (int ii = 0; ii < arrayCount; ++ii) {
                            valueArray[ii] = conv.byteArrayToString(data, dataOffset + ii * obj.size_, obj.size_);
                        }
                        value = valueArray;
                        break;
                    }
                    value = conv.byteArrayToString(data, valueOffset + 16, size);
                    break;
                }
                case -62: {
                    if (obj.type_ == 2) {
                        byte[] valueBytes = new byte[4];
                        System.arraycopy(data, valueOffset + 16, valueBytes, 0, 4);
                        value = new BigDecimal(new BigInteger(valueBytes), obj.decimalPositions_);
                        break;
                    }
                    value = BinaryConverter.byteArrayToInt(data, valueOffset + 16);
                    break;
                }
                default: {
                    Trace.log(4, "Invalid value for SystemValueInfo.serverDataType_: " + obj.serverDataType_);
                }
            }
            if (obj.name_.equals("QDATE")) {
                String stringValue = value.toString();
                Calendar cal = AS400Calendar.getGregorianInstance();
                cal.set(1900 + 100 * Integer.parseInt(stringValue.substring(0, 1)) + Integer.parseInt(stringValue.substring(1, 3)), Integer.parseInt(stringValue.substring(3, 5)) - 1, Integer.parseInt(stringValue.substring(5, 7)));
                long millis = cal.getTimeInMillis();
                value = new Date(millis);
            } else if (obj.name_.equals("QTIME")) {
                String stringValue = value.toString();
                Calendar cal = AS400Calendar.getGregorianInstance();
                cal.set(11, Integer.parseInt(stringValue.substring(0, 2)));
                cal.set(12, Integer.parseInt(stringValue.substring(2, 4)));
                cal.set(13, Integer.parseInt(stringValue.substring(4, 6)));
                cal.set(14, Integer.parseInt(stringValue.substring(6, 9)));
                long millis = cal.getTimeInMillis();
                value = new Time(millis);
            } else if (obj.name_.equals("PNDSYSNAME")) {
                value = ((String)value).replace('\u0000', ' ');
            } else if (obj.name_.equals("QLOCALE")) {
                int offset = valueOffset + 16;
                int localeCcsid = BinaryConverter.byteArrayToInt(data, offset);
                int localeLen = BinaryConverter.byteArrayToInt(data, offset + 16);
                value = localeLen == 0 ? "*NONE" : (localeLen == 1 ? conv.byteArrayToString(data, offset + 32, 20) : new Converter(localeCcsid, system).byteArrayToString(data, offset + 32, localeLen));
            }
            values.addElement((String[])value);
        }
        return values;
    }

    static Object retrieve(AS400 system, SystemValueInfo info) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Vector<SystemValueInfo> infos = new Vector<SystemValueInfo>();
        infos.addElement(info);
        Vector values = SystemValueUtility.retrieveFromSystem(system, infos, info.group_ == 8);
        return values.elementAt(0);
    }

    static Vector retrieve(AS400 system, Enumeration infos, String groupName, String groupDescription) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int i;
        Vector<SystemValueInfo> svInfos = new Vector<SystemValueInfo>();
        Vector<SystemValueInfo> naInfos = new Vector<SystemValueInfo>();
        int vrm = system.getVRM();
        while (infos.hasMoreElements()) {
            SystemValueInfo svi = (SystemValueInfo)infos.nextElement();
            if (svi.release_ > vrm) continue;
            if (svi.group_ == 8) {
                naInfos.addElement(svi);
                continue;
            }
            svInfos.addElement(svi);
        }
        Vector svValues = new Vector();
        Vector naValues = new Vector();
        if (svInfos.size() > 0) {
            svValues = SystemValueUtility.retrieveFromSystem(system, svInfos, false);
        }
        if (naInfos.size() > 0) {
            naValues = SystemValueUtility.retrieveFromSystem(system, naInfos, true);
        }
        Vector<SystemValue> systemValues = new Vector<SystemValue>(svInfos.size() + naInfos.size());
        for (i = 0; i < svInfos.size(); ++i) {
            systemValues.addElement(new SystemValue(system, (SystemValueInfo)svInfos.elementAt(i), svValues.elementAt(i), groupName, groupDescription));
        }
        for (i = 0; i < naInfos.size(); ++i) {
            systemValues.addElement(new SystemValue(system, (SystemValueInfo)naInfos.elementAt(i), naValues.elementAt(i), groupName, groupDescription));
        }
        return systemValues;
    }

    static Vector retrieveFromSystem(AS400 system, Vector infos, boolean isNetA) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int valuesCount = infos.size();
        int rLength = 4;
        byte[] names = new byte[valuesCount * 10];
        for (int i = 0; i < names.length; ++i) {
            names[i] = 64;
        }
        Converter conv = new Converter(system.getJobCcsid(), system);
        for (int i = 0; i < valuesCount; ++i) {
            SystemValueInfo svi = (SystemValueInfo)infos.elementAt(i);
            rLength += svi.size_ * svi.arraySize_ + 24;
            conv.stringToByteArray(svi.name_, names, i * 10);
        }
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(rLength), new ProgramParameter(BinaryConverter.intToByteArray(rLength)), new ProgramParameter(BinaryConverter.intToByteArray(valuesCount)), new ProgramParameter(names), new ProgramParameter(new byte[8])};
        ProgramCall prog = new ProgramCall(system, isNetA ? "/QSYS.LIB/QWCRNETA.PGM" : "/QSYS.LIB/QWCRSVAL.PGM", parameters);
        prog.suggestThreadsafe();
        if (!prog.run()) {
            throw new AS400Exception(prog.getMessageList());
        }
        return SystemValueUtility.parse(parameters[0].getOutputData(), system, conv);
    }

    static void set(AS400 system, SystemValueInfo info, Object value) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (info.readOnly_) {
            Trace.log(2, "Cannot set value of read only system value, name: " + info.name_);
            throw new ExtendedIllegalStateException(info.name_, 12);
        }
        boolean isNetA = info.group_ == 8;
        StringBuilder command = new StringBuilder(isNetA ? "QSYS/CHGNETA " + info.name_ + "(" : "QSYS/CHGSYSVAL SYSVAL(" + info.name_ + ") VALUE(");
        String valueString = value.toString();
        if (valueString.indexOf("*") == 0) {
            if (Trace.isTraceOn()) {
                Trace.log(1, "System value's value is special star value: '" + (String)value + "'");
            }
            command.append(valueString.trim());
        } else {
            try {
                switch (info.type_) {
                    case 1: {
                        command.append(isNetA ? valueString : "'" + valueString + "'");
                        break;
                    }
                    case 2: {
                        command.append(((BigDecimal)value).setScale(info.decimalPositions_, 4).toString());
                        break;
                    }
                    case 3: {
                        command.append(((Integer)value).toString());
                        break;
                    }
                    case 4: {
                        Object[] objarr = (Object[])value;
                        int length = objarr.length;
                        if (!isNetA) {
                            command.append("'");
                        }
                        for (int j = 0; j < length; ++j) {
                            command.append((String)objarr[j]);
                            command.append(" ");
                        }
                        if (!isNetA) {
                            command.append("'");
                        }
                        break;
                    }
                    case 5: {
                        Calendar dateTime = AS400Calendar.getGregorianInstance();
                        dateTime.clear();
                        dateTime.setTime((java.util.Date)value);
                        if (info.name_.equals("QDATE")) {
                            String day;
                            String month;
                            String year;
                            String century;
                            int iYear = dateTime.get(1);
                            if (iYear < 1900 || iYear > 2100) {
                                Trace.log(2, "Value of system value 'QYEAR' is not valid:", iYear);
                                throw new ExtendedIllegalArgumentException("QYEAR  (" + iYear + ")", 4);
                            }
                            if (iYear < 2000) {
                                century = "0";
                                year = Integer.toString(iYear - 1900);
                            } else {
                                century = "1";
                                year = Integer.toString(iYear - 2000);
                            }
                            if (year.length() == 1) {
                                year = "0" + year;
                            }
                            if ((month = Integer.toString(dateTime.get(2) + 1)).length() == 1) {
                                month = "0" + month;
                            }
                            if ((day = Integer.toString(dateTime.get(5))).length() == 1) {
                                day = "0" + day;
                            }
                            SystemValueUtility.set(system, SystemValueList.lookup("QCENTURY"), century);
                            SystemValueUtility.set(system, SystemValueList.lookup("QYEAR"), year);
                            SystemValueUtility.set(system, SystemValueList.lookup("QMONTH"), month);
                            SystemValueUtility.set(system, SystemValueList.lookup("QDAY"), day);
                            return;
                        }
                        command.append("'");
                        int hour = dateTime.get(11);
                        if (hour < 10) {
                            command.append("0");
                        }
                        command.append(Integer.toString(hour));
                        int minute = dateTime.get(12);
                        if (minute < 10) {
                            command.append("0");
                        }
                        command.append(Integer.toString(minute));
                        int second = dateTime.get(13);
                        if (second < 10) {
                            command.append("0");
                        }
                        command.append(Integer.toString(second));
                        command.append("'");
                        break;
                    }
                    default: {
                        Trace.log(2, "Invalid value for SystemValueInfo.type_: " + info.type_);
                        throw new InternalErrorException(6);
                    }
                }
            }
            catch (ClassCastException cce) {
                Trace.log(2, "Cannot set system value, value is of incorrect type, name: " + info.name_ + ", value: " + value, (Throwable)cce);
                throw new ExtendedIllegalArgumentException(info.name_, 2);
            }
        }
        command.append(")");
        CommandCall cmd = new CommandCall(system, command.toString());
        cmd.suggestThreadsafe(false);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Running system value command: " + command.toString());
        }
        if (!cmd.run()) {
            throw new AS400Exception(cmd.getMessageList());
        }
    }
}

