/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;

class AS400StrSvrReplyDS
extends ClientAccessDataStream {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";

    AS400StrSvrReplyDS() {
    }

    @Override
    public Object getNewDataStream() {
        return new AS400StrSvrReplyDS();
    }

    int getRC() {
        return this.get32bit(20);
    }

    byte[] getUserIdBytes() {
        int offset = this.findCP(4356);
        if (offset == -1) {
            return null;
        }
        byte[] userIdBytes = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        System.arraycopy(this.data_, offset + 10, userIdBytes, 0, this.get32bit(offset) - 10);
        return userIdBytes;
    }

    byte[] getJobNameBytes() {
        int offset = this.findCP(4383);
        if (offset == -1) {
            return new byte[0];
        }
        byte[] jobNameBytes = new byte[this.get32bit(offset) - 10];
        System.arraycopy(this.data_, offset + 10, jobNameBytes, 0, jobNameBytes.length);
        return jobNameBytes;
    }

    int findCP(int cp) {
        for (int offset = 24; offset < this.data_.length - 1; offset += this.get32bit(offset)) {
            if (this.get16bit(offset + 4) != cp) continue;
            return offset;
        }
        return -1;
    }

    void read(InputStream in) throws IOException {
        byte[] header;
        if (Trace.traceOn_) {
            Trace.log(1, "Receiving start server reply...");
        }
        if (this.readFromStream(in, header = new byte[20], 0, 20) < 20) {
            if (Trace.traceOn_) {
                Trace.log(2, "Failed to read all of the start server reply header.");
            }
            throw new ConnectionDroppedException(2);
        }
        this.data_ = new byte[BinaryConverter.byteArrayToInt(header, 0)];
        System.arraycopy(header, 0, this.data_, 0, 20);
        this.readAfterHeader(in);
    }

    @Override
    public int hashCode() {
        return 61442;
    }
}

