/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.readrows;

import com.google.api.core.InternalApi;
import com.google.api.gax.retrying.StreamResumptionStrategy;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.RowSet;
import com.google.cloud.bigtable.data.v2.internal.RowSetUtil;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.cloud.bigtable.data.v2.stub.BigtableStreamResumptionStrategy;
import com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsRetryCompletedCallable;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;

@InternalApi
public class ReadRowsResumptionStrategy<RowT>
extends BigtableStreamResumptionStrategy<ReadRowsRequest, RowT> {
    private final RowAdapter<RowT> rowAdapter;
    private ByteString lastKey = ByteString.EMPTY;
    private long numProcessed;

    public ReadRowsResumptionStrategy(RowAdapter<RowT> rowAdapter) {
        this.rowAdapter = rowAdapter;
    }

    public boolean canResume() {
        return true;
    }

    public StreamResumptionStrategy<ReadRowsRequest, RowT> createNew() {
        return new ReadRowsResumptionStrategy<RowT>(this.rowAdapter);
    }

    public RowT processResponse(RowT response) {
        this.lastKey = this.rowAdapter.getKey(response);
        if (!this.rowAdapter.isScanMarkerRow(response)) {
            ++this.numProcessed;
        }
        return response;
    }

    @Override
    public Throwable processError(Throwable throwable) {
        return throwable;
    }

    public ReadRowsRequest getResumeRequest(ReadRowsRequest originalRequest) {
        if (this.lastKey.isEmpty()) {
            return originalRequest;
        }
        RowSet remaining = RowSetUtil.erase(originalRequest.getRows(), this.lastKey, !originalRequest.getReversed());
        if (remaining == null || originalRequest.getRowsLimit() > 0L && originalRequest.getRowsLimit() == this.numProcessed) {
            return ReadRowsRetryCompletedCallable.FULFILLED_REQUEST_MARKER;
        }
        ReadRowsRequest.Builder builder = originalRequest.toBuilder().setRows(remaining);
        if (originalRequest.getRowsLimit() > 0L) {
            Preconditions.checkState((originalRequest.getRowsLimit() > this.numProcessed ? 1 : 0) != 0, (Object)"Detected too many rows for the current row limit during a retry.");
            builder.setRowsLimit(originalRequest.getRowsLimit() - this.numProcessed);
        }
        return builder.build();
    }
}

