/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pipeline.transform.jdbcmetadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.pipeline.transform.jdbcmetadata.JdbcMetadataMeta;
import org.apache.pipeline.transform.jdbcmetadata.OutputField;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class JdbcMetadataDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = JdbcMetadataMeta.class;
    private JdbcMetadataMeta input;
    private int middle;
    private int margin;
    private boolean dialogChanged;
    private ModifyListener lsMod;
    private Composite metadataComposite;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private Label alwaysPassInputRowLabel;
    private Button alwaysPassInputRowButton;
    private Label methodLabel;
    private Combo methodCombo;
    private Label argumentSourceLabel;
    private Button argumentSourceFields;
    private Label removeArgumentFieldsLabel;
    private Button removeArgumentFieldsButton;
    private TableView outputFieldsTableView;
    private final String[] emptyFieldList;

    public JdbcMetadataDialog(Shell parent, IVariables variables, JdbcMetadataMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.middle = this.props.getMiddlePct();
        this.margin = PropsUi.getMargin();
        this.emptyFieldList = new String[0];
        this.input = transformMeta;
    }

    private String[] getFieldListForCombo() {
        String[] items;
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            items = r.getFieldNames();
        }
        catch (HopException exception) {
            items = this.emptyFieldList;
        }
        return items;
    }

    private List<String> removeArgumentsUI() {
        Control[] controls = this.metadataComposite.getChildren();
        ArrayList<String> currentValues = new ArrayList<String>();
        for (Control control : controls) {
            if (control == this.alwaysPassInputRowLabel || control == this.alwaysPassInputRowButton || control == this.methodLabel || control == this.methodCombo || control == this.argumentSourceLabel || control == this.argumentSourceFields || control == this.removeArgumentFieldsLabel || control == this.removeArgumentFieldsButton) continue;
            if (control instanceof ComboVar) {
                ComboVar comboVar = (ComboVar)control;
                if (!(control.isDisposed() || comboVar.getText() == null && comboVar.getText().isEmpty())) {
                    currentValues.add(((ComboVar)control).getText());
                }
            }
            if (control.isDisposed()) continue;
            this.logDebug("removeArgumentsUI - Disposing control!");
            control.dispose();
            this.logDebug("removeArgumentsUI - number of children in parent composite: " + controls.length);
        }
        return currentValues;
    }

    private ComboVar createArgumentUI(Object[] argumentDescriptor, Control lastControl, String[] items) {
        String argumentName = (String)argumentDescriptor[0];
        Label label = new Label(this.metadataComposite, 131072);
        label.setText(BaseMessages.getString(PKG, (String)("JdbcMetadata.arguments." + argumentName + ".Label"), (String[])new String[0]));
        label.setToolTipText(BaseMessages.getString(PKG, (String)("JdbcMetadata.arguments." + argumentName + ".Tooltip"), (String[])new String[0]));
        PropsUi.setLook((Widget)label);
        FormData labelFormData = new FormData();
        labelFormData.left = new FormAttachment(0, 0);
        labelFormData.right = new FormAttachment(this.middle, -this.margin);
        labelFormData.top = new FormAttachment(lastControl, this.margin);
        label.setLayoutData((Object)labelFormData);
        ComboVar comboVar = new ComboVar(this.variables, this.metadataComposite, 18436);
        PropsUi.setLook((Widget)comboVar);
        FormData comboVarFormData = new FormData();
        comboVarFormData.left = new FormAttachment(this.middle, 0);
        comboVarFormData.right = new FormAttachment(100, 0);
        comboVarFormData.top = new FormAttachment(lastControl, this.margin);
        comboVar.setLayoutData((Object)comboVarFormData);
        comboVar.setItems(items);
        return comboVar;
    }

    private List<String> createArgumentsUI(Object[] argumentDescriptors, List<String> currentValues) {
        this.logDebug("createArgumentsUI, currentValues = " + String.valueOf(currentValues == null ? "null" : Integer.valueOf(currentValues.size())));
        int argc = argumentDescriptors.length;
        ArrayList<String> newArguments = new ArrayList<String>(argc);
        Button lastControl = this.removeArgumentFieldsButton;
        String[] items = this.argumentSourceFields.getSelection() ? this.getFieldListForCombo() : this.emptyFieldList;
        for (int i = 0; i < argc; ++i) {
            Object[] argumentDescriptor = (Object[])argumentDescriptors[i];
            ComboVar comboVar = this.createArgumentUI(argumentDescriptor, (Control)lastControl, items);
            lastControl = comboVar;
            if (i >= currentValues.size()) continue;
            String argumentValue = currentValues.get(i);
            newArguments.add(i, argumentValue);
            if (argumentValue == null) continue;
            comboVar.setText(argumentValue);
        }
        return newArguments;
    }

    private void populateFieldsTable(Object[] methodDescriptor) {
        this.logDebug("populateFieldsTable 1");
        List<OutputField> outputFields = this.getOutputFields();
        this.outputFieldsTableView.clearAll();
        IValueMeta[] fields = (IValueMeta[])methodDescriptor[2];
        int n = fields.length;
        Table table = this.outputFieldsTableView.table;
        table.setItemCount(n);
        this.outputFieldsTableView.optWidth(true, n);
        int m = outputFields == null ? 0 : outputFields.size();
        block0: for (int i = 0; i < n; ++i) {
            IValueMeta field = fields[i];
            TableItem tableItem = table.getItem(i);
            String fieldName = field.getName();
            tableItem.setText(1, fieldName);
            tableItem.setText(2, fieldName);
            for (int j = 0; j < m; ++j) {
                OutputField outputField = outputFields.get(j);
                if (!fieldName.equals(outputField.getName())) continue;
                tableItem.setText(2, outputField.getRename());
                continue block0;
            }
        }
    }

    private void populateFieldsTable() {
        this.logDebug("populateFieldsTable 2");
        this.populateFieldsTable(JdbcMetadataMeta.getMethodDescriptor(this.methodCombo.getSelectionIndex()));
    }

    private void updateOutputFields(List<OutputField> outputFields) {
        this.logDebug("updateOutputFields " + String.valueOf(outputFields));
        if (outputFields == null) {
            return;
        }
        this.outputFieldsTableView.clearAll();
        int n = outputFields.size();
        Table table = this.outputFieldsTableView.table;
        table.setItemCount(n);
        for (int i = 0; i < n; ++i) {
            OutputField outputField = outputFields.get(i);
            TableItem tableItem = table.getItem(i);
            if (outputField == null) continue;
            String text = outputField.getName();
            tableItem.setText(1, text == null ? "" : text);
            if (outputField.getRename() == null) continue;
            text = outputField.getRename();
            tableItem.setText(2, text == null ? "" : text);
        }
    }

    private void methodUpdated(List<String> argumentValues) {
        this.logDebug("methodUpdated, argumentValues = " + String.valueOf(argumentValues == null ? "null" : Integer.valueOf(argumentValues.size())));
        List<String> currentValues = this.removeArgumentsUI();
        this.logDebug("currentValue = " + currentValues.size());
        if (argumentValues == null) {
            argumentValues = new ArrayList<String>(currentValues.size());
            currentValues.addAll(argumentValues);
        }
        int index = this.methodCombo.getSelectionIndex();
        Object[] methodDescriptor = (Object[])JdbcMetadataMeta.methodDescriptors[index];
        Object[] argumentDescriptors = (Object[])methodDescriptor[1];
        List<String> newArguments = this.createArgumentsUI(argumentDescriptors, argumentValues);
        this.input.setArguments(newArguments);
        this.metadataComposite.layout();
    }

    private void methodUpdated() {
        this.logDebug("Parameterless methodUpdated called.");
        this.methodUpdated(null);
    }

    public String open() {
        this.dialogChanged = false;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        this.changed = this.input.hasChanged();
        this.lsMod = e -> this.input.setChanged();
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JdbcMetadataDialog.this.input.setChanged();
            }
        };
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JdbcMetadata.Name", (String[])new String[0]));
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        this.wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(this.middle, -this.margin);
        this.fdlTransformName.top = new FormAttachment(0, this.margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(this.lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(this.middle, 0);
        this.fdTransformName.top = new FormAttachment(0, this.margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Button lastControl = this.wTransformName;
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)lastControl, this.input.getConnection(), this.lsMod);
        this.wConnection.addSelectionListener((SelectionListener)lsSelection);
        lastControl = this.wConnection;
        this.alwaysPassInputRowLabel = new Label((Composite)this.shell, 131072);
        this.alwaysPassInputRowLabel.setText(BaseMessages.getString(PKG, (String)"JdbcMetadata.passRow.Label", (String[])new String[0]));
        this.alwaysPassInputRowLabel.setToolTipText(BaseMessages.getString(PKG, (String)"JdbcMetadata.passRow.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.alwaysPassInputRowLabel);
        FormData alwaysPassInputRowLabelFormData = new FormData();
        alwaysPassInputRowLabelFormData.left = new FormAttachment(0, 0);
        alwaysPassInputRowLabelFormData.right = new FormAttachment(this.middle, -this.margin);
        alwaysPassInputRowLabelFormData.top = new FormAttachment(lastControl, this.margin);
        this.alwaysPassInputRowLabel.setLayoutData((Object)alwaysPassInputRowLabelFormData);
        this.alwaysPassInputRowButton = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.alwaysPassInputRowButton);
        FormData alwaysPassInputRowButtonFormData = new FormData();
        alwaysPassInputRowButtonFormData.left = new FormAttachment(this.middle, 0);
        alwaysPassInputRowButtonFormData.right = new FormAttachment(100, 0);
        alwaysPassInputRowButtonFormData.top = new FormAttachment(lastControl, this.margin);
        this.alwaysPassInputRowButton.setLayoutData((Object)alwaysPassInputRowButtonFormData);
        lastControl = this.alwaysPassInputRowButton;
        CTabFolder cTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)cTabFolder, (int)4);
        CTabItem metadataTab = new CTabItem(cTabFolder, 0);
        metadataTab.setText(BaseMessages.getString(PKG, (String)"JdbcMetadata.MetaDataTab.Label", (String[])new String[0]));
        metadataTab.setToolTipText(BaseMessages.getString(PKG, (String)"JdbcMetadata.MetaDataTab.Tooltip", (String[])new String[0]));
        FormLayout metadataTabLayout = new FormLayout();
        metadataTabLayout.marginWidth = 5;
        metadataTabLayout.marginHeight = 5;
        this.metadataComposite = new Composite((Composite)cTabFolder, 0);
        PropsUi.setLook((Widget)this.metadataComposite);
        this.metadataComposite.setLayout((Layout)metadataTabLayout);
        this.methodLabel = new Label(this.metadataComposite, 131072);
        this.methodLabel.setText(BaseMessages.getString(PKG, (String)"JdbcMetadata.metadataMethod.Label", (String[])new String[0]));
        this.methodLabel.setToolTipText(BaseMessages.getString(PKG, (String)"JdbcMetadata.metadataMethod.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.methodLabel);
        FormData methodLabelFormData = new FormData();
        methodLabelFormData.left = new FormAttachment(0, 0);
        methodLabelFormData.right = new FormAttachment(this.middle, -this.margin);
        methodLabelFormData.top = new FormAttachment(0, this.margin);
        this.methodLabel.setLayoutData((Object)methodLabelFormData);
        this.methodCombo = new Combo(this.metadataComposite, 18436);
        PropsUi.setLook((Widget)this.methodCombo);
        this.methodCombo.addModifyListener(this.lsMod);
        FormData methodComboFormData = new FormData();
        methodComboFormData.left = new FormAttachment(this.middle, 0);
        methodComboFormData.right = new FormAttachment(100, 0);
        methodComboFormData.top = new FormAttachment((Control)lastControl, this.margin);
        this.methodCombo.setLayoutData((Object)methodComboFormData);
        for (int i = 0; i < JdbcMetadataMeta.methodDescriptors.length; ++i) {
            Object[] methodDescriptor = (Object[])JdbcMetadataMeta.methodDescriptors[i];
            String methodName = (String)methodDescriptor[0];
            this.methodCombo.add(BaseMessages.getString(PKG, (String)("JdbcMetadata.methods." + methodName), (String[])new String[0]));
        }
        SelectionListener methodComboSelectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                JdbcMetadataDialog.this.logDebug("methodCombo changed, calling parameterless methodUpdated");
                JdbcMetadataDialog.this.methodUpdated();
                JdbcMetadataDialog.this.populateFieldsTable();
                JdbcMetadataDialog.this.input.setChanged();
            }
        };
        this.methodCombo.addSelectionListener(methodComboSelectionListener);
        lastControl = this.methodCombo;
        this.argumentSourceLabel = new Label(this.metadataComposite, 131072);
        this.argumentSourceLabel.setText(BaseMessages.getString(PKG, (String)"JdbcMetadata.argumentSource.Label", (String[])new String[0]));
        this.argumentSourceLabel.setToolTipText(BaseMessages.getString(PKG, (String)"JdbcMetadata.argumentSource.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.argumentSourceLabel);
        FormData argumentSourceLabelFormData = new FormData();
        argumentSourceLabelFormData.left = new FormAttachment(0, 0);
        argumentSourceLabelFormData.right = new FormAttachment(this.middle, -this.margin);
        argumentSourceLabelFormData.top = new FormAttachment((Control)lastControl, this.margin);
        this.argumentSourceLabel.setLayoutData((Object)argumentSourceLabelFormData);
        this.argumentSourceFields = new Button(this.metadataComposite, 32);
        PropsUi.setLook((Widget)this.argumentSourceFields);
        FormData argumentSourceFieldsFormData = new FormData();
        argumentSourceFieldsFormData.left = new FormAttachment(this.middle, 0);
        argumentSourceFieldsFormData.right = new FormAttachment(100, 0);
        argumentSourceFieldsFormData.top = new FormAttachment((Control)lastControl, this.margin);
        this.argumentSourceFields.setLayoutData((Object)argumentSourceFieldsFormData);
        SelectionListener argumentSourceFieldsSelectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                Control[] controls = JdbcMetadataDialog.this.metadataComposite.getChildren();
                boolean selection = JdbcMetadataDialog.this.argumentSourceFields.getSelection();
                JdbcMetadataDialog.this.removeArgumentFieldsButton.setSelection(selection);
                JdbcMetadataDialog.this.removeArgumentFieldsButton.setEnabled(selection);
                String[] items = selection ? JdbcMetadataDialog.this.getFieldListForCombo() : JdbcMetadataDialog.this.emptyFieldList;
                for (Control control : controls) {
                    if (!(control instanceof ComboVar)) continue;
                    ComboVar comboVar = (ComboVar)control;
                    comboVar.setItems(items);
                }
                JdbcMetadataDialog.this.input.setChanged();
            }
        };
        this.argumentSourceFields.addSelectionListener(argumentSourceFieldsSelectionListener);
        lastControl = this.argumentSourceFields;
        this.removeArgumentFieldsLabel = new Label(this.metadataComposite, 131072);
        this.removeArgumentFieldsLabel.setText(BaseMessages.getString(PKG, (String)"JdbcMetadata.removeArgumentFields.Label", (String[])new String[0]));
        this.removeArgumentFieldsLabel.setToolTipText(BaseMessages.getString(PKG, (String)"JdbcMetadata.removeArgumentFields.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.removeArgumentFieldsLabel);
        FormData removeArgumentFieldsLabelFormData = new FormData();
        removeArgumentFieldsLabelFormData.left = new FormAttachment(0, 0);
        removeArgumentFieldsLabelFormData.right = new FormAttachment(this.middle, -this.margin);
        removeArgumentFieldsLabelFormData.top = new FormAttachment((Control)lastControl, this.margin);
        this.removeArgumentFieldsLabel.setLayoutData((Object)removeArgumentFieldsLabelFormData);
        this.removeArgumentFieldsButton = new Button(this.metadataComposite, 32);
        PropsUi.setLook((Widget)this.removeArgumentFieldsButton);
        FormData removeArgumentFieldsButtonFormData = new FormData();
        removeArgumentFieldsButtonFormData.left = new FormAttachment(this.middle, 0);
        removeArgumentFieldsButtonFormData.right = new FormAttachment(100, 0);
        removeArgumentFieldsButtonFormData.top = new FormAttachment((Control)lastControl, this.margin);
        this.removeArgumentFieldsButton.setLayoutData((Object)removeArgumentFieldsButtonFormData);
        this.removeArgumentFieldsButton.addSelectionListener((SelectionListener)lsSelection);
        FormData metadataTabFormData = new FormData();
        metadataTabFormData.left = new FormAttachment(0, 0);
        metadataTabFormData.top = new FormAttachment(0, 0);
        metadataTabFormData.right = new FormAttachment(100, 0);
        metadataTabFormData.bottom = new FormAttachment(100, 0);
        this.metadataComposite.setLayoutData((Object)metadataTabFormData);
        this.metadataComposite.layout();
        metadataTab.setControl((Control)this.metadataComposite);
        CTabItem fieldsTab = new CTabItem(cTabFolder, 0);
        fieldsTab.setText(BaseMessages.getString(PKG, (String)"JdbcMetadata.FieldsTab.Label", (String[])new String[0]));
        fieldsTab.setToolTipText(BaseMessages.getString(PKG, (String)"JdbcMetadata.FieldsTab.Tooltip", (String[])new String[0]));
        FormLayout fieldsTabLayout = new FormLayout();
        fieldsTabLayout.marginWidth = 5;
        fieldsTabLayout.marginHeight = 5;
        Composite fieldsComposite = new Composite((Composite)cTabFolder, 0);
        PropsUi.setLook((Widget)fieldsComposite);
        fieldsComposite.setLayout((Layout)fieldsTabLayout);
        Label outputFieldsTableViewLabel = new Label(fieldsComposite, 0);
        outputFieldsTableViewLabel.setText(BaseMessages.getString(PKG, (String)"JdbcMetadata.FieldsTab.Label", (String[])new String[0]));
        outputFieldsTableViewLabel.setToolTipText(BaseMessages.getString(PKG, (String)"JdbcMetadata.FieldsTab.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)outputFieldsTableViewLabel);
        FormData outputFieldsTableViewLabelFormData = new FormData();
        outputFieldsTableViewLabelFormData.left = new FormAttachment(0, 0);
        outputFieldsTableViewLabelFormData.top = new FormAttachment(0, this.margin);
        outputFieldsTableViewLabel.setLayoutData((Object)outputFieldsTableViewLabelFormData);
        ColumnInfo[] columnInfo = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"JdbcMetadata.FieldName.Label", (String[])new String[0]), 0), new ColumnInfo(BaseMessages.getString(PKG, (String)"JdbcMetadata.OutputFieldName.Label", (String[])new String[0]), 1)};
        this.outputFieldsTableView = new TableView(this.variables, fieldsComposite, 68354, columnInfo, 10, this.lsMod, this.props);
        Button getFieldsButton = new Button(fieldsComposite, 8);
        getFieldsButton.setText(BaseMessages.getString(PKG, (String)"JdbcMetadata.getFieldsButton.Label", (String[])new String[0]));
        getFieldsButton.setToolTipText(BaseMessages.getString(PKG, (String)"JdbcMetadata.getFieldsButton.Tooltip", (String[])new String[0]));
        FormData getFieldsButtonFormData = new FormData();
        getFieldsButtonFormData.top = new FormAttachment((Control)outputFieldsTableViewLabel, this.margin);
        getFieldsButtonFormData.right = new FormAttachment(100, 0);
        getFieldsButton.setLayoutData((Object)getFieldsButtonFormData);
        getFieldsButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                JdbcMetadataDialog.this.populateFieldsTable();
                JdbcMetadataDialog.this.input.setChanged();
            }
        });
        FormData outputFieldsTableViewFormData = new FormData();
        outputFieldsTableViewFormData.left = new FormAttachment(0, 0);
        outputFieldsTableViewFormData.top = new FormAttachment((Control)outputFieldsTableViewLabel, this.margin);
        outputFieldsTableViewFormData.right = new FormAttachment((Control)getFieldsButton, -this.margin);
        outputFieldsTableViewFormData.bottom = new FormAttachment(100, -2 * this.margin);
        this.outputFieldsTableView.setLayoutData((Object)outputFieldsTableViewFormData);
        FormData fieldsTabFormData = new FormData();
        fieldsTabFormData.left = new FormAttachment(0, 0);
        fieldsTabFormData.top = new FormAttachment(0, 0);
        fieldsTabFormData.right = new FormAttachment(100, 0);
        fieldsTabFormData.bottom = new FormAttachment(100, 0);
        fieldsComposite.setLayoutData((Object)metadataTabFormData);
        fieldsComposite.layout();
        fieldsTab.setControl((Control)fieldsComposite);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, this.margin, null);
        FormData cTabFolderFormData = new FormData();
        cTabFolderFormData.left = new FormAttachment(0, 0);
        cTabFolderFormData.top = new FormAttachment((Control)this.alwaysPassInputRowButton, this.margin);
        cTabFolderFormData.right = new FormAttachment(100, 0);
        cTabFolderFormData.bottom = new FormAttachment((Control)this.wOk, -this.margin);
        cTabFolder.setLayoutData((Object)cTabFolderFormData);
        cTabFolder.setSelection(0);
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel.addListener(13, e -> this.cancel());
        this.setSize();
        this.populateDialog();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void setMethod(String method) {
        int index = JdbcMetadataMeta.getMethodDescriptorIndex(method);
        if (index == -1) {
            throw new IllegalArgumentException("Index for method " + method + " is -1.");
        }
        this.methodCombo.select(index);
        this.logDebug("setMethod called, calling parameterless method updated");
    }

    private void populateDialog() {
        this.wTransformName.selectAll();
        String value = this.input.getConnection();
        if (value != null) {
            this.wConnection.setText(value);
        }
        this.alwaysPassInputRowButton.setSelection(this.input.isAlwaysPassInputRow());
        value = this.input.getMethodName();
        if (value != null) {
            this.setMethod(value);
        }
        this.argumentSourceFields.setSelection(this.input.isArgumentSourceFields());
        if (!Utils.isEmpty(this.input.getArguments())) {
            this.methodUpdated(this.input.getArguments());
        } else {
            this.methodUpdated();
        }
        this.logDebug("Calling methodUpdated from populate dialog.");
        if (!Utils.isEmpty(this.input.getOutputFields())) {
            this.updateOutputFields(this.input.getOutputFields());
        }
        this.removeArgumentFieldsButton.setSelection(this.input.isRemoveArgumentFields());
        this.removeArgumentFieldsButton.setEnabled(this.input.isArgumentSourceFields());
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        this.transformName = this.wTransformName.getText();
        this.input.setConnection(this.wConnection.getText());
        this.input.setAlwaysPassInputRow(this.alwaysPassInputRowButton.getSelection());
        this.input.setMethodName(JdbcMetadataMeta.getMethodName(this.methodCombo.getSelectionIndex()));
        this.input.setArgumentSourceFields(this.argumentSourceFields.getSelection());
        this.input.setArguments(this.getArguments());
        this.input.setRemoveArgumentFields(this.removeArgumentFieldsButton.getSelection());
        this.input.setOutputFields(this.getOutputFields());
        this.dispose();
    }

    private List<String> getArguments() {
        Control[] controls;
        ArrayList<String> arguments = new ArrayList<String>();
        for (Control control : controls = this.metadataComposite.getChildren()) {
            if (!(control instanceof ComboVar)) continue;
            ComboVar comboVar = (ComboVar)control;
            String text = comboVar.getText();
            arguments.add(text);
        }
        return arguments;
    }

    private List<OutputField> getOutputFields() {
        Table table = this.outputFieldsTableView.table;
        ArrayList<OutputField> outputFields = new ArrayList<OutputField>();
        for (int i = 0; i < table.getItemCount(); ++i) {
            TableItem tableItem = table.getItem(i);
            OutputField item = new OutputField(tableItem.getText(1), tableItem.getText(2));
            outputFields.add(i, item);
        }
        return outputFields;
    }
}

