/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.metadata.util;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.json.JsonMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;

public class HopMetadataUtil {
    public static final MultiMetadataProvider getStandardHopMetadataProvider(IVariables variables) {
        String[] folders;
        String foldersValue = variables.getVariable("HOP_METADATA_FOLDER");
        if (StringUtils.isEmpty((String)foldersValue)) {
            Object configDirectory = Const.HOP_CONFIG_FOLDER;
            if (!((String)configDirectory).endsWith(Const.FILE_SEPARATOR)) {
                configDirectory = (String)configDirectory + Const.FILE_SEPARATOR;
            }
            folders = new String[]{(String)configDirectory + "metadata"};
        } else {
            folders = foldersValue.split(",");
            for (int i = 0; i < folders.length; ++i) {
                folders[i] = Const.trim(folders[i]);
            }
        }
        ArrayList<IHopMetadataProvider> providers = new ArrayList<IHopMetadataProvider>();
        for (String folder : folders) {
            JsonMetadataProvider provider = new JsonMetadataProvider(Encr.getEncoder(), folder, variables);
            providers.add(provider);
        }
        return new MultiMetadataProvider(Encr.getEncoder(), providers, variables);
    }

    public static <T extends IHopMetadata> HopMetadata getHopMetadataAnnotation(Class<T> managedClass) {
        return managedClass.getAnnotation(HopMetadata.class);
    }

    public static String[] getHopMetadataKeys(IHopMetadataProvider provider) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Class metadataClass : provider.getMetadataClasses()) {
            HopMetadata hopMetadata = HopMetadataUtil.getHopMetadataAnnotation(metadataClass);
            keys.add(hopMetadata.key());
        }
        Collections.sort(keys);
        return keys.toArray(new String[0]);
    }
}

