/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.avro.schemas.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import org.apache.avro.Conversion;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class AvroJavaTimeConversions {
    private static final @UnknownKeyFor @NonNull @Initialized String LOCAL_TIMESTAMP_MILLIS = "local-timestamp-millis";
    private static final @UnknownKeyFor @NonNull @Initialized String LOCAL_TIMESTAMP_MICROS = "local-timestamp-micros";

    public static class LocalTimestampMicrosConversion
    extends Conversion<LocalDateTime> {
        private final @UnknownKeyFor @NonNull @Initialized TimestampMicrosConversion timestampMicrosConversion = new TimestampMicrosConversion();

        public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized LocalDateTime> getConvertedType() {
            return LocalDateTime.class;
        }

        public @UnknownKeyFor @NonNull @Initialized String getLogicalTypeName() {
            return AvroJavaTimeConversions.LOCAL_TIMESTAMP_MICROS;
        }

        public @UnknownKeyFor @NonNull @Initialized LocalDateTime fromLong(@UnknownKeyFor @NonNull @Initialized Long microsFromEpoch, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            Instant instant = this.timestampMicrosConversion.fromLong(microsFromEpoch, schema, type);
            return LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        }

        public @UnknownKeyFor @NonNull @Initialized Long toLong(@UnknownKeyFor @NonNull @Initialized LocalDateTime timestamp, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            Instant instant = timestamp.toInstant(ZoneOffset.UTC);
            return this.timestampMicrosConversion.toLong(instant, schema, type);
        }

        public @UnknownKeyFor @NonNull @Initialized Schema getRecommendedSchema() {
            return new LocalTimestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        }
    }

    public static class LocalTimestampMillisConversion
    extends Conversion<LocalDateTime> {
        private final @UnknownKeyFor @NonNull @Initialized TimestampMillisConversion timestampMillisConversion = new TimestampMillisConversion();

        public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized LocalDateTime> getConvertedType() {
            return LocalDateTime.class;
        }

        public @UnknownKeyFor @NonNull @Initialized String getLogicalTypeName() {
            return AvroJavaTimeConversions.LOCAL_TIMESTAMP_MILLIS;
        }

        public @UnknownKeyFor @NonNull @Initialized LocalDateTime fromLong(@UnknownKeyFor @NonNull @Initialized Long millisFromEpoch, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            Instant instant = this.timestampMillisConversion.fromLong(millisFromEpoch, schema, type);
            return LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        }

        public @UnknownKeyFor @NonNull @Initialized Long toLong(@UnknownKeyFor @NonNull @Initialized LocalDateTime timestamp, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            Instant instant = timestamp.toInstant(ZoneOffset.UTC);
            return this.timestampMillisConversion.toLong(instant, schema, type);
        }

        public @UnknownKeyFor @NonNull @Initialized Schema getRecommendedSchema() {
            return new LocalTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        }
    }

    public static class TimestampMicrosConversion
    extends Conversion<Instant> {
        public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized Instant> getConvertedType() {
            return Instant.class;
        }

        public @UnknownKeyFor @NonNull @Initialized String getLogicalTypeName() {
            return "timestamp-micros";
        }

        public @UnknownKeyFor @NonNull @Initialized Instant fromLong(@UnknownKeyFor @NonNull @Initialized Long microsFromEpoch, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            long epochSeconds = microsFromEpoch / 1000000L;
            long nanoAdjustment = microsFromEpoch % 1000000L * 1000L;
            return Instant.ofEpochSecond(epochSeconds, nanoAdjustment);
        }

        public @UnknownKeyFor @NonNull @Initialized Long toLong(@UnknownKeyFor @NonNull @Initialized Instant instant, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            long seconds = instant.getEpochSecond();
            int nanos = instant.getNano();
            if (seconds < 0L && nanos > 0) {
                long micros = Math.multiplyExact(seconds + 1L, 1000000L);
                long adjustment = (long)nanos / 1000L - 1000000L;
                return Math.addExact(micros, adjustment);
            }
            long micros = Math.multiplyExact(seconds, 1000000L);
            return Math.addExact(micros, (long)nanos / 1000L);
        }

        public @UnknownKeyFor @NonNull @Initialized Schema getRecommendedSchema() {
            return LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        }
    }

    public static class TimestampMillisConversion
    extends Conversion<Instant> {
        public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized Instant> getConvertedType() {
            return Instant.class;
        }

        public @UnknownKeyFor @NonNull @Initialized String getLogicalTypeName() {
            return "timestamp-millis";
        }

        public @UnknownKeyFor @NonNull @Initialized Instant fromLong(@UnknownKeyFor @NonNull @Initialized Long millisFromEpoch, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            return Instant.ofEpochMilli(millisFromEpoch);
        }

        public @UnknownKeyFor @NonNull @Initialized Long toLong(@UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            return timestamp.toEpochMilli();
        }

        public @UnknownKeyFor @NonNull @Initialized Schema getRecommendedSchema() {
            return LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        }
    }

    public static class TimeMicrosConversion
    extends Conversion<LocalTime> {
        public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized LocalTime> getConvertedType() {
            return LocalTime.class;
        }

        public @UnknownKeyFor @NonNull @Initialized String getLogicalTypeName() {
            return "time-micros";
        }

        public @UnknownKeyFor @NonNull @Initialized LocalTime fromLong(@UnknownKeyFor @NonNull @Initialized Long microsFromMidnight, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            return LocalTime.ofNanoOfDay(TimeUnit.MICROSECONDS.toNanos(microsFromMidnight));
        }

        public @UnknownKeyFor @NonNull @Initialized Long toLong(@UnknownKeyFor @NonNull @Initialized LocalTime time, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            return TimeUnit.NANOSECONDS.toMicros(time.toNanoOfDay());
        }

        public @UnknownKeyFor @NonNull @Initialized Schema getRecommendedSchema() {
            return LogicalTypes.timeMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        }
    }

    public static class TimeMillisConversion
    extends Conversion<LocalTime> {
        public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized LocalTime> getConvertedType() {
            return LocalTime.class;
        }

        public @UnknownKeyFor @NonNull @Initialized String getLogicalTypeName() {
            return "time-millis";
        }

        public @UnknownKeyFor @NonNull @Initialized LocalTime fromInt(@UnknownKeyFor @NonNull @Initialized Integer millisFromMidnight, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            return LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(millisFromMidnight.intValue()));
        }

        public @UnknownKeyFor @NonNull @Initialized Integer toInt(@UnknownKeyFor @NonNull @Initialized LocalTime time, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            return (int)TimeUnit.NANOSECONDS.toMillis(time.toNanoOfDay());
        }

        public @UnknownKeyFor @NonNull @Initialized Schema getRecommendedSchema() {
            return LogicalTypes.timeMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        }
    }

    public static class DateConversion
    extends Conversion<LocalDate> {
        public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized LocalDate> getConvertedType() {
            return LocalDate.class;
        }

        public @UnknownKeyFor @NonNull @Initialized String getLogicalTypeName() {
            return "date";
        }

        public @UnknownKeyFor @NonNull @Initialized LocalDate fromInt(@UnknownKeyFor @NonNull @Initialized Integer daysFromEpoch, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            return LocalDate.ofEpochDay(daysFromEpoch.intValue());
        }

        public @UnknownKeyFor @NonNull @Initialized Integer toInt(@UnknownKeyFor @NonNull @Initialized LocalDate date, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized LogicalType type) {
            long epochDays = date.toEpochDay();
            return (int)epochDays;
        }

        public @UnknownKeyFor @NonNull @Initialized Schema getRecommendedSchema() {
            return LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        }
    }

    public static class LocalTimestampMicros
    extends LogicalType {
        private LocalTimestampMicros() {
            super(AvroJavaTimeConversions.LOCAL_TIMESTAMP_MICROS);
        }

        public void validate(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            super.validate(schema);
            if (schema.getType() != Schema.Type.LONG) {
                throw new IllegalArgumentException("Local timestamp (micros) can only be used with an underlying long type");
            }
        }
    }

    public static class LocalTimestampMillis
    extends LogicalType {
        private LocalTimestampMillis() {
            super(AvroJavaTimeConversions.LOCAL_TIMESTAMP_MILLIS);
        }

        public void validate(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            super.validate(schema);
            if (schema.getType() != Schema.Type.LONG) {
                throw new IllegalArgumentException("Local timestamp (millis) can only be used with an underlying long type");
            }
        }
    }
}

