/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import com.amazonaws.services.dynamodbv2.util.LockClientUtils;
import java.util.Optional;

final class SessionMonitor {
    private final long safeTimeWithoutHeartbeatMillis;
    private final Optional<Runnable> callback;

    public SessionMonitor(long safeTimeWithoutHeartbeatMillis, Optional<Runnable> callback) {
        this.safeTimeWithoutHeartbeatMillis = safeTimeWithoutHeartbeatMillis;
        this.callback = callback;
    }

    public boolean isLeaseEnteringDangerZone(long lastAbsoluteTimeUpdatedMillis) {
        return this.millisecondsUntilLeaseEntersDangerZone(lastAbsoluteTimeUpdatedMillis) <= 0L;
    }

    long millisecondsUntilLeaseEntersDangerZone(long lastAbsoluteTimeUpdatedMillis) {
        return lastAbsoluteTimeUpdatedMillis + this.safeTimeWithoutHeartbeatMillis - LockClientUtils.INSTANCE.millisecondTime();
    }

    public void runCallback() {
        if (this.callback.isPresent()) {
            Thread t = new Thread(this.callback.get());
            t.setDaemon(true);
            t.start();
        }
    }

    public boolean hasCallback() {
        return this.callback != null;
    }

    public long getSafeTimeMillis() {
        return this.safeTimeWithoutHeartbeatMillis;
    }
}

