/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.explorer.config;

import org.apache.hop.core.config.plugin.ConfigPlugin;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.IGuiPluginCompositeWidgetsListener;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.perspective.explorer.config.ExplorerPerspectiveConfig;
import org.apache.hop.ui.hopgui.perspective.explorer.config.ExplorerPerspectiveConfigSingleton;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import picocli.CommandLine;

@ConfigPlugin(id="ExplorerPerspectiveConfigPlugin", description="Configuration options for the explorer perspective", category="config")
@GuiPlugin(description="Explorer Perspective")
public class ExplorerPerspectiveConfigPlugin
implements IConfigOptions,
IGuiPluginCompositeWidgetsListener {
    private static final String WIDGET_ID_LAZY_LOADING_DEPTH = "10000-lazy-loading-depth";
    private static final String WIDGET_ID_FILE_LOADING_MAX_SIZE = "10100-file-loading-max-size";
    private static final String WIDGET_ID_FILE_EXPLORER_VISIBLE_BY_DEFAULT = "10200-file-explorer-visible-by-default";
    private static final String WIDGET_ID_OPEN_HELP_FILES = "10300-open-help-files";
    @GuiWidgetElement(id="10000-lazy-loading-depth", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, label="i18n::ExplorerPerspectiveConfig.LazyLoading.Label", toolTip="i18n::ExplorerPerspectiveConfig.LazyLoading.Tooltip")
    @CommandLine.Option(names={"-exid", "--explorer-lazy-loading-initial-depth"}, description={"For the explorer perspective: the initial depth to load not lazily"})
    private String lazyLoadingDepth;
    @GuiWidgetElement(id="10100-file-loading-max-size", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, label="i18n::ExplorerPerspectiveConfig.FileSize.Label", toolTip="i18n::ExplorerPerspectiveConfig.FileSize.Tooltip")
    @CommandLine.Option(names={"-exms", "--explorer-file-loading-max-size"}, description={"For the explorer: the maximum file size to load"})
    private String fileLoadingMaxSize;
    @GuiWidgetElement(id="10200-file-explorer-visible-by-default", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.CHECKBOX, label="i18n::ExplorerPerspectiveConfig.FileExplorerVisible.Label", toolTip="i18n::ExplorerPerspectiveConfig.FileExplorerVisible.Tooltip")
    @CommandLine.Option(names={"-exv", "--explorer-file-explorer-visible-by-default"}, description={"Show the file explorer panel by default in the explorer perspective"})
    private Boolean fileExplorerVisibleByDefault = true;
    @GuiWidgetElement(id="10300-open-help-files", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.CHECKBOX, label="i18n::ExplorerPerspectiveConfig.OpenHelpFiles.Label", toolTip="i18n::ExplorerPerspectiveConfig.OpenHelpFiles.Tooltip")
    @CommandLine.Option(names={"-oh", "--open-help-in-tabs"}, description={"Open help files in Hop GUI tabs instead of external browser"})
    private Boolean openingHelpFiles;

    public static ExplorerPerspectiveConfigPlugin getInstance() {
        ExplorerPerspectiveConfigPlugin instance = new ExplorerPerspectiveConfigPlugin();
        ExplorerPerspectiveConfig config = ExplorerPerspectiveConfigSingleton.getConfig();
        instance.lazyLoadingDepth = config.getLazyLoadingDepth();
        instance.fileLoadingMaxSize = config.getFileLoadingMaxSize();
        Boolean visibleByDefault = config.getFileExplorerVisibleByDefault();
        instance.fileExplorerVisibleByDefault = visibleByDefault != null ? visibleByDefault : true;
        instance.openingHelpFiles = config.isOpeningHelpFiles();
        return instance;
    }

    public boolean handleOption(ILogChannel log, IHasHopMetadataProvider hasHopMetadataProvider, IVariables variables) throws HopException {
        ExplorerPerspectiveConfig config = ExplorerPerspectiveConfigSingleton.getConfig();
        try {
            boolean changed = false;
            if (this.lazyLoadingDepth != null) {
                config.setLazyLoadingDepth(this.lazyLoadingDepth);
                log.logBasic("Explorer perspective: the lazy loading depth is set to '" + this.lazyLoadingDepth + "'");
                changed = true;
            }
            if (this.fileLoadingMaxSize != null) {
                config.setFileLoadingMaxSize(this.fileLoadingMaxSize);
                log.logBasic("Explorer perspective: the file loading maximum size (in MB) is set to '" + this.fileLoadingMaxSize + "'");
                changed = true;
            }
            if (this.fileExplorerVisibleByDefault != null) {
                config.setFileExplorerVisibleByDefault(this.fileExplorerVisibleByDefault);
                log.logBasic("Explorer perspective: file explorer visible by default is set to '" + this.fileExplorerVisibleByDefault + "'");
                changed = true;
            }
            if (this.openingHelpFiles != null) {
                config.setOpeningHelpFiles(this.openingHelpFiles);
                log.logBasic("Explorer perspective: open help files in tabs is set to '" + this.openingHelpFiles + "'");
                changed = true;
            }
            if (changed) {
                ExplorerPerspectiveConfigSingleton.saveConfig();
            }
            return changed;
        }
        catch (Exception e) {
            throw new HopException("Error handling explorer perspective configuration options", (Throwable)e);
        }
    }

    @Override
    public void widgetsCreated(GuiCompositeWidgets compositeWidgets) {
    }

    @Override
    public void widgetsPopulated(GuiCompositeWidgets compositeWidgets) {
    }

    @Override
    public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
        this.persistContents(compositeWidgets);
    }

    @Override
    public void persistContents(GuiCompositeWidgets compositeWidgets) {
        for (String widgetId : compositeWidgets.getWidgetsMap().keySet()) {
            Control control = compositeWidgets.getWidgetsMap().get(widgetId);
            switch (widgetId) {
                case "10000-lazy-loading-depth": {
                    this.lazyLoadingDepth = ((TextVar)control).getText();
                    ExplorerPerspectiveConfigSingleton.getConfig().setLazyLoadingDepth(this.lazyLoadingDepth);
                    break;
                }
                case "10100-file-loading-max-size": {
                    this.fileLoadingMaxSize = ((TextVar)control).getText();
                    ExplorerPerspectiveConfigSingleton.getConfig().setFileLoadingMaxSize(this.fileLoadingMaxSize);
                    break;
                }
                case "10200-file-explorer-visible-by-default": {
                    this.fileExplorerVisibleByDefault = ((Button)control).getSelection();
                    ExplorerPerspectiveConfigSingleton.getConfig().setFileExplorerVisibleByDefault(this.fileExplorerVisibleByDefault);
                    break;
                }
                case "10300-open-help-files": {
                    this.openingHelpFiles = ((Button)control).getSelection();
                    ExplorerPerspectiveConfigSingleton.getConfig().setOpeningHelpFiles(this.openingHelpFiles);
                    break;
                }
            }
        }
        try {
            ExplorerPerspectiveConfigSingleton.saveConfig();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), "Error", "Error saving option", e);
        }
    }

    public String getLazyLoadingDepth() {
        return this.lazyLoadingDepth;
    }

    public void setLazyLoadingDepth(String lazyLoadingDepth) {
        this.lazyLoadingDepth = lazyLoadingDepth;
    }

    public String getFileLoadingMaxSize() {
        return this.fileLoadingMaxSize;
    }

    public void setFileLoadingMaxSize(String fileLoadingMaxSize) {
        this.fileLoadingMaxSize = fileLoadingMaxSize;
    }

    public Boolean getFileExplorerVisibleByDefault() {
        return this.fileExplorerVisibleByDefault != null ? this.fileExplorerVisibleByDefault : true;
    }

    public void setFileExplorerVisibleByDefault(Boolean fileExplorerVisibleByDefault) {
        this.fileExplorerVisibleByDefault = fileExplorerVisibleByDefault;
    }

    public Boolean isOpeningHelpFiles() {
        return this.openingHelpFiles != null ? this.openingHelpFiles : false;
    }

    public void setOpeningHelpFiles(Boolean openingHelpFiles) {
        this.openingHelpFiles = openingHelpFiles;
    }
}

