/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hadoop;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@NotThreadSafe
public class SerializableConfiguration
implements Externalizable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 0L;
    private transient @UnknownKeyFor @NonNull @Initialized Configuration conf;
    private transient @UnknownKeyFor @NonNull @Initialized boolean confMutated;
    private transient @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] serializationCache;

    public SerializableConfiguration() {
    }

    public SerializableConfiguration(@UnknownKeyFor @NonNull @Initialized Configuration conf) {
        this.conf = Objects.requireNonNull(conf, "Configuration must not be null.");
    }

    public @UnknownKeyFor @NonNull @Initialized Configuration get() {
        this.confMutated = true;
        return this.conf;
    }

    @Override
    public void writeExternal(@UnknownKeyFor @NonNull @Initialized ObjectOutput out) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.confMutated || this.serializationCache == null) {
            this.confMutated = false;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
            try (DataOutputStream dos = new DataOutputStream(baos);){
                this.conf.write((DataOutput)dos);
                this.serializationCache = baos.toByteArray();
            }
        }
        out.writeUTF(this.conf.getClass().getCanonicalName());
        out.write(this.serializationCache);
    }

    @Override
    public void readExternal(@UnknownKeyFor @NonNull @Initialized ObjectInput in) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
        this.confMutated = true;
        String className = in.readUTF();
        try {
            this.conf = Class.forName(className).asSubclass(Configuration.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.conf.readFields((DataInput)in);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IOException("Unable to create configuration: " + e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized Job newJob(@Nullable @UnknownKeyFor @Initialized SerializableConfiguration conf) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (conf == null) {
            return Job.getInstance();
        }
        Job job = Job.getInstance((Configuration)new Configuration(false));
        for (Map.Entry entry : conf.get()) {
            job.getConfiguration().set((String)entry.getKey(), (String)entry.getValue());
        }
        return job;
    }

    public static @UnknownKeyFor @NonNull @Initialized SerializableConfiguration fromMap(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> entries) {
        Configuration hadoopConfiguration = new Configuration();
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            hadoopConfiguration.set(entry.getKey(), entry.getValue());
        }
        return new SerializableConfiguration(hadoopConfiguration);
    }

    public static @UnknownKeyFor @NonNull @Initialized Configuration newConfiguration(@Nullable @UnknownKeyFor @Initialized SerializableConfiguration conf) {
        if (conf == null) {
            return new Configuration();
        }
        return conf.get();
    }
}

