/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.access;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;

@DatabaseMetaPlugin(type="MSACCESS", typeDescription="Microsoft Access database", image="microsoft-access.svg", documentationUrl="/database/databases/access.html", classLoaderGroup="access-db")
@GuiPlugin(id="GUI-MSAccessDatabaseMeta")
public class AccessDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public String getDriverClass() {
        return "net.ucanaccess.jdbc.UcanaccessDriver";
    }

    public String getURL(String hostname, String port, String database) {
        return "jdbc:ucanaccess://" + database + ";showSchema=true";
    }

    public String getExtraOptionsHelpText() {
        return "http://ucanaccess.sourceforge.net/site.html#examples";
    }

    public void addDefaultOptions() {
        this.addExtraOption(this.getPluginId(), "newDatabaseVersion", "V2010");
        this.setSupportsBooleanDataType(true);
        this.setSupportsTimestampDataType(true);
    }

    public int getNotFoundTK(boolean useAutoinc) {
        if (this.isSupportsAutoInc() && useAutoinc) {
            return 0;
        }
        return super.getNotFoundTK(useAutoinc);
    }

    public String getSchemaTableCombination(String schemaName, String tablePart) {
        return tablePart;
    }

    public String getTruncateTableStatement(String tableName) {
        return "DELETE FROM " + tableName;
    }

    public String getDropColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoIncrement, String pk, boolean semicolon) {
        return "-- Drop not supported\n-- ALTER TABLE " + tableName + " DROP " + v.getName();
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ADD " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ALTER COLUMN " + v.getName() + " SET " + this.getFieldDefinition(v, tk, pk, useAutoinc, false, false);
    }

    public String getFieldDefinition(IValueMeta valueMeta, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        Object retval = "";
        if (addFieldName) {
            retval = (String)retval + valueMeta.getName() + " ";
        }
        switch (valueMeta.getType()) {
            case 3: 
            case 9: {
                retval = (String)retval + "DATETIME";
                break;
            }
            case 4: {
                retval = (String)retval + "YESNO";
                break;
            }
            case 5: {
                if (tk.equals(valueMeta.getName())) {
                    retval = (String)retval + "AUTOINCREMENT";
                    break;
                }
                retval = (String)retval + "LONG";
                break;
            }
            case 1: {
                retval = (String)retval + "DOUBLE";
                break;
            }
            case 6: {
                retval = (String)retval + "NUMERIC";
                break;
            }
            case 2: {
                if (valueMeta.getLength() > this.getMaxVARCHARLength()) {
                    retval = (String)retval + "MEMO";
                    break;
                }
                retval = (String)retval + "TEXT";
                break;
            }
            default: {
                retval = (String)retval + " UNKNOWN";
            }
        }
        if (addCr) {
            retval = (String)retval + Const.CR;
        }
        return retval;
    }

    public String[] getReservedWords() {
        return new String[]{"AND", "ANY", "AS", "ALL", "AT", "AVG", "BETWEEN", "BOTH", "BY", "CALL", "CASE", "CAST", "COALESCE", "CONSTRAINT", "CORRESPONDING", "CONVERT", "COUNT", "CREATE", "CROSS", "DEFAULT", "DISTINCT", "DO", "DROP", "ELSE", "EVERY", "EXISTS", "EXCEPT", "FOR", "FROM", "FULL", "GRANT", "GROUP", "HAVING", "IN", "INNER", "INTERSECT", "INTO", "IS", "JOIN", "LEFT", "LEADING", "LIKE", "MAX", "MIN", "NATURAL", "NOT", "NULLIF", "ON", "ORDER", "OR", "OUTER", "PRIMARY", "REFERENCES", "RIGHT", "SELECT", "SET", "SOME", "STDDEV_POP", "STDDEV_SAMP", "SUM", "TABLE", "THEN", "TO", "TRAILING", "TRIGGER", "UNION", "UNIQUE", "USING", "USER", "VALUES", "VAR_POP", "VAR_SAMP", "WHEN", "WHERE", "WITH", "END"};
    }

    public int getMaxVARCHARLength() {
        return 255;
    }

    public int getMaxTextFieldLength() {
        return 0x7FFFFF;
    }

    public String getSqlListOfSchemas() {
        return "SELECT SCHEMA_NAME AS \"name\" FROM INFORMATION_SCHEMA.SCHEMATA";
    }

    public boolean isFetchSizeSupported() {
        return false;
    }

    public boolean isSupportsBitmapIndex() {
        return false;
    }

    public boolean isSupportsBatchUpdates() {
        return false;
    }

    public boolean isSupportsCatalogs() {
        return false;
    }

    public boolean isSupportsSchemas() {
        return false;
    }

    public boolean isSupportsSynonyms() {
        return false;
    }

    public boolean isSupportsSequences() {
        return false;
    }

    public boolean isSupportsErrorHandling() {
        return false;
    }

    public boolean isSupportsFloatRoundingOnUpdate() {
        return false;
    }
}

