/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.metadata.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.RelationMetadata;
import com.datastax.oss.driver.internal.core.metadata.schema.ScriptBuilder;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.RelationParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Optional;

public interface ViewMetadata
extends RelationMetadata {
    @NonNull
    public CqlIdentifier getBaseTable();

    public boolean includesAllColumns();

    @NonNull
    public Optional<String> getWhereClause();

    @Override
    @NonNull
    default public String describe(boolean pretty) {
        ScriptBuilder builder = new ScriptBuilder(pretty).append("CREATE MATERIALIZED VIEW ").append(this.getKeyspace()).append(".").append(this.getName()).append(" AS").newLine();
        builder.append("SELECT");
        if (this.includesAllColumns()) {
            builder.append(" * ");
        } else {
            builder.newLine().increaseIndent();
            boolean first = true;
            for (ColumnMetadata columnMetadata : this.getColumns().values()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(",").newLine();
                }
                builder.append(columnMetadata.getName());
            }
            builder.newLine().decreaseIndent();
        }
        builder.append("FROM ").append(this.getKeyspace()).append(".").append(this.getBaseTable());
        Optional<String> whereClause = this.getWhereClause();
        if (whereClause.isPresent() && !whereClause.get().isEmpty()) {
            builder.newLine().append("WHERE ").append(whereClause.get());
        }
        builder.newLine().append("PRIMARY KEY (");
        if (this.getPartitionKey().size() == 1) {
            builder.append(this.getPartitionKey().get(0).getName());
        } else {
            builder.append("(");
            boolean first = true;
            for (ColumnMetadata pkColumn : this.getPartitionKey()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(pkColumn.getName());
            }
            builder.append(")");
        }
        for (ColumnMetadata columnMetadata : this.getClusteringColumns().keySet()) {
            builder.append(", ").append(columnMetadata.getName());
        }
        builder.append(")").increaseIndent();
        RelationParser.appendOptions(this.getOptions(), builder);
        return builder.append(";").build();
    }

    @Override
    @NonNull
    default public String describeWithChildren(boolean pretty) {
        return this.describe(pretty);
    }
}

