/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.timestamps;

import java.time.Duration;
import org.apache.flink.streaming.api.functions.AssignerWithPeriodicWatermarks;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.api.windowing.time.Time;

public abstract class BoundedOutOfOrdernessTimestampExtractor<T>
implements AssignerWithPeriodicWatermarks<T> {
    private static final long serialVersionUID = 1L;
    private long currentMaxTimestamp;
    private long lastEmittedWatermark = Long.MIN_VALUE;
    private final long maxOutOfOrderness;

    @Deprecated
    public BoundedOutOfOrdernessTimestampExtractor(Time maxOutOfOrderness) {
        this(maxOutOfOrderness.toDuration());
    }

    public BoundedOutOfOrdernessTimestampExtractor(Duration maxOutOfOrderness) {
        if (maxOutOfOrderness.isNegative()) {
            throw new IllegalArgumentException(String.format("Tried to set the maximum allowed lateness to %s. This parameter cannot be negative.", maxOutOfOrderness));
        }
        this.maxOutOfOrderness = maxOutOfOrderness.toMillis();
        this.currentMaxTimestamp = Long.MIN_VALUE + this.maxOutOfOrderness;
    }

    public long getMaxOutOfOrdernessInMillis() {
        return this.maxOutOfOrderness;
    }

    public abstract long extractTimestamp(T var1);

    @Override
    public final Watermark getCurrentWatermark() {
        long potentialWM = this.currentMaxTimestamp - this.maxOutOfOrderness;
        if (potentialWM >= this.lastEmittedWatermark) {
            this.lastEmittedWatermark = potentialWM;
        }
        return new Watermark(this.lastEmittedWatermark);
    }

    @Override
    public final long extractTimestamp(T element, long previousElementTimestamp) {
        long timestamp = this.extractTimestamp(element);
        if (timestamp > this.currentMaxTimestamp) {
            this.currentMaxTimestamp = timestamp;
        }
        return timestamp;
    }
}

