/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.main;

import java.io.PrintWriter;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.queue.internal.main.InternalReaderMain;
import net.openhft.chronicle.queue.reader.HistoryReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;

public class InternalHistoryMain {
    public static void main(@NotNull String[] args) {
        new InternalHistoryMain().run(args);
    }

    public void run(String[] args) {
        Options options = this.options();
        CommandLine commandLine = this.parseCommandLine(args, options);
        HistoryReader chronicleHistoryReader = this.chronicleHistoryReader();
        this.setup(commandLine, chronicleHistoryReader);
        chronicleHistoryReader.execute();
    }

    protected void setup(CommandLine commandLine, HistoryReader chronicleHistoryReader) {
        chronicleHistoryReader.withMessageSink(System.out::println).withProgress(commandLine.hasOption('p')).withHistosByMethod(commandLine.hasOption('m')).withBasePath(Paths.get(commandLine.getOptionValue('d'), new String[0]));
        if (commandLine.hasOption('t')) {
            chronicleHistoryReader.withTimeUnit(TimeUnit.valueOf(commandLine.getOptionValue('t')));
        }
        if (commandLine.hasOption('i')) {
            chronicleHistoryReader.withIgnore(Long.parseLong(commandLine.getOptionValue('i')));
        }
        if (commandLine.hasOption('w')) {
            chronicleHistoryReader.withMeasurementWindow(Long.parseLong(commandLine.getOptionValue('w')));
        }
        if (commandLine.hasOption('u')) {
            chronicleHistoryReader.withSummaryOutput(Integer.parseInt(commandLine.getOptionValue('u')));
        }
    }

    @NotNull
    protected HistoryReader chronicleHistoryReader() {
        return HistoryReader.create();
    }

    protected CommandLine parseCommandLine(@NotNull String[] args, Options options) {
        DefaultParser parser = new DefaultParser();
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(options, args);
            if (commandLine.hasOption('h')) {
                this.printHelpAndExit(options, 0);
            }
        }
        catch (ParseException e) {
            this.printHelpAndExit(options, 1);
        }
        return commandLine;
    }

    protected void printHelpAndExit(Options options, int status) {
        PrintWriter writer = new PrintWriter(System.out);
        new HelpFormatter().printHelp(writer, 180, this.getClass().getSimpleName(), null, options, 1, 3, null, true);
        writer.flush();
        System.exit(status);
    }

    @NotNull
    protected Options options() {
        Options options = new Options();
        InternalReaderMain.addOption(options, "d", "directory", true, "Directory containing chronicle queue files", true);
        InternalReaderMain.addOption(options, "h", "help-message", false, "Print this help and exit", false);
        InternalReaderMain.addOption(options, "t", "time unit", true, "Time unit. Default nanos", false);
        InternalReaderMain.addOption(options, "i", "ignore", true, "How many items to ignore from start", false);
        InternalReaderMain.addOption(options, "w", "window", true, "Window duration in time unit. Instead of one output at the end, will output every window period", false);
        InternalReaderMain.addOption(options, "u", "histo offset", true, "Summary output. Instead of histograms, will show one value only, in CSV format. Set this to 0 for 50th, 1 for 90th etc., -1 for worst", false);
        options.addOption(new Option("p", false, "Show progress"));
        options.addOption(new Option("m", false, "By method"));
        return options;
    }
}

