/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.splittabledofn;

import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class RestrictionTrackers {
    public static <RestrictionT, PositionT> @UnknownKeyFor @NonNull @Initialized RestrictionTracker<RestrictionT, PositionT> observe(@UnknownKeyFor @NonNull @Initialized RestrictionTracker<RestrictionT, PositionT> restrictionTracker, @UnknownKeyFor @NonNull @Initialized ClaimObserver<PositionT> claimObserver) {
        if (restrictionTracker instanceof RestrictionTracker.HasProgress) {
            return new RestrictionTrackerObserverWithProgress<RestrictionT, PositionT>(restrictionTracker, claimObserver);
        }
        return new RestrictionTrackerObserver<RestrictionT, PositionT>(restrictionTracker, claimObserver);
    }

    @ThreadSafe
    private static class RestrictionTrackerObserverWithProgress<@UnknownKeyFor RestrictionT, @UnknownKeyFor PositionT>
    extends RestrictionTrackerObserver<RestrictionT, PositionT>
    implements RestrictionTracker.HasProgress {
        protected RestrictionTrackerObserverWithProgress(@UnknownKeyFor @NonNull @Initialized RestrictionTracker<RestrictionT, PositionT> delegate, @UnknownKeyFor @NonNull @Initialized ClaimObserver<PositionT> claimObserver) {
            super(delegate, claimObserver);
        }

        @Override
        public synchronized @UnknownKeyFor @NonNull @Initialized RestrictionTracker.Progress getProgress() {
            return ((RestrictionTracker.HasProgress)((Object)this.delegate)).getProgress();
        }
    }

    @ThreadSafe
    private static class RestrictionTrackerObserver<@UnknownKeyFor RestrictionT, @UnknownKeyFor PositionT>
    extends RestrictionTracker<RestrictionT, PositionT> {
        protected final @UnknownKeyFor @NonNull @Initialized RestrictionTracker<RestrictionT, PositionT> delegate;
        private final @UnknownKeyFor @NonNull @Initialized ClaimObserver<PositionT> claimObserver;

        protected RestrictionTrackerObserver(@UnknownKeyFor @NonNull @Initialized RestrictionTracker<RestrictionT, PositionT> delegate, @UnknownKeyFor @NonNull @Initialized ClaimObserver<PositionT> claimObserver) {
            this.delegate = delegate;
            this.claimObserver = claimObserver;
        }

        @Override
        public synchronized @UnknownKeyFor @NonNull @Initialized boolean tryClaim(PositionT position) {
            if (this.delegate.tryClaim(position)) {
                this.claimObserver.onClaimed(position);
                return true;
            }
            this.claimObserver.onClaimFailed(position);
            return false;
        }

        @Override
        public synchronized RestrictionT currentRestriction() {
            return this.delegate.currentRestriction();
        }

        @Override
        public synchronized @UnknownKeyFor @NonNull @Initialized SplitResult<RestrictionT> trySplit(@UnknownKeyFor @NonNull @Initialized double fractionOfRemainder) {
            return this.delegate.trySplit(fractionOfRemainder);
        }

        @Override
        public synchronized void checkDone() throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
            this.delegate.checkDone();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized RestrictionTracker.IsBounded isBounded() {
            return this.delegate.isBounded();
        }
    }

    public static interface ClaimObserver<@UnknownKeyFor PositionT> {
        public void onClaimed(PositionT var1);

        public void onClaimFailed(PositionT var1);
    }
}

