/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.util.Collection;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Disposable;
import org.neo4j.driver.internal.shaded.reactor.core.Disposables;
import org.neo4j.driver.internal.shaded.reactor.core.Exceptions;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Flux;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.InnerOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.InternalFluxOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Operators;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.StateLogger;
import org.neo4j.driver.internal.shaded.reactor.core.scheduler.Scheduler;
import org.neo4j.driver.internal.shaded.reactor.util.Logger;
import org.neo4j.driver.internal.shaded.reactor.util.annotation.Nullable;
import org.neo4j.driver.internal.shaded.reactor.util.concurrent.Queues;
import org.neo4j.driver.internal.shaded.reactor.util.context.Context;
import org.reactivestreams.Subscription;

final class FluxBufferTimeout<T, C extends Collection<? super T>>
extends InternalFluxOperator<T, C> {
    final int batchSize;
    final Supplier<C> bufferSupplier;
    final Scheduler timer;
    final long timespan;
    final TimeUnit unit;
    final boolean fairBackpressure;
    final Logger logger;

    FluxBufferTimeout(Flux<T> source, int maxSize, long timespan, TimeUnit unit, Scheduler timer, Supplier<C> bufferSupplier, boolean fairBackpressure) {
        super(source);
        if (timespan <= 0L) {
            throw new IllegalArgumentException("Timeout period must be strictly positive");
        }
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize must be strictly positive");
        }
        this.timer = Objects.requireNonNull(timer, "Timer");
        this.timespan = timespan;
        this.unit = Objects.requireNonNull(unit, "unit");
        this.batchSize = maxSize;
        this.bufferSupplier = Objects.requireNonNull(bufferSupplier, "bufferSupplier");
        this.fairBackpressure = fairBackpressure;
        this.logger = null;
    }

    FluxBufferTimeout(Flux<T> source, int maxSize, long timespan, TimeUnit unit, Scheduler timer, Supplier<C> bufferSupplier, boolean fairBackpressure, Logger logger) {
        super(source);
        if (timespan <= 0L) {
            throw new IllegalArgumentException("Timeout period must be strictly positive");
        }
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize must be strictly positive");
        }
        this.timer = Objects.requireNonNull(timer, "Timer");
        this.timespan = timespan;
        this.unit = Objects.requireNonNull(unit, "unit");
        this.batchSize = maxSize;
        this.bufferSupplier = Objects.requireNonNull(bufferSupplier, "bufferSupplier");
        this.fairBackpressure = fairBackpressure;
        this.logger = logger;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super C> actual) {
        if (this.fairBackpressure) {
            return new BufferTimeoutWithBackpressureSubscriber(actual, this.batchSize, this.timespan, this.unit, this.timer.createWorker(), this.bufferSupplier, null);
        }
        return new BufferTimeoutSubscriber(Operators.serialize(actual), this.batchSize, this.timespan, this.unit, this.timer.createWorker(), this.bufferSupplier);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_ON) {
            return this.timer;
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.ASYNC;
        }
        return super.scanUnsafe(key);
    }

    static final class BufferTimeoutSubscriber<T, C extends Collection<? super T>>
    implements InnerOperator<T, C> {
        final CoreSubscriber<? super C> actual;
        static final int NOT_TERMINATED = 0;
        static final int TERMINATED_WITH_SUCCESS = 1;
        static final int TERMINATED_WITH_ERROR = 2;
        static final int TERMINATED_WITH_CANCEL = 3;
        final int batchSize;
        final long timespan;
        final TimeUnit unit;
        final Scheduler.Worker timer;
        final Runnable flushTask;
        protected Subscription subscription;
        volatile int terminated = 0;
        static final AtomicIntegerFieldUpdater<BufferTimeoutSubscriber> TERMINATED = AtomicIntegerFieldUpdater.newUpdater(BufferTimeoutSubscriber.class, "terminated");
        volatile long requested;
        static final AtomicLongFieldUpdater<BufferTimeoutSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(BufferTimeoutSubscriber.class, "requested");
        volatile long outstanding;
        static final AtomicLongFieldUpdater<BufferTimeoutSubscriber> OUTSTANDING = AtomicLongFieldUpdater.newUpdater(BufferTimeoutSubscriber.class, "outstanding");
        volatile int index = 0;
        static final AtomicIntegerFieldUpdater<BufferTimeoutSubscriber> INDEX = AtomicIntegerFieldUpdater.newUpdater(BufferTimeoutSubscriber.class, "index");
        volatile Disposable timespanRegistration;
        final Supplier<C> bufferSupplier;
        volatile C values;

        BufferTimeoutSubscriber(CoreSubscriber<? super C> actual, int maxSize, long timespan, TimeUnit unit, Scheduler.Worker timer, Supplier<C> bufferSupplier) {
            this.actual = actual;
            this.timespan = timespan;
            this.unit = unit;
            this.timer = timer;
            this.flushTask = () -> {
                if (this.terminated == 0) {
                    int index;
                    do {
                        if ((index = this.index) != 0) continue;
                        return;
                    } while (!INDEX.compareAndSet(this, index, 0));
                    this.flushCallback(null);
                }
            };
            this.batchSize = maxSize;
            this.bufferSupplier = bufferSupplier;
        }

        protected void doOnSubscribe() {
            this.values = (Collection)this.bufferSupplier.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void nextCallback(T value) {
            BufferTimeoutSubscriber bufferTimeoutSubscriber = this;
            synchronized (bufferTimeoutSubscriber) {
                if (OUTSTANDING.decrementAndGet(this) < 0L) {
                    this.actual.onError(Exceptions.failWithOverflow("Unrequested element received"));
                    Context ctx = this.actual.currentContext();
                    Operators.onDiscard(value, ctx);
                    Operators.onDiscardMultiple(this.values, ctx);
                    return;
                }
                Object v = this.values;
                if (v == null) {
                    this.values = v = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The bufferSupplier returned a null buffer");
                }
                v.add(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void flushCallback(@Nullable T ev) {
            C v;
            boolean flush = false;
            BufferTimeoutSubscriber bufferTimeoutSubscriber = this;
            synchronized (bufferTimeoutSubscriber) {
                v = this.values;
                if (v != null && !v.isEmpty()) {
                    this.values = (Collection)this.bufferSupplier.get();
                    flush = true;
                }
            }
            if (flush) {
                long r = this.requested;
                if (r != 0L) {
                    if (r != Long.MAX_VALUE) {
                        do {
                            long next;
                            if (!REQUESTED.compareAndSet(this, r, next = r - 1L)) continue;
                            this.actual.onNext(v);
                            return;
                        } while ((r = this.requested) > 0L);
                    } else {
                        this.actual.onNext(v);
                        return;
                    }
                }
                this.cancel();
                this.actual.onError(Exceptions.failWithOverflow("Could not emit buffer due to lack of requests"));
                Operators.onDiscardMultiple(v, this.actual.currentContext());
            }
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.subscription;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.terminated == 3;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.terminated == 2 || this.terminated == 1;
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return this.requested;
            }
            if (key == Scannable.Attr.CAPACITY) {
                return this.batchSize;
            }
            if (key == Scannable.Attr.BUFFERED) {
                return this.batchSize - this.index;
            }
            if (key == Scannable.Attr.RUN_ON) {
                return this.timer;
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.ASYNC;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        public void onNext(T value) {
            boolean flush;
            int index;
            while (!INDEX.compareAndSet(this, index - 1, (flush = (index = this.index + 1) % this.batchSize == 0) ? 0 : index)) {
            }
            if (index == 1) {
                try {
                    this.timespanRegistration = this.timer.schedule(this.flushTask, this.timespan, this.unit);
                }
                catch (RejectedExecutionException ree) {
                    Context ctx = this.actual.currentContext();
                    this.onError(Operators.onRejectedExecution(ree, this.subscription, null, value, ctx));
                    Operators.onDiscard(value, ctx);
                    return;
                }
            }
            this.nextCallback(value);
            if (flush) {
                if (this.timespanRegistration != null) {
                    this.timespanRegistration.dispose();
                    this.timespanRegistration = null;
                }
                this.flushCallback(value);
            }
        }

        void checkedComplete() {
            try {
                this.flushCallback(null);
            }
            finally {
                this.actual.onComplete();
            }
        }

        final boolean isCompleted() {
            return this.terminated == 1;
        }

        final boolean isFailed() {
            return this.terminated == 2;
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.addCap(REQUESTED, this, n);
                if (this.terminated != 0) {
                    return;
                }
                if (this.batchSize == Integer.MAX_VALUE || n == Long.MAX_VALUE) {
                    this.requestMore(Long.MAX_VALUE);
                } else {
                    long requestLimit = Operators.multiplyCap(this.requested, this.batchSize);
                    if (requestLimit > this.outstanding) {
                        this.requestMore(requestLimit - this.outstanding);
                    }
                }
            }
        }

        final void requestMore(long n) {
            Subscription s = this.subscription;
            if (s != null) {
                Operators.addCap(OUTSTANDING, this, n);
                s.request(n);
            }
        }

        @Override
        public CoreSubscriber<? super C> actual() {
            return this.actual;
        }

        public void onComplete() {
            if (TERMINATED.compareAndSet(this, 0, 1)) {
                this.timer.dispose();
                this.checkedComplete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable throwable) {
            if (TERMINATED.compareAndSet(this, 0, 2)) {
                this.timer.dispose();
                Context ctx = this.actual.currentContext();
                BufferTimeoutSubscriber bufferTimeoutSubscriber = this;
                synchronized (bufferTimeoutSubscriber) {
                    C v = this.values;
                    if (v != null) {
                        Operators.onDiscardMultiple(v, ctx);
                        v.clear();
                        this.values = null;
                    }
                }
                this.actual.onError(throwable);
            }
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.subscription, s)) {
                this.subscription = s;
                this.doOnSubscribe();
                this.actual.onSubscribe(this);
            }
        }

        public void cancel() {
            if (TERMINATED.compareAndSet(this, 0, 3)) {
                C v;
                this.timer.dispose();
                Subscription s = this.subscription;
                if (s != null) {
                    this.subscription = null;
                    s.cancel();
                }
                if ((v = this.values) != null) {
                    Operators.onDiscardMultiple(v, this.actual.currentContext());
                    v.clear();
                }
            }
        }
    }

    static final class BufferTimeoutWithBackpressureSubscriber<T, C extends Collection<? super T>>
    implements InnerOperator<T, C> {
        @Nullable
        private final Logger logger;
        @Nullable
        private final StateLogger stateLogger;
        private final CoreSubscriber<? super C> actual;
        private final int batchSize;
        private final int prefetch;
        private final int replenishMark;
        private final long timeSpan;
        private final TimeUnit unit;
        private final Scheduler.Worker timer;
        private final Supplier<C> bufferSupplier;
        private final Disposable.Swap currentTimeoutTask = Disposables.swap();
        private final Queue<T> queue;
        @Nullable
        private Subscription subscription;
        @Nullable
        private Throwable error;
        private boolean done;
        private int outstanding;
        volatile long requested;
        private static final AtomicLongFieldUpdater<BufferTimeoutWithBackpressureSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(BufferTimeoutWithBackpressureSubscriber.class, "requested");
        private volatile long state;
        private static final AtomicLongFieldUpdater<BufferTimeoutWithBackpressureSubscriber> STATE = AtomicLongFieldUpdater.newUpdater(BufferTimeoutWithBackpressureSubscriber.class, "state");
        static final long CANCELLED_FLAG = Long.MIN_VALUE;
        static final long TERMINATED_FLAG = 0x4000000000000000L;
        static final long HAS_WORK_IN_PROGRESS_FLAG = 0x2000000000000000L;
        static final long TIMEOUT_FLAG = 0x1000000000000000L;
        static final long REQUESTED_INDEX_MASK = 0xFFFFFFF00000000L;
        static final long INDEX_MASK = 0xFFFFFFFFL;
        private static final int INDEX_SHIFT = 0;
        private static final int REQUESTED_INDEX_SHIFT = 32;

        public BufferTimeoutWithBackpressureSubscriber(CoreSubscriber<? super C> actual, int batchSize, long timeSpan, TimeUnit unit, Scheduler.Worker timer, Supplier<C> bufferSupplier, @Nullable Logger logger) {
            this.actual = actual;
            this.batchSize = batchSize;
            this.timeSpan = timeSpan;
            this.unit = unit;
            this.timer = timer;
            this.bufferSupplier = bufferSupplier;
            this.logger = logger;
            this.stateLogger = logger != null ? new StateLogger(logger) : null;
            this.prefetch = batchSize << 2;
            this.replenishMark = batchSize << 1;
            this.queue = Queues.get(this.prefetch).get();
        }

        private static void trace(Logger logger, String msg) {
            logger.trace(String.format("[%s][%s]", Thread.currentThread().getId(), msg));
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.subscription, s)) {
                this.subscription = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public CoreSubscriber<? super C> actual() {
            return this.actual;
        }

        public void request(long n) {
            if (this.logger != null) {
                BufferTimeoutWithBackpressureSubscriber.trace(this.logger, "request " + n);
            }
            if (Operators.validate(n)) {
                long previouslyRequested = Operators.addCap(REQUESTED, this, n);
                if (previouslyRequested == Long.MAX_VALUE) {
                    return;
                }
                long previousState = BufferTimeoutWithBackpressureSubscriber.forceAddWork(this, BufferTimeoutWithBackpressureSubscriber::incrementRequestIndex);
                if (!BufferTimeoutWithBackpressureSubscriber.hasWorkInProgress(previousState)) {
                    this.drain(previouslyRequested == 0L);
                }
            }
        }

        public void onNext(T t) {
            long previousState;
            if (this.logger != null) {
                BufferTimeoutWithBackpressureSubscriber.trace(this.logger, "onNext " + t);
            }
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return;
            }
            boolean enqueued = this.queue.offer(t);
            if (!enqueued) {
                this.error = Operators.onOperatorError(this.subscription, Exceptions.failWithOverflow("Queue is full: Reactive Streams source doesn't respect backpressure"), t, this.actual.currentContext());
                Operators.onDiscard(t, this.actual.currentContext());
            }
            if (enqueued) {
                previousState = BufferTimeoutWithBackpressureSubscriber.forceAddWork(this, state -> BufferTimeoutWithBackpressureSubscriber.incrementIndex(state, 1));
                if (BufferTimeoutWithBackpressureSubscriber.getIndex(previousState) == 0L) {
                    try {
                        Disposable disposable = this.timer.schedule(this::bufferTimedOut, this.timeSpan, this.unit);
                        this.currentTimeoutTask.update(disposable);
                    }
                    catch (RejectedExecutionException e) {
                        this.error = Operators.onRejectedExecution(e, this.subscription, null, t, this.actual.currentContext());
                        previousState = BufferTimeoutWithBackpressureSubscriber.forceAddWork(this, BufferTimeoutWithBackpressureSubscriber::setTerminated);
                    }
                }
            } else {
                previousState = BufferTimeoutWithBackpressureSubscriber.forceAddWork(this, BufferTimeoutWithBackpressureSubscriber::setTerminated);
            }
            if (!BufferTimeoutWithBackpressureSubscriber.hasWorkInProgress(previousState)) {
                this.drain(false);
            }
        }

        void bufferTimedOut() {
            if (this.logger != null) {
                BufferTimeoutWithBackpressureSubscriber.trace(this.logger, "timedOut");
            }
            if (this.done) {
                return;
            }
            long previousState = BufferTimeoutWithBackpressureSubscriber.forceAddWork(this, BufferTimeoutWithBackpressureSubscriber::setTimedOut);
            if (!BufferTimeoutWithBackpressureSubscriber.hasWorkInProgress(previousState)) {
                this.drain(false);
            }
        }

        public void onError(Throwable t) {
            if (this.logger != null) {
                BufferTimeoutWithBackpressureSubscriber.trace(this.logger, "onError " + t);
            }
            if (this.done) {
                Operators.onErrorDropped(t, this.actual.currentContext());
                return;
            }
            this.error = t;
            long previousState = BufferTimeoutWithBackpressureSubscriber.forceAddWork(this, BufferTimeoutWithBackpressureSubscriber::setTerminated);
            if (!BufferTimeoutWithBackpressureSubscriber.hasWorkInProgress(previousState)) {
                this.drain(false);
            }
        }

        public void onComplete() {
            if (this.logger != null) {
                BufferTimeoutWithBackpressureSubscriber.trace(this.logger, "onComplete");
            }
            if (this.done) {
                return;
            }
            long previousState = BufferTimeoutWithBackpressureSubscriber.forceAddWork(this, BufferTimeoutWithBackpressureSubscriber::setTerminated);
            if (!BufferTimeoutWithBackpressureSubscriber.hasWorkInProgress(previousState)) {
                this.drain(false);
            }
        }

        public void cancel() {
            long previousState;
            if (this.logger != null) {
                BufferTimeoutWithBackpressureSubscriber.trace(this.logger, "cancel");
            }
            if (this.done || BufferTimeoutWithBackpressureSubscriber.isCancelled(this.state)) {
                return;
            }
            if (this.subscription != null) {
                this.subscription.cancel();
            }
            if (!BufferTimeoutWithBackpressureSubscriber.hasWorkInProgress(previousState = BufferTimeoutWithBackpressureSubscriber.forceAddWork(this, BufferTimeoutWithBackpressureSubscriber::setCancelled))) {
                this.drain(false);
            }
        }

        private void drain(boolean resumeDemand) {
            if (this.logger != null) {
                BufferTimeoutWithBackpressureSubscriber.trace(this.logger, "drain start");
            }
            while (true) {
                int remaining;
                long previousState;
                long currentState = previousState = this.state;
                if (this.done || BufferTimeoutWithBackpressureSubscriber.isCancelled(currentState)) {
                    if (this.logger != null) {
                        BufferTimeoutWithBackpressureSubscriber.trace(this.logger, "Discarding entire queue of " + this.queue.size());
                    }
                    Operators.onDiscardQueueWithClear(this.queue, this.currentContext(), null);
                    if (BufferTimeoutWithBackpressureSubscriber.hasWorkInProgress(currentState = BufferTimeoutWithBackpressureSubscriber.tryClearWip(this, currentState))) continue;
                    return;
                }
                long index = BufferTimeoutWithBackpressureSubscriber.getIndex(currentState);
                long currentRequest = this.requested;
                boolean shouldFlush = currentRequest > 0L && (resumeDemand || BufferTimeoutWithBackpressureSubscriber.isTimedOut(currentState) || BufferTimeoutWithBackpressureSubscriber.isTerminated(currentState) || index >= (long)this.batchSize);
                int consumed = 0;
                if (this.logger != null) {
                    BufferTimeoutWithBackpressureSubscriber.trace(this.logger, "should flush: " + shouldFlush + " currentRequest: " + currentRequest + " index: " + index + " isTerminated: " + BufferTimeoutWithBackpressureSubscriber.isTerminated(currentState) + " isTimedOut: " + BufferTimeoutWithBackpressureSubscriber.isTimedOut(currentState));
                }
                if (shouldFlush) {
                    this.currentTimeoutTask.update(null);
                    do {
                        int consumedNow = this.flush();
                        if (this.logger != null) {
                            BufferTimeoutWithBackpressureSubscriber.trace(this.logger, "flushed: " + consumedNow);
                        }
                        resumeDemand = false;
                        if (consumedNow == 0) break;
                        consumed += consumedNow;
                        if (currentRequest == Long.MAX_VALUE) continue;
                        currentRequest = REQUESTED.decrementAndGet(this);
                    } while (currentRequest != 0L);
                }
                boolean terminated = BufferTimeoutWithBackpressureSubscriber.isTerminated(currentState);
                if (consumed > 0) {
                    this.outstanding -= consumed;
                }
                if (!terminated && currentRequest > 0L && (remaining = this.outstanding) < this.replenishMark) {
                    this.requestMore(this.prefetch - remaining);
                }
                if (terminated && this.queue.isEmpty()) {
                    this.done = true;
                    if (this.logger != null) {
                        BufferTimeoutWithBackpressureSubscriber.trace(this.logger, "terminated! error: " + this.error + " queue size: " + this.queue.size());
                    }
                    if (this.error != null) {
                        Operators.onDiscardQueueWithClear(this.queue, this.currentContext(), null);
                        this.actual.onError(this.error);
                    } else if (this.queue.isEmpty()) {
                        this.actual.onComplete();
                    }
                }
                if (consumed > 0) {
                    int toDecrement = -consumed;
                    currentState = BufferTimeoutWithBackpressureSubscriber.forceUpdate(this, state -> BufferTimeoutWithBackpressureSubscriber.resetTimeout(BufferTimeoutWithBackpressureSubscriber.incrementIndex(state, toDecrement)));
                    previousState = BufferTimeoutWithBackpressureSubscriber.resetTimeout(BufferTimeoutWithBackpressureSubscriber.incrementIndex(previousState, toDecrement));
                }
                if (!BufferTimeoutWithBackpressureSubscriber.hasWorkInProgress(currentState = BufferTimeoutWithBackpressureSubscriber.tryClearWip(this, previousState))) {
                    if (this.logger != null) {
                        BufferTimeoutWithBackpressureSubscriber.trace(this.logger, "drain done");
                    }
                    return;
                }
                if (this.logger == null) continue;
                BufferTimeoutWithBackpressureSubscriber.trace(this.logger, "drain repeat");
            }
        }

        int flush() {
            T element = this.queue.poll();
            if (element == null) {
                return 0;
            }
            Collection buffer = (Collection)this.bufferSupplier.get();
            int i = 0;
            do {
                buffer.add(element);
            } while (++i < this.batchSize && (element = this.queue.poll()) != null);
            this.actual.onNext(buffer);
            return i;
        }

        private void requestMore(int n) {
            if (this.logger != null) {
                BufferTimeoutWithBackpressureSubscriber.trace(this.logger, "requestMore " + n);
            }
            this.outstanding += n;
            Objects.requireNonNull(this.subscription).request((long)n);
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.subscription;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return BufferTimeoutWithBackpressureSubscriber.isCancelled(this.state);
            }
            if (key == Scannable.Attr.TERMINATED) {
                return BufferTimeoutWithBackpressureSubscriber.isTerminated(this.state);
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return this.requested;
            }
            if (key == Scannable.Attr.CAPACITY) {
                return this.prefetch;
            }
            if (key == Scannable.Attr.BUFFERED) {
                return this.queue.size();
            }
            if (key == Scannable.Attr.RUN_ON) {
                return this.timer;
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.ASYNC;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        private static long bitwiseIncrement(long state, long mask, long shift, int amount) {
            long shiftAndAdd = ((state & mask) >> (int)shift) + (long)amount;
            long shiftBackAndLimit = shiftAndAdd << (int)shift & mask;
            long clearedState = state & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            return clearedState | shiftBackAndLimit;
        }

        private static boolean isTerminated(long state) {
            return (state & 0x4000000000000000L) == 0x4000000000000000L;
        }

        private static long setTerminated(long state) {
            return state | 0x4000000000000000L;
        }

        private static boolean isCancelled(long state) {
            return (state & Long.MIN_VALUE) == Long.MIN_VALUE;
        }

        private static long setCancelled(long state) {
            return state | Long.MIN_VALUE;
        }

        private static long incrementRequestIndex(long state) {
            return BufferTimeoutWithBackpressureSubscriber.bitwiseIncrement(state, 0xFFFFFFF00000000L, 32L, 1);
        }

        private static long getIndex(long state) {
            return (state & 0xFFFFFFFFL) >> 0;
        }

        private static long incrementIndex(long state, int amount) {
            return BufferTimeoutWithBackpressureSubscriber.bitwiseIncrement(state, 0xFFFFFFFFL, 0L, amount);
        }

        private static boolean hasWorkInProgress(long state) {
            return (state & 0x2000000000000000L) == 0x2000000000000000L;
        }

        private static long setWorkInProgress(long state) {
            return state | 0x2000000000000000L;
        }

        private static long setTimedOut(long state) {
            return state | 0x1000000000000000L;
        }

        private static long resetTimeout(long state) {
            return state & 0xEFFFFFFFFFFFFFFFL;
        }

        private static boolean isTimedOut(long state) {
            return (state & 0x1000000000000000L) == 0x1000000000000000L;
        }

        private static long forceAddWork(BufferTimeoutWithBackpressureSubscriber<?, ?> instance, Function<Long, Long> f) {
            long nextState;
            long previousState;
            while (!STATE.compareAndSet(instance, previousState = instance.state, nextState = f.apply(previousState) | 0x2000000000000000L)) {
            }
            if (instance.stateLogger != null) {
                instance.stateLogger.log(instance.toString(), "faw", previousState, nextState);
            }
            return previousState;
        }

        private static long forceUpdate(BufferTimeoutWithBackpressureSubscriber<?, ?> instance, Function<Long, Long> f) {
            long nextState;
            long previousState;
            while (!STATE.compareAndSet(instance, previousState = instance.state, nextState = f.apply(previousState).longValue())) {
            }
            if (instance.stateLogger != null) {
                instance.stateLogger.log(instance.toString(), "fup", previousState, nextState);
            }
            return nextState;
        }

        private static <T, C extends Collection<? super T>> long tryClearWip(BufferTimeoutWithBackpressureSubscriber<T, C> instance, long expectedState) {
            long nextState;
            long currentState;
            do {
                if (expectedState == (currentState = instance.state)) continue;
                return currentState;
            } while (!STATE.compareAndSet(instance, currentState, nextState = currentState & 0xDFFFFFFFFFFFFFFFL & 0xF0000000FFFFFFFFL));
            if (instance.stateLogger != null) {
                instance.stateLogger.log(instance.toString(), "wcl", currentState, nextState);
            }
            return nextState;
        }
    }
}

