/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.s2a.internal.handshaker;

import com.google.errorprone.annotations.Immutable;
import io.grpc.s2a.internal.handshaker.AuthenticationMechanism;
import io.grpc.s2a.internal.handshaker.S2AIdentity;
import io.grpc.s2a.internal.handshaker.tokenmanager.AccessTokenManager;
import java.util.Optional;

@Immutable
final class GetAuthenticationMechanisms {
    private static final Optional<AccessTokenManager> TOKEN_MANAGER = AccessTokenManager.create();

    static Optional<AuthenticationMechanism> getAuthMechanism(Optional<S2AIdentity> localIdentity) {
        if (!TOKEN_MANAGER.isPresent()) {
            return Optional.empty();
        }
        AccessTokenManager manager = TOKEN_MANAGER.get();
        if (!localIdentity.isPresent()) {
            return Optional.of(AuthenticationMechanism.newBuilder().setToken(manager.getDefaultToken()).build());
        }
        return Optional.of(AuthenticationMechanism.newBuilder().setIdentity(localIdentity.get().getIdentity()).setToken(manager.getToken(localIdentity.get())).build());
    }

    private GetAuthenticationMechanisms() {
    }
}

