/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p60p1.io.netty.handler.ssl;

import org.apache.beam.vendor.grpc.v1p60p1.io.netty.buffer.ByteBufAllocator;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.channel.ChannelHandler;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.channel.ChannelHandlerContext;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.handler.codec.DecoderException;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.handler.ssl.AbstractSniHandler;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.handler.ssl.SslContext;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.handler.ssl.SslHandler;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.util.AsyncMapping;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.util.DomainNameMapping;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.util.Mapping;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.util.ReferenceCountUtil;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.util.concurrent.Future;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.util.concurrent.Promise;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.util.internal.ObjectUtil;
import org.apache.beam.vendor.grpc.v1p60p1.io.netty.util.internal.PlatformDependent;

public class SniHandler
extends AbstractSniHandler<SslContext> {
    private static final Selection EMPTY_SELECTION = new Selection(null, null);
    protected final AsyncMapping<String, SslContext> mapping;
    private volatile Selection selection = EMPTY_SELECTION;

    public SniHandler(Mapping<? super String, ? extends SslContext> mapping) {
        this(new AsyncMappingAdapter(mapping));
    }

    public SniHandler(Mapping<? super String, ? extends SslContext> mapping, int maxClientHelloLength, long handshakeTimeoutMillis) {
        this(new AsyncMappingAdapter(mapping), maxClientHelloLength, handshakeTimeoutMillis);
    }

    public SniHandler(DomainNameMapping<? extends SslContext> mapping) {
        this((Mapping<? super String, ? extends SslContext>)mapping);
    }

    public SniHandler(AsyncMapping<? super String, ? extends SslContext> mapping) {
        this(mapping, 0, 0L);
    }

    public SniHandler(AsyncMapping<? super String, ? extends SslContext> mapping, int maxClientHelloLength, long handshakeTimeoutMillis) {
        super(maxClientHelloLength, handshakeTimeoutMillis);
        this.mapping = ObjectUtil.checkNotNull(mapping, "mapping");
    }

    public SniHandler(Mapping<? super String, ? extends SslContext> mapping, long handshakeTimeoutMillis) {
        this(new AsyncMappingAdapter(mapping), handshakeTimeoutMillis);
    }

    public SniHandler(AsyncMapping<? super String, ? extends SslContext> mapping, long handshakeTimeoutMillis) {
        this(mapping, 0, handshakeTimeoutMillis);
    }

    public String hostname() {
        return this.selection.hostname;
    }

    public SslContext sslContext() {
        return this.selection.context;
    }

    @Override
    protected Future<SslContext> lookup(ChannelHandlerContext ctx, String hostname) throws Exception {
        return this.mapping.map(hostname, ctx.executor().newPromise());
    }

    @Override
    protected final void onLookupComplete(ChannelHandlerContext ctx, String hostname, Future<SslContext> future) throws Exception {
        if (!future.isSuccess()) {
            Throwable cause = future.cause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new DecoderException("failed to get the SslContext for " + hostname, cause);
        }
        SslContext sslContext = future.getNow();
        this.selection = new Selection(sslContext, hostname);
        try {
            this.replaceHandler(ctx, hostname, sslContext);
        }
        catch (Throwable cause) {
            this.selection = EMPTY_SELECTION;
            PlatformDependent.throwException(cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceHandler(ChannelHandlerContext ctx, String hostname, SslContext sslContext) throws Exception {
        SslHandler sslHandler = null;
        try {
            sslHandler = this.newSslHandler(sslContext, ctx.alloc());
            ctx.pipeline().replace(this, SslHandler.class.getName(), (ChannelHandler)sslHandler);
            sslHandler = null;
        }
        finally {
            if (sslHandler != null) {
                ReferenceCountUtil.safeRelease(sslHandler.engine());
            }
        }
    }

    protected SslHandler newSslHandler(SslContext context, ByteBufAllocator allocator) {
        SslHandler sslHandler = context.newHandler(allocator);
        sslHandler.setHandshakeTimeoutMillis(this.handshakeTimeoutMillis);
        return sslHandler;
    }

    private static final class Selection {
        final SslContext context;
        final String hostname;

        Selection(SslContext context, String hostname) {
            this.context = context;
            this.hostname = hostname;
        }
    }

    private static final class AsyncMappingAdapter
    implements AsyncMapping<String, SslContext> {
        private final Mapping<? super String, ? extends SslContext> mapping;

        private AsyncMappingAdapter(Mapping<? super String, ? extends SslContext> mapping) {
            this.mapping = ObjectUtil.checkNotNull(mapping, "mapping");
        }

        @Override
        public Future<SslContext> map(String input, Promise<SslContext> promise) {
            SslContext context;
            try {
                context = this.mapping.map(input);
            }
            catch (Throwable cause) {
                return promise.setFailure(cause);
            }
            return promise.setSuccess(context);
        }
    }
}

